/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.maven.utils;

import org.eclipse.aether.collection.DependencyCollectionContext;
import org.eclipse.aether.collection.DependencyTraverser;
import org.eclipse.aether.graph.Dependency;

final class ScopeDependencyTraverser
implements DependencyTraverser {
    private final String[] topLevelScopes;
    private final String[] transitiveScopes;
    private final int depth;

    public ScopeDependencyTraverser(String[] topLevelScopes, String[] transitiveScopes) {
        this(topLevelScopes, transitiveScopes, 0);
    }

    private ScopeDependencyTraverser(String[] topLevelScopes, String[] transitiveScopes, int depth) {
        this.topLevelScopes = topLevelScopes;
        this.transitiveScopes = transitiveScopes;
        this.depth = depth;
    }

    private boolean hasRequiredScope(Dependency dep) {
        String scope = dep.getScope();
        if (scope == null || scope.isEmpty()) {
            scope = "compile";
        }
        for (String s : this.depth > 1 ? this.transitiveScopes : this.topLevelScopes) {
            if (!s.equals(scope)) continue;
            return true;
        }
        return false;
    }

    public boolean traverseDependency(Dependency dependency) {
        return this.hasRequiredScope(dependency);
    }

    public DependencyTraverser deriveChildTraverser(DependencyCollectionContext context) {
        return this.depth > 1 ? this : new ScopeDependencyTraverser(this.topLevelScopes, this.transitiveScopes, this.depth + 1);
    }
}

