/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.maven;

import com.ximpleware.AutoPilot;
import com.ximpleware.ModifyException;
import com.ximpleware.NavException;
import com.ximpleware.TranscodeException;
import com.ximpleware.VTDGen;
import com.ximpleware.VTDNav;
import com.ximpleware.XMLModifier;
import com.ximpleware.XPathEvalException;
import com.ximpleware.XPathParseException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.revapi.AnalysisResult;
import org.revapi.PipelineConfiguration;
import org.revapi.base.CollectingReporter;
import org.revapi.maven.AbstractRevapiMojo;
import org.revapi.maven.Analyzer;
import org.revapi.maven.AnalyzerBuilder;
import org.revapi.maven.ApiBreakageHintingReporter;
import org.revapi.maven.ApiChangeLevel;
import org.revapi.maven.MavenArchive;
import org.revapi.maven.PipelineConfigurationParser;
import org.revapi.maven.Version;
import org.revapi.maven.XmlUtil;

abstract class AbstractVersionModifyingMojo
extends AbstractRevapiMojo {
    @Component
    protected MavenSession mavenSession;
    @Parameter(property="revapi.singleVersionForAllModules", defaultValue="false")
    private boolean singleVersionForAllModules;
    @Parameter(property="revapi.disallowedExtensions", defaultValue="org.revapi.basic.SemverIgnoreTransform")
    protected String disallowedExtensions;
    @Parameter(property="revapi.forceVersionUpdate", defaultValue="false")
    private boolean forceVersionUpdate;
    @Parameter(property="revapi.preserveNewerVersion", defaultValue="true")
    private boolean preserveNewerVersion;
    private boolean preserveSuffix;
    private String replacementSuffix;

    AbstractVersionModifyingMojo() {
    }

    public boolean isPreserveSuffix() {
        return this.preserveSuffix;
    }

    void setPreserveSuffix(boolean preserveSuffix) {
        this.preserveSuffix = preserveSuffix;
    }

    public String getReplacementSuffix() {
        return this.replacementSuffix;
    }

    void setReplacementSuffix(String replacementSuffix) {
        this.replacementSuffix = replacementSuffix;
    }

    public boolean isSingleVersionForAllModules() {
        return this.singleVersionForAllModules;
    }

    @Override
    public void doExecute() throws MojoExecutionException, MojoFailureException {
        ApiChangeLevel changeLevel;
        block27: {
            AnalysisResults analysisResults;
            if (!this.initializeComparisonArtifacts()) {
                AnalyzerBuilder.Result bld = this.buildAnalyzer(this.project, PipelineConfiguration.builder(), CollectingReporter.class, Collections.emptyMap());
                DefaultArtifact newArtifact = new DefaultArtifact(bld.newArtifacts[0]);
                analysisResults = new AnalysisResults(ApiChangeLevel.NO_CHANGE, newArtifact.getVersion());
            } else {
                analysisResults = this.analyzeProject(this.project);
            }
            if (analysisResults == null) {
                analysisResults = new AnalysisResults(ApiChangeLevel.NO_CHANGE, this.newVersion);
            }
            changeLevel = analysisResults.apiChangeLevel;
            if (this.singleVersionForAllModules) {
                File changesFile = this.getChangesFile();
                try (PrintWriter out = new PrintWriter(new FileOutputStream(changesFile, true));){
                    out.println(this.project.getArtifact().toString() + "=" + (Object)((Object)changeLevel) + "," + analysisResults.baseVersion);
                    break block27;
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Failure while updating the changes tracking file.", (Exception)e);
                }
            }
            Version v = this.nextVersion(analysisResults.baseVersion, this.project.getVersion(), changeLevel);
            this.updateProjectVersion(this.project, v);
        }
        if (this.singleVersionForAllModules && this.project.equals(this.mavenSession.getProjects().get(this.mavenSession.getProjects().size() - 1))) {
            try (BufferedReader rdr = new BufferedReader(new FileReader(this.getChangesFile()));){
                String line;
                HashMap<String, AnalysisResults> projectChanges = new HashMap<String, AnalysisResults>();
                while ((line = rdr.readLine()) != null) {
                    int equalsIdx = line.indexOf(61);
                    String projectGav = line.substring(0, equalsIdx);
                    String changeAndBaseVersion = line.substring(equalsIdx + 1);
                    int commaIdx = changeAndBaseVersion.indexOf(44);
                    String change = changeAndBaseVersion.substring(0, commaIdx);
                    String baseVersion = changeAndBaseVersion.substring(commaIdx + 1);
                    changeLevel = ApiChangeLevel.valueOf(change);
                    projectChanges.put(projectGav, new AnalysisResults(changeLevel, baseVersion));
                }
                HashSet<MavenProject> roots = new HashSet<MavenProject>();
                HashMap children = new HashMap();
                ArrayDeque unprocessed = new ArrayDeque(this.mavenSession.getProjects());
                while (!unprocessed.isEmpty()) {
                    MavenProject pr = (MavenProject)unprocessed.pop();
                    if (!projectChanges.containsKey(pr.getArtifact().toString())) continue;
                    MavenProject pa = pr.getParent();
                    if (roots.contains(pa)) {
                        roots.remove(pr);
                        AnalysisResults paR = (AnalysisResults)projectChanges.get(pa.getArtifact().toString());
                        AnalysisResults prR = (AnalysisResults)projectChanges.get(pr.getArtifact().toString());
                        if (prR.apiChangeLevel.ordinal() > paR.apiChangeLevel.ordinal()) {
                            paR.apiChangeLevel = prR.apiChangeLevel;
                        }
                        ((Set)children.get(pa)).add(pr);
                    } else {
                        roots.add(pr);
                    }
                    children.put(pr, new HashSet());
                }
                Iterator it = roots.iterator();
                while (it.hasNext()) {
                    ArrayDeque<MavenProject> tree = new ArrayDeque<MavenProject>();
                    MavenProject p = (MavenProject)it.next();
                    tree.add(p);
                    it.remove();
                    AnalysisResults results = (AnalysisResults)projectChanges.get(p.getArtifact().toString());
                    Version v = this.nextVersion(results.baseVersion, p.getVersion(), results.apiChangeLevel);
                    while (!tree.isEmpty()) {
                        MavenProject current = (MavenProject)tree.pop();
                        this.updateProjectVersion(current, v);
                        Set c = (Set)children.get(current);
                        if (c == null) continue;
                        for (MavenProject cp : c) {
                            this.updateProjectParentVersion(cp, v);
                        }
                        tree.addAll(c);
                    }
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failure while reading the changes tracking file.", (Exception)e);
            }
        }
    }

    private File getChangesFile() throws MojoExecutionException {
        File targetDir = new File(this.mavenSession.getExecutionRootDirectory(), "target");
        if (!targetDir.exists() && !targetDir.mkdirs()) {
            throw new MojoExecutionException("Failed to create the target directory: " + targetDir);
        }
        File updateVersionsDir = new File(targetDir, "revapi-update-versions");
        if (!updateVersionsDir.exists() && !updateVersionsDir.mkdirs()) {
            throw new MojoExecutionException("Failed to create the revapi-update-versions directory: " + targetDir);
        }
        return new File(updateVersionsDir, "per-project.changes");
    }

    void updateProjectVersion(MavenProject project, Version version) throws MojoExecutionException {
        try {
            int indentationSize;
            try (BufferedReader rdr = new BufferedReader(new FileReader(project.getFile()));){
                indentationSize = XmlUtil.estimateIndentationSize(rdr);
            }
            VTDGen gen = new VTDGen();
            gen.enableIgnoredWhiteSpace(true);
            gen.parseFile(project.getFile().getAbsolutePath(), true);
            VTDNav nav = gen.getNav();
            AutoPilot ap = new AutoPilot(nav);
            XMLModifier mod = new XMLModifier(nav);
            ap.selectXPath("/project/version");
            if (ap.evalXPath() != -1) {
                int textPos = nav.getText();
                mod.updateToken(textPos, version.toString());
            } else {
                if (!this.forceVersionUpdate && !project.getParent().getVersion().equals(version.toString())) {
                    throw new MojoExecutionException("Project " + project.getArtifactId() + " inherits the version from the parent project (" + project.getParent().getVersion() + ") but should have a different version according to the configured rules (" + version.toString() + "). If you wish to insert an explicit version instead of inheriting it, set the " + "revapi.forceVersionUpdate" + " property to true.");
                }
                ap.selectXPath("/project/artifactId");
                if (ap.evalXPath() == -1) {
                    throw new MojoExecutionException("Failed to find artifactId element in the pom.xml of project " + project.getArtifact().getId() + " when trying to insert a version tag after it.");
                }
                StringBuilder versionLine = new StringBuilder();
                versionLine.append('\n');
                for (int i = 0; i < indentationSize; ++i) {
                    versionLine.append(' ');
                }
                versionLine.append("<version>").append(version.toString()).append("</version>");
                mod.insertAfterElement(versionLine.toString());
            }
            try (FileOutputStream out = new FileOutputStream(project.getFile());){
                mod.output((OutputStream)out);
            }
        }
        catch (ModifyException | NavException | TranscodeException | XPathEvalException | XPathParseException | IOException e) {
            throw new MojoExecutionException("Failed to update the version of project " + project, (Exception)e);
        }
    }

    void updateProjectParentVersion(MavenProject project, Version version) throws MojoExecutionException {
        try {
            VTDGen gen = new VTDGen();
            gen.enableIgnoredWhiteSpace(true);
            gen.parseFile(project.getFile().getAbsolutePath(), true);
            VTDNav nav = gen.getNav();
            AutoPilot ap = new AutoPilot(nav);
            ap.selectXPath("namespace-uri(.)");
            String ns = ap.evalXPathToString();
            nav.toElementNS(2, ns, "parent");
            nav.toElementNS(2, ns, "version");
            int pos = nav.getText();
            XMLModifier mod = new XMLModifier(nav);
            mod.updateToken(pos, version.toString());
            try (FileOutputStream out = new FileOutputStream(project.getFile());){
                mod.output((OutputStream)out);
            }
        }
        catch (ModifyException | NavException | TranscodeException | XPathParseException | IOException e) {
            throw new MojoExecutionException("Failed to update the parent version of project " + project, (Exception)e);
        }
    }

    private Version nextVersion(String baseVersion, String currentVersion, ApiChangeLevel changeLevel) {
        Version determined = Version.parse(baseVersion);
        Version current = Version.parse(currentVersion);
        boolean isDev = determined.getMajor() == 0;
        switch (changeLevel) {
            case NO_CHANGE: {
                if (!this.preserveSuffix || !"SNAPSHOT".equals(current.getSuffix())) break;
                determined.setPatch(determined.getPatch() + 1);
                break;
            }
            case NON_BREAKING_CHANGES: {
                if (isDev) {
                    determined.setPatch(determined.getPatch() + 1);
                    break;
                }
                determined.setMinor(determined.getMinor() + 1);
                determined.setPatch(0);
                break;
            }
            case BREAKING_CHANGES: {
                if (isDev) {
                    determined.setMinor(determined.getMinor() + 1);
                    determined.setPatch(0);
                    break;
                }
                determined.setMajor(determined.getMajor() + 1);
                determined.setMinor(0);
                determined.setPatch(0);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unhandled API change level: " + (Object)((Object)changeLevel));
            }
        }
        if (this.preserveNewerVersion) {
            if (current.getMajor() > determined.getMajor()) {
                determined = current;
            } else if (current.getMajor() == determined.getMajor()) {
                if (current.getMinor() > determined.getMinor()) {
                    determined = current;
                } else if (current.getMinor() == determined.getMinor() && current.getPatch() > determined.getPatch()) {
                    determined = current;
                }
            }
        }
        if (this.replacementSuffix != null) {
            String sep = this.replacementSuffix.substring(0, 1);
            String suffix = this.replacementSuffix.substring(1);
            determined.setSuffixSeparator(sep);
            determined.setSuffix(suffix);
        } else {
            determined.setSuffixSeparator(this.preserveSuffix ? current.getSuffixSeparator() : null);
            determined.setSuffix(this.preserveSuffix ? current.getSuffix() : null);
        }
        return determined;
    }

    private AnalysisResults analyzeProject(MavenProject project) throws MojoExecutionException {
        AnalysisResults analysisResults;
        block11: {
            Analyzer analyzer = this.prepareAnalyzer(project, PipelineConfigurationParser.parse(this.pipelineConfiguration), ApiBreakageHintingReporter.class, Collections.emptyMap(), this.getPropertyOverrideMap());
            if (analyzer == null) {
                return null;
            }
            analyzer.resolveArtifacts();
            if (analyzer.getResolvedOldApi() == null) {
                return null;
            }
            Iterator it = analyzer.getResolvedOldApi().getArchives().iterator();
            if (!it.hasNext()) {
                return null;
            }
            MavenArchive old = (MavenArchive)it.next();
            AnalysisResult res = analyzer.analyze();
            try {
                res.throwIfFailed();
                ApiBreakageHintingReporter reporter = (ApiBreakageHintingReporter)res.getExtensions().getFirstExtension(ApiBreakageHintingReporter.class, null);
                ApiChangeLevel level = reporter.getChangeLevel();
                String baseVersion = old.getVersion();
                analysisResults = new AnalysisResults(level, baseVersion);
                if (res == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new MojoExecutionException("Analysis failure", e);
                }
            }
            res.close();
        }
        return analysisResults;
    }

    private Map<String, Object> getPropertyOverrideMap() {
        HashMap<String, Object> ret = new HashMap<String, Object>(1);
        ret.put("disallowedExtensions", this.disallowedExtensions);
        return ret;
    }

    private static final class AnalysisResults {
        ApiChangeLevel apiChangeLevel;
        final String baseVersion;

        AnalysisResults(ApiChangeLevel apiChangeLevel, String baseVersion) {
            this.apiChangeLevel = apiChangeLevel;
            this.baseVersion = baseVersion;
        }
    }
}

