/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.maven;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.revapi.configuration.ConfigurationValidator;
import org.revapi.configuration.XmlToJson;

final class SchemaDrivenJSONToXmlConverter {
    private static final ConfigurationValidator VALIDATOR = new ConfigurationValidator();

    private SchemaDrivenJSONToXmlConverter() {
    }

    static PlexusConfiguration convertToXml(Map<String, ModelNode> extensionSchemas, ModelNode jsonConfig) throws IOException {
        if (jsonConfig.getType() == ModelType.LIST) {
            return SchemaDrivenJSONToXmlConverter.convertNewStyleConfigToXml(extensionSchemas, jsonConfig);
        }
        return SchemaDrivenJSONToXmlConverter.convertOldStyleConfigToXml(extensionSchemas, jsonConfig);
    }

    static PlexusConfiguration convert(ModelNode configuration, ModelNode jsonSchema, String extensionId, String id) {
        ConversionContext ctx = new ConversionContext();
        ctx.currentSchema = jsonSchema;
        ctx.rootSchema = jsonSchema;
        ctx.pushTag(extensionId);
        ctx.id = id;
        return SchemaDrivenJSONToXmlConverter.convert(configuration, ctx);
    }

    private static PlexusConfiguration convert(ModelNode configuration, ConversionContext ctx) {
        String valueType;
        ModelNode type = ctx.currentSchema.get("type");
        if (!type.isDefined()) {
            if (ctx.currentSchema.get("enum").isDefined()) {
                boolean containsUnsupportedTypes = ctx.currentSchema.get("enum").asList().stream().anyMatch(n -> n.getType() == ModelType.OBJECT || n.getType() == ModelType.LIST);
                if (containsUnsupportedTypes) {
                    throw new IllegalArgumentException("Unsupported type of enum value defined in schema.");
                }
                return SchemaDrivenJSONToXmlConverter.convertSimple(ctx.tagName, ctx.id, configuration.asString());
            }
            if (ctx.currentSchema.get("$ref").isDefined()) {
                ctx.currentSchema = SchemaDrivenJSONToXmlConverter.findRef(ctx.rootSchema, ctx.currentSchema.get("$ref").asString());
                return SchemaDrivenJSONToXmlConverter.convert(configuration, ctx);
            }
            ModelNode matchingSchema = null;
            if (ctx.currentSchema.hasDefined("oneOf")) {
                for (ModelNode s : ctx.currentSchema.get("oneOf").asList()) {
                    if (!VALIDATOR.validate(configuration, s).isSuccessful()) continue;
                    if (matchingSchema != null) {
                        matchingSchema = null;
                        break;
                    }
                    matchingSchema = s;
                }
            } else if (ctx.currentSchema.hasDefined("anyOf")) {
                for (ModelNode s : ctx.currentSchema.get("anyOf").asList()) {
                    if (!VALIDATOR.validate(configuration, s).isSuccessful()) continue;
                    matchingSchema = s;
                    break;
                }
            } else if (ctx.currentSchema.hasDefined("allOf")) {
                for (ModelNode s : ctx.currentSchema.get("allOf").asList()) {
                    if (VALIDATOR.validate(configuration, s).isSuccessful()) {
                        matchingSchema = s;
                        continue;
                    }
                    matchingSchema = null;
                    break;
                }
            }
            if (matchingSchema != null) {
                ctx.currentSchema = matchingSchema;
                return SchemaDrivenJSONToXmlConverter.convert(configuration, ctx);
            }
            throw new IllegalArgumentException("Could not convert the configuration.");
        }
        if (type.getType() != ModelType.STRING) {
            throw new IllegalArgumentException("JSON schema allows for multiple possible types. This is not supported by the XML-to-JSON conversion yet.");
        }
        switch (valueType = type.asString()) {
            case "boolean": {
                return SchemaDrivenJSONToXmlConverter.convertSimple(ctx.tagName, ctx.id, configuration.asString());
            }
            case "integer": {
                return SchemaDrivenJSONToXmlConverter.convertSimple(ctx.tagName, ctx.id, configuration.asString());
            }
            case "number": {
                return SchemaDrivenJSONToXmlConverter.convertSimple(ctx.tagName, ctx.id, configuration.asString());
            }
            case "string": {
                return SchemaDrivenJSONToXmlConverter.convertSimple(ctx.tagName, ctx.id, configuration.asString());
            }
            case "array": {
                return SchemaDrivenJSONToXmlConverter.convertArray(configuration, ctx);
            }
            case "object": {
                return SchemaDrivenJSONToXmlConverter.convertObject(configuration, ctx);
            }
        }
        throw new IllegalArgumentException("Unsupported json value type: " + valueType);
    }

    private static ModelNode findRef(ModelNode rootSchema, String ref) {
        return XmlToJson.JSONPointer.parse((String)ref).navigate(rootSchema);
    }

    private static PlexusConfiguration convertObject(ModelNode configuration, ConversionContext ctx) {
        XmlPlexusConfiguration object = new XmlPlexusConfiguration(ctx.tagName);
        if (ctx.id != null) {
            object.setAttribute("id", ctx.id);
        }
        ModelNode propertySchemas = ctx.currentSchema.get("properties");
        ModelNode additionalPropSchemas = ctx.currentSchema.get("additionalProperties");
        for (String key : configuration.keys()) {
            ModelNode childConfig = configuration.get(key);
            ModelNode childSchema = propertySchemas.get(key);
            if (!childSchema.isDefined()) {
                if (additionalPropSchemas.getType() == ModelType.BOOLEAN) {
                    throw new IllegalArgumentException("Cannot determine the format for the '" + key + "' JSON value during the JSON-to-XML conversion.");
                }
                childSchema = additionalPropSchemas;
            }
            ctx.currentSchema = childSchema;
            ctx.pushTag(key);
            ctx.id = null;
            if (!childSchema.isDefined()) {
                if (ctx.ignorablePaths.contains(ctx.getCurrentPathString())) {
                    ctx.currentPath.pop();
                    continue;
                }
                throw new IllegalArgumentException("Could not determine the format for the '" + key + "' JSON value during the JSON-to-XML conversion.");
            }
            PlexusConfiguration xmlChild = SchemaDrivenJSONToXmlConverter.convert(childConfig, ctx);
            ctx.currentPath.pop();
            object.addChild(xmlChild);
        }
        return object;
    }

    private static PlexusConfiguration convertArray(ModelNode configuration, ConversionContext ctx) {
        ModelNode itemsSchema = ctx.currentSchema.get("items");
        if (!itemsSchema.isDefined()) {
            throw new IllegalArgumentException("No schema found for items of a list. Cannot continue with XML-to-JSON conversion.");
        }
        XmlPlexusConfiguration list = new XmlPlexusConfiguration(ctx.tagName);
        if (ctx.id != null) {
            list.setAttribute("id", ctx.id);
        }
        for (ModelNode childConfig : configuration.asList()) {
            ctx.tagName = "item";
            ctx.currentSchema = itemsSchema;
            ctx.id = null;
            ctx.currentPath.push("[]");
            PlexusConfiguration child = SchemaDrivenJSONToXmlConverter.convert(childConfig, ctx);
            ctx.currentPath.pop();
            list.addChild(child);
        }
        return list;
    }

    private static PlexusConfiguration convertSimple(String tagName, String id, String value) {
        XmlPlexusConfiguration ret = new XmlPlexusConfiguration(tagName);
        if (id != null) {
            ret.setAttribute("id", id);
        }
        ret.setValue(value);
        return ret;
    }

    private static PlexusConfiguration convertOldStyleConfigToXml(Map<String, ModelNode> extensionSchemas, ModelNode jsonConfig) {
        XmlPlexusConfiguration xmlConfig = new XmlPlexusConfiguration("analysisConfiguration");
        block0: for (Map.Entry<String, ModelNode> e : extensionSchemas.entrySet()) {
            String extensionId = e.getKey();
            ModelNode schema = e.getValue();
            String[] extensionPath = extensionId.split("\\.");
            ModelNode config = jsonConfig;
            for (String segment : extensionPath) {
                if (!config.has(segment)) continue block0;
                config = config.get(segment);
            }
            ConversionContext ctx = new ConversionContext();
            ctx.rootSchema = schema;
            ctx.currentSchema = schema;
            ctx.pushTag(extensionId);
            ctx.id = null;
            ctx.ignorablePaths = extensionSchemas.keySet().stream().filter(id -> !extensionId.equals(id) && id.startsWith(extensionId)).collect(Collectors.toList());
            PlexusConfiguration extXml = SchemaDrivenJSONToXmlConverter.convert(config, ctx);
            ctx.currentPath.pop();
            xmlConfig.addChild(extXml);
        }
        return xmlConfig;
    }

    private static PlexusConfiguration convertNewStyleConfigToXml(Map<String, ModelNode> extensionSchemas, ModelNode jsonConfig) throws IOException {
        XmlPlexusConfiguration xmlConfig = new XmlPlexusConfiguration("analysisConfiguration");
        for (ModelNode extConfig : jsonConfig.asList()) {
            String extensionId = extConfig.get("extension").asString();
            ModelNode configuration = extConfig.get("configuration");
            String id = extConfig.hasDefined("id") ? extConfig.get("id").asString() : null;
            ModelNode schema = extensionSchemas.get(extensionId);
            if (schema == null) continue;
            ConversionContext ctx = new ConversionContext();
            ctx.rootSchema = schema;
            ctx.currentSchema = schema;
            ctx.pushTag(extensionId);
            ctx.id = id;
            PlexusConfiguration extXml = SchemaDrivenJSONToXmlConverter.convert(configuration, ctx);
            ctx.currentPath.pop();
            xmlConfig.addChild(extXml);
        }
        return xmlConfig;
    }

    private static final class ConversionContext {
        String id;
        String tagName;
        ModelNode currentSchema;
        ModelNode rootSchema;
        Collection<String> ignorablePaths;
        Deque<String> currentPath = new ArrayDeque<String>(4);

        private ConversionContext() {
        }

        void pushTag(String tag) {
            this.tagName = tag;
            this.currentPath.push(tag);
        }

        String getCurrentPathString() {
            if (this.currentPath.isEmpty()) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            Iterator<String> it = this.currentPath.descendingIterator();
            if (it.hasNext()) {
                sb.append(it.next());
            }
            while (it.hasNext()) {
                sb.append('.').append(it.next());
            }
            return sb.toString();
        }
    }
}

