/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import org.eclipse.aether.artifact.Artifact;
import org.revapi.Archive;

class MavenArchive
implements Archive.Versioned {
    private final File file;
    private final String gav;
    private final String version;

    private MavenArchive(Artifact artifact) {
        if (artifact == null) {
            throw new IllegalArgumentException("Artifact cannot be null");
        }
        this.file = artifact.getFile();
        if (this.file == null) {
            throw new IllegalArgumentException("Could not locate the file of the maven artifact: " + artifact);
        }
        this.gav = artifact.toString();
        this.version = artifact.getBaseVersion();
    }

    public static MavenArchive of(Artifact artifact) {
        if ("pom".equals(artifact.getExtension())) {
            return new Empty(artifact);
        }
        return new MavenArchive(artifact);
    }

    @Nonnull
    public String getName() {
        return this.gav;
    }

    @Nonnull
    public InputStream openStream() throws IOException {
        return new FileInputStream(this.file);
    }

    @Nonnull
    public String getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MavenArchive that = (MavenArchive)o;
        return this.file.equals(that.file);
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public String toString() {
        return "MavenArchive[gav=" + this.gav + ", file=" + this.file + ']';
    }

    public static final class Empty
    extends MavenArchive {
        public Empty(Artifact artifact) {
            super(artifact);
        }

        @Override
        @Nonnull
        public InputStream openStream() throws IOException {
            return new InputStream(){

                @Override
                public int read() throws IOException {
                    return -1;
                }
            };
        }
    }
}

