/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.transforms.annotations;

import java.io.Reader;
import java.util.LinkedHashMap;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.revapi.AnalysisContext;
import org.revapi.Difference;
import org.revapi.DifferenceTransform;
import org.revapi.java.spi.Code;
import org.revapi.java.spi.ElementPairVisitor;
import org.revapi.java.spi.JavaModelElement;

abstract class AbstractAnnotationPresenceCheck
implements DifferenceTransform<JavaModelElement> {
    protected AnalysisContext analysisContext;
    private final String annotationQualifiedName;
    private final Code transformedCode;
    private final Pattern[] codes;

    protected AbstractAnnotationPresenceCheck(String annotationQualifiedName, Code annotationCheckCode, Code transformedCode) {
        this.annotationQualifiedName = annotationQualifiedName;
        this.transformedCode = transformedCode;
        String regex = "^" + Pattern.quote(annotationCheckCode.code()) + "$";
        this.codes = new Pattern[]{Pattern.compile(regex)};
    }

    @Nonnull
    public Pattern[] getDifferenceCodePatterns() {
        return this.codes;
    }

    @Nullable
    public String getExtensionId() {
        return "<<<non-configurable-java-annotation-transform>>>";
    }

    @Nullable
    public Reader getJSONSchema() {
        return null;
    }

    public void initialize(@Nonnull AnalysisContext analysisContext) {
        this.analysisContext = analysisContext;
    }

    @Nullable
    public Difference transform(@Nullable JavaModelElement oldElement, @Nullable JavaModelElement newElement, final @Nonnull Difference difference) {
        if (oldElement == null || newElement == null) {
            return null;
        }
        String affectedAnnotation = (String)difference.attachments.get("annotationType");
        if (!this.annotationQualifiedName.equals(affectedAnnotation)) {
            return difference;
        }
        return (Difference)oldElement.getDeclaringElement().accept(new ElementPairVisitor<Difference>(){

            protected Difference unmatchedAction(@Nonnull Element element, @Nullable Element otherElement) {
                return difference;
            }

            protected Difference visitType(@Nonnull TypeElement oldElement, @Nonnull TypeElement newElement) {
                return this.common();
            }

            protected Difference visitPackage(@Nonnull PackageElement element, @Nonnull PackageElement otherElement) {
                return this.common();
            }

            protected Difference visitVariable(@Nonnull VariableElement element, @Nonnull VariableElement otherElement) {
                return this.common();
            }

            protected Difference visitExecutable(@Nonnull ExecutableElement element, @Nonnull ExecutableElement otherElement) {
                return this.common();
            }

            private Difference common() {
                return AbstractAnnotationPresenceCheck.this.transformedCode.createDifference(AbstractAnnotationPresenceCheck.this.analysisContext.getLocale(), new LinkedHashMap(difference.attachments));
            }
        }, newElement.getDeclaringElement());
    }

    public void close() throws Exception {
    }
}

