/*
 * Decompiled with CFR 0.152.
 */
package org.restdoc.server.impl;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;

public class AnnotationMap {
    private final Map<Class<? extends Annotation>, Annotation> paMap = new HashMap<Class<? extends Annotation>, Annotation>();

    public AnnotationMap(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            this.paMap.put(annotation.annotationType(), annotation);
        }
    }

    public boolean hasAnnotation(Class<? extends Annotation> a) {
        return this.paMap.containsKey(a);
    }

    public boolean hasAnnotation(Class<? extends Annotation> ... a) {
        for (Class<? extends Annotation> annotation : a) {
            if (!this.hasAnnotation(annotation)) continue;
            return true;
        }
        return false;
    }

    public <T extends Annotation> T getAnnotation(Class<T> type) {
        Annotation annotation = this.paMap.get(type);
        if (type.isInstance(annotation)) {
            return (T)((Annotation)type.cast(annotation));
        }
        return null;
    }
}

