/*
 * Decompiled with CFR 0.152.
 */
package org.restdoc.server.ext.oauth2;

import java.lang.reflect.Method;
import java.util.HashMap;
import org.restdoc.api.MethodDefinition;
import org.restdoc.api.RestDoc;
import org.restdoc.api.RestResource;
import org.restdoc.server.ext.oauth2.Scopes;
import org.restdoc.server.impl.RestDocGeneratorExtensionAdapter;

public class OAuth2Extension
extends RestDocGeneratorExtensionAdapter {
    private String clientaccess;
    private String[] grants;
    private String tokenEndpoint;
    private String authEndpoint;

    public OAuth2Extension() {
    }

    public OAuth2Extension(String tokenEndpoint, String authEndpoint, String ... grants) {
        this.tokenEndpoint = tokenEndpoint;
        this.authEndpoint = authEndpoint;
        this.grants = grants;
    }

    public String getClientaccess() {
        return this.clientaccess;
    }

    public void setClientaccess(String clientaccess) {
        this.clientaccess = clientaccess;
    }

    public String[] getGrants() {
        return this.grants;
    }

    public void setGrants(String[] grants) {
        this.grants = grants;
    }

    public String getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    public void setTokenEndpoint(String tokenEndpoint) {
        this.tokenEndpoint = tokenEndpoint;
    }

    public String getAuthEndpoint() {
        return this.authEndpoint;
    }

    public void setAuthEndpoint(String authEndpoint) {
        this.authEndpoint = authEndpoint;
    }

    @Override
    public void newMethod(RestResource restResource, MethodDefinition def, Method method) {
        if (method.isAnnotationPresent(Scopes.class)) {
            Scopes scopes = method.getAnnotation(Scopes.class);
            def.setAdditionalField("scopes", (Object)scopes.value());
        }
    }

    @Override
    public void renderDoc(String path, RestDoc doc) {
        HashMap<String, String> endpoints = new HashMap<String, String>();
        endpoints.put("token", this.tokenEndpoint);
        endpoints.put("authorize", this.authEndpoint);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("endpoints", endpoints);
        map.put("grants", this.grants);
        if (this.clientaccess != null && !this.clientaccess.isEmpty()) {
            map.put("clientaccess", this.clientaccess);
        }
        doc.setAdditionalField("oauth2", map);
    }
}

