/*
 * Decompiled with CFR 0.152.
 */
package org.reflections.spring;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.File;
import java.lang.reflect.Field;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.regex.Pattern;
import org.reflections.ReflectionUtils;
import org.reflections.Reflections;
import org.reflections.Store;
import org.reflections.util.ClasspathHelper;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.beans.factory.xml.XmlReaderContext;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.context.annotation.ComponentScanBeanDefinitionParser;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScannedGenericBeanDefinition;
import org.springframework.core.io.Resource;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.ClassMetadata;
import org.springframework.core.type.StandardAnnotationMetadata;
import org.springframework.core.type.StandardClassMetadata;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.RegexPatternTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.Assert;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionsNamespaceHandler
extends NamespaceHandlerSupport {
    public void init() {
        this.registerBeanDefinitionParser("component-scan", (BeanDefinitionParser)new Parser());
    }

    static Field field(Class<?> type, String field) {
        Field f = (Field)ReflectionUtils.getAllFields(type, (Predicate[])new Predicate[]{ReflectionUtils.withName((String)field)}).iterator().next();
        f.setAccessible(true);
        return f;
    }

    static <T> T field(Object object, String field) throws IllegalAccessException {
        return (T)ReflectionsNamespaceHandler.field(object.getClass(), field).get(object);
    }

    static <T> T field(Object object, Field field) throws IllegalAccessException {
        return (T)field.get(object);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Scanner
    extends ClassPathBeanDefinitionScanner {
        static Field annotationTypeField = ReflectionsNamespaceHandler.field(AnnotationTypeFilter.class, "annotationType");
        static Field targetTypeField = ReflectionsNamespaceHandler.field(AssignableTypeFilter.class, "targetType");
        static Field patternField = ReflectionsNamespaceHandler.field(RegexPatternTypeFilter.class, "pattern");
        Resource resource;
        boolean collect = false;
        boolean save = false;
        boolean parallel = false;
        Set<String> additionalPackages;
        List<TypeFilter> additionalIncludeFilters;
        Set<BeanDefinition> candidates;

        public Scanner(BeanDefinitionRegistry registry, boolean useDefaultFilters) {
            super(registry, useDefaultFilters);
            if (useDefaultFilters) {
                this.additionalPackages = Sets.newHashSet((Object[])new String[]{"org.springframework"});
                this.additionalIncludeFilters = Lists.newArrayList((Object[])new TypeFilter[]{new AnnotationTypeFilter(Configuration.class)});
            }
        }

        protected Set<BeanDefinitionHolder> doScan(String ... basePackages) {
            Assert.notEmpty((Object[])basePackages, (String)"At least one base package must be specified");
            this.findAllCandidateComponents(basePackages);
            return super.doScan(new String[]{"candidates"});
        }

        public Set<BeanDefinition> findCandidateComponents(String basePackage) {
            return basePackage.equals("candidates") ? this.candidates : null;
        }

        public Set<BeanDefinition> findAllCandidateComponents(String ... basePackages) {
            long start = System.currentTimeMillis();
            try {
                this.candidates = Sets.newHashSet();
                if (this.collect) {
                    this.candidates = this.collect();
                }
                if (this.candidates.isEmpty()) {
                    Reflections reflections = this.scanAll(basePackages);
                    this.save(reflections, basePackages[0]);
                }
            }
            catch (Exception ex) {
                throw new BeanDefinitionStoreException("I/O failure during classpath scanning", (Throwable)ex);
            }
            long duration = System.currentTimeMillis() - start;
            this.logger.debug((Object)("findAllCandidateComponents took " + duration));
            return this.candidates;
        }

        private Set<BeanDefinition> collect() {
            Reflections collect = Reflections.collect();
            if (collect != null) {
                Collection<String> resources = this.getValues(collect.getStore());
                for (String resource : resources) {
                    ScannedGenericBeanDefinition e = this.find(ReflectionUtils.forName((String)resource, (ClassLoader[])new ClassLoader[0]));
                    if (e == null) continue;
                    this.candidates.add((BeanDefinition)e);
                }
            }
            return this.candidates;
        }

        private Reflections scanAll(String ... basePackages) throws IllegalAccessException {
            Reflections reflections = new Reflections(new Object[]{basePackages, this.additionalPackages, this.parallel ? Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors()) : null});
            Set<Class<?>> candidateTypes = this.getTypes(reflections, (List)ReflectionsNamespaceHandler.field((Object)this, "includeFilters"));
            if (this.additionalIncludeFilters != null) {
                candidateTypes.addAll(this.getTypes(reflections, this.additionalIncludeFilters));
            }
            List excludeFilters = (List)ReflectionsNamespaceHandler.field((Object)this, "excludeFilters");
            candidateTypes.removeAll(excludeFilters);
            for (Class<?> type : candidateTypes) {
                ScannedGenericBeanDefinition e = this.find(type);
                if (e == null) continue;
                this.candidates.add((BeanDefinition)e);
            }
            return reflections;
        }

        private ScannedGenericBeanDefinition find(Class<?> component) {
            boolean traceEnabled = this.logger.isTraceEnabled();
            boolean debugEnabled = this.logger.isDebugEnabled();
            String name = component.getName();
            if (traceEnabled) {
                this.logger.trace((Object)("Scanning " + name));
            }
            try {
                MetadataReader metadataReader = this.getMetadataReader(component);
                if (this.isCandidateComponent(metadataReader)) {
                    ScannedGenericBeanDefinition candidate = new ScannedGenericBeanDefinition(metadataReader);
                    if (this.isCandidateComponent((AnnotatedBeanDefinition)candidate)) {
                        if (debugEnabled) {
                            this.logger.debug((Object)("Identified candidate component class: " + name));
                        }
                        return candidate;
                    }
                    if (debugEnabled) {
                        this.logger.debug((Object)("Ignored because not a concrete top-level class: " + name));
                    }
                } else if (traceEnabled) {
                    this.logger.trace((Object)("Ignored because not matching any filter: " + name));
                }
            }
            catch (Throwable ex) {
                throw new BeanDefinitionStoreException("Failed to read candidate component class: " + name, ex);
            }
            return null;
        }

        private void clear(Map<String, Multimap<String, String>> storeMap) {
            ArrayList names = Lists.newArrayList();
            for (BeanDefinition resource : this.candidates) {
                names.add(resource.getBeanClassName());
            }
            for (String key : storeMap.keySet()) {
                Multimap<String, String> map = storeMap.get(key);
                Iterator iterator = map.values().iterator();
                while (iterator.hasNext()) {
                    if (names.contains(iterator.next())) continue;
                    iterator.remove();
                }
            }
        }

        private void save(Reflections reflections, String basePackage) throws URISyntaxException, IllegalAccessException {
            if (this.save && !this.candidates.isEmpty()) {
                this.clear(reflections.getStore().getStoreMap());
                String path = (String)ReflectionsNamespaceHandler.field((Object)this.resource, "path");
                Set urls = ClasspathHelper.forResource((String)path, (ClassLoader[])new ClassLoader[0]);
                for (URL url : urls) {
                    File file = new File(url.toURI());
                    if (!file.isDirectory() || !file.canWrite()) continue;
                    reflections.save(file.getPath() + "/META-INF/reflections/" + basePackage + "-reflections.xml");
                    return;
                }
            }
        }

        private Set<Class<?>> getTypes(Reflections reflections, List<TypeFilter> includeFilters) throws IllegalAccessException {
            HashSet types = Sets.newHashSet();
            for (TypeFilter includeFilter : includeFilters) {
                if (includeFilter instanceof AnnotationTypeFilter) {
                    Class annotationType = (Class)ReflectionsNamespaceHandler.field((Object)includeFilter, annotationTypeField);
                    types.addAll(reflections.getTypesAnnotatedWith(annotationType, false));
                    continue;
                }
                if (includeFilter instanceof AssignableTypeFilter) {
                    Class targetType = (Class)ReflectionsNamespaceHandler.field((Object)includeFilter, targetTypeField);
                    types.addAll(reflections.getSubTypesOf(targetType));
                    continue;
                }
                if (includeFilter instanceof RegexPatternTypeFilter) {
                    Pattern pattern = (Pattern)ReflectionsNamespaceHandler.field((Object)includeFilter, patternField);
                    Map map = reflections.getStore().getStoreMap();
                    for (String k : map.keySet()) {
                        Collection values = ((Multimap)map.get(k)).values();
                        for (String value : values) {
                            if (!pattern.matcher(value).matches()) continue;
                            types.add(ReflectionUtils.forName((String)value, (ClassLoader[])new ClassLoader[0]));
                        }
                    }
                    continue;
                }
                throw new UnsupportedOperationException("unsupported include filter " + includeFilter);
            }
            return types;
        }

        private MetadataReader getMetadataReader(final Class<?> aClass) {
            return new MetadataReader(){

                public Resource getResource() {
                    return null;
                }

                public ClassMetadata getClassMetadata() {
                    return new StandardClassMetadata(aClass);
                }

                public AnnotationMetadata getAnnotationMetadata() {
                    return new StandardAnnotationMetadata(aClass);
                }
            };
        }

        public Collection<String> getValues(Store store) {
            ArrayList values = Lists.newArrayList();
            Map storeMap = store.getStoreMap();
            for (String key : storeMap.keySet()) {
                Multimap map = (Multimap)storeMap.get(key);
                if (map == null) continue;
                values.addAll(map.values());
            }
            return values;
        }
    }

    public static class Parser
    extends ComponentScanBeanDefinitionParser {
        protected Scanner configureScanner(ParserContext parserContext, Element element) {
            Scanner scanner = (Scanner)super.configureScanner(parserContext, element);
            if (element.hasAttribute("collect")) {
                scanner.collect = Boolean.valueOf(element.getAttribute("collect"));
            }
            if (element.hasAttribute("parallel")) {
                scanner.parallel = Boolean.valueOf(element.getAttribute("parallel"));
            }
            if (element.hasAttribute("save")) {
                scanner.save = Boolean.valueOf(element.getAttribute("save"));
            }
            scanner.resource = parserContext.getReaderContext().getResource();
            return scanner;
        }

        protected Scanner createScanner(XmlReaderContext readerContext, boolean useDefaultFilters) {
            return new Scanner(readerContext.getRegistry(), useDefaultFilters);
        }
    }
}

