/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.web;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import org.refcodes.exception.MarshalException;
import org.refcodes.exception.UnmarshalException;
import org.refcodes.web.MediaType;
import org.refcodes.web.MediaTypeFactory;

public class YamlMediaTypeFactory
implements MediaTypeFactory {
    private static MediaType[] MEDIA_TYPES = new MediaType[]{MediaType.APPLICATION_YAML, MediaType.TEXT_YAML};
    private ObjectMapper _mapper = new ObjectMapper((JsonFactory)new YAMLFactory());

    public YamlMediaTypeFactory() {
        this._mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    @Override
    public MediaType[] getMediaTypes() {
        return MEDIA_TYPES;
    }

    public String toMarshaled(Object object) throws MarshalException {
        try {
            String string = this._mapper.writeValueAsString(object);
            return string;
        }
        catch (Exception exception) {
            throw new MarshalException("A problem occurred marshaling an object of type <" + object.getClass().getName() + ">.", (Throwable)exception);
        }
    }

    public <T> T toUnmarshaled(String string, Class<T> clazz) throws UnmarshalException {
        try {
            if (string == null) {
                return null;
            }
            if (string.length() == 0) {
                return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            Object object = this._mapper.readValue(string, clazz);
            return (T)object;
        }
        catch (JsonParseException | JsonMappingException throwable) {
            throw new UnmarshalException("A problem occurred unmarshaling the HTTP body \"" + string + "\" to type  <" + clazz.getName() + "> at column <" + throwable.getLocation().getColumnNr() + ">: " + throwable.getMessage(), throwable);
        }
        catch (Exception exception) {
            throw new UnmarshalException("A problem occurred unmarshaling the HTTP body \"" + string + "\" to type  <" + clazz.getName() + ">: " + exception.getMessage(), (Throwable)exception);
        }
    }
}

