/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.web;

import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import org.refcodes.data.MarshalParameter;
import org.refcodes.exception.MarshalException;
import org.refcodes.exception.UnmarshalException;
import org.refcodes.struct.CanonicalMap;
import org.refcodes.struct.CanonicalMapBuilderImpl;
import org.refcodes.struct.SimpleType;
import org.refcodes.struct.ext.factory.XmlCanonicalMapFactorySingleton;
import org.refcodes.web.HttpBodyMap;
import org.refcodes.web.MediaType;
import org.refcodes.web.MediaTypeFactory;

public class XmlMediaTypeFactory
implements MediaTypeFactory {
    private static MediaType[] MEDIA_TYPES = new MediaType[]{MediaType.APPLICATION_XML, MediaType.TEXT_XML, MediaType.APPLICATION_HAL_XML, MediaType.APPLICATION_SCHEMA_XML};

    @Override
    public MediaType[] getMediaTypes() {
        return MEDIA_TYPES;
    }

    public <SRC> String toMarshaled(SRC SRC) throws MarshalException {
        return this.toMarshaled((Object)SRC, (Map)null);
    }

    public <SRC> String toMarshaled(SRC SRC, Map<String, String> map) throws MarshalException {
        CanonicalMapBuilderImpl canonicalMapBuilderImpl = new CanonicalMapBuilderImpl(SRC);
        if (SRC.getClass().isArray()) {
            canonicalMapBuilderImpl = new CanonicalMapBuilderImpl((Object)canonicalMapBuilderImpl.retrieveTo(new String[]{"array", "value"}));
            canonicalMapBuilderImpl.put(new String[]{"array", TYPE_ANNOTATION}, SRC.getClass().getName());
        } else if (Collection.class.isAssignableFrom(SRC.getClass())) {
            canonicalMapBuilderImpl = new CanonicalMapBuilderImpl((Object)canonicalMapBuilderImpl.retrieveTo(new String[]{"collection", "value"}));
            canonicalMapBuilderImpl.put(new String[]{"collection", TYPE_ANNOTATION}, SRC.getClass().getName());
        } else if (canonicalMapBuilderImpl.children().size() > 1 || SimpleType.isSimpleType(SRC.getClass())) {
            String string;
            String string2 = string = map != null ? map.get(MarshalParameter.ROOT_ELEMENT.getName()) : null;
            if (string == null || string.length() == 0) {
                string = "value";
            }
            canonicalMapBuilderImpl = new CanonicalMapBuilderImpl((Object)canonicalMapBuilderImpl.retrieveTo(string));
        }
        return XmlCanonicalMapFactorySingleton.getInstance().toMarshaled((CanonicalMap)canonicalMapBuilderImpl, map);
    }

    public <T> T toUnmarshaled(String string, Class<T> clazz) throws UnmarshalException {
        return this.toUnmarshaled(string, clazz, null);
    }

    public <T> T toUnmarshaled(String string, Class<T> clazz, Map<String, String> map) throws UnmarshalException {
        CanonicalMap.CanonicalMapBuilder canonicalMapBuilder = XmlCanonicalMapFactorySingleton.getInstance().toUnmarshaled(string, map);
        if (clazz.isArray() && canonicalMapBuilder.isDir("array") && canonicalMapBuilder.dirs().size() == 1 && canonicalMapBuilder.leaves().size() == 0 && canonicalMapBuilder.isDir(new String[]{"array", "value"}) && canonicalMapBuilder.dirs("array").size() == 1) {
            canonicalMapBuilder = canonicalMapBuilder.retrieveFrom(new String[]{"array", "value"});
        } else if (Collection.class.isAssignableFrom(clazz) && canonicalMapBuilder.dirs().size() == 1 && canonicalMapBuilder.leaves().size() == 0 && canonicalMapBuilder.isDir(new String[]{"collection", "value"}) && canonicalMapBuilder.dirs("collection").size() == 1) {
            canonicalMapBuilder = canonicalMapBuilder.retrieveFrom(new String[]{"collection", "value"});
        } else {
            if (clazz.isAssignableFrom(HttpBodyMap.class)) {
                return (T)((Object)new HttpBodyMap(canonicalMapBuilder));
            }
            if (canonicalMapBuilder.hasValue("value") && canonicalMapBuilder.leaves().size() == 1 && canonicalMapBuilder.dirs().size() == 0 || canonicalMapBuilder.isDir("value") && canonicalMapBuilder.leaves().size() == 0 && canonicalMapBuilder.dirs().size() == 1) {
                canonicalMapBuilder = canonicalMapBuilder.retrieveFrom("value");
            }
        }
        return (T)canonicalMapBuilder.toType(clazz);
    }

    @Override
    public <T> T fromMarshaled(InputStream inputStream, Class<T> clazz) throws UnmarshalException {
        return this.fromMarshaled(inputStream, clazz, (Map<String, String>)null);
    }

    @Override
    public Object fromMarshaled(InputStream inputStream, Map<String, String> map, Class<?> ... classArray) throws UnmarshalException {
        CanonicalMap.CanonicalMapBuilder canonicalMapBuilder = XmlCanonicalMapFactorySingleton.getInstance().fromMarshaled(inputStream, map);
        for (Class<?> clazz : classArray) {
            try {
                return canonicalMapBuilder.toType(clazz);
            }
            catch (Exception exception) {
            }
        }
        throw new UnmarshalException("Unable to unmarshal the input stream to fit into one of the provided types.");
    }
}

