/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.web;

import java.net.MalformedURLException;
import java.net.URL;
import org.refcodes.data.Delimiter;
import org.refcodes.data.Scheme;
import org.refcodes.mixin.CredentialsAccessor;
import org.refcodes.mixin.Dumpable;
import org.refcodes.mixin.PathAccessor;
import org.refcodes.mixin.PortAccessor;
import org.refcodes.net.IpAddress;
import org.refcodes.net.IpAddressAccessor;
import org.refcodes.web.FormFields;
import org.refcodes.web.FragmentAccessor;
import org.refcodes.web.HostAccessor;
import org.refcodes.web.QueryFieldsAccessor;
import org.refcodes.web.SchemeAccessor;

public class Url
implements Dumpable,
SchemeAccessor,
HostAccessor,
IpAddressAccessor,
PortAccessor,
PathAccessor,
QueryFieldsAccessor,
FragmentAccessor,
CredentialsAccessor {
    protected Scheme _scheme = null;
    protected String _protocol = null;
    protected String _host = null;
    protected int[] _ipAddress = null;
    protected String _path = null;
    protected int _port = -1;
    protected FormFields _queryFields = null;
    protected String _identity = null;
    protected String _secret = null;
    protected String _fragment = null;

    protected Url() {
    }

    public Url(Url url) {
        this._scheme = url.getScheme();
        if (this._scheme == null) {
            this._protocol = url.toProtocol();
        }
        this._host = url.getHost();
        this._ipAddress = url.getIpAddress();
        this.setPath(url.getPath());
        this._port = url.getPort();
        this._queryFields = new FormFields(url.getQueryFields());
        this._identity = url.getIdentity();
        this._secret = url.getSecret();
        this._fragment = url.getFragment();
    }

    public Url(String string) throws MalformedURLException {
        this.fromUrl(string);
    }

    public Url(String string, FormFields formFields) throws MalformedURLException {
        this.fromUrl(string);
        this._queryFields = formFields;
    }

    public Url(String string, FormFields formFields, String string2) throws MalformedURLException {
        this.fromUrl(string);
        this._queryFields = formFields;
        this._fragment = string2;
    }

    public Url(URL uRL) {
        this.fromURL(uRL);
    }

    public Url(Scheme scheme, String string) {
        this._scheme = scheme;
        this._host = string;
    }

    public Url(Scheme scheme, String string, int n) {
        this._scheme = scheme;
        this._host = string;
        this._port = n;
    }

    public Url(Scheme scheme, String string, int n, String string2) {
        this._scheme = scheme;
        this._host = string;
        this._port = n;
        this.setPath(string2);
    }

    public Url(Scheme scheme, String string, int n, String string2, FormFields formFields) {
        this._scheme = scheme;
        this._host = string;
        this._port = n;
        this.setPath(string2);
        this._queryFields = formFields;
    }

    public Url(Scheme scheme, String string, int n, String string2, FormFields formFields, String string3) {
        this._scheme = scheme;
        this._host = string;
        this._port = n;
        this.setPath(string2);
        this._queryFields = formFields;
        this._fragment = string3;
    }

    public Url(String string, String string2) {
        this.setProtocol(string);
        this._host = string2;
    }

    public Url(String string, String string2, int n) {
        this.setProtocol(string);
        this._host = string2;
        this._port = n;
    }

    public Url(String string, String string2, int n, String string3) {
        this.setProtocol(string);
        this._host = string2;
        this._port = n;
        this.setPath(string3);
    }

    public Url(String string, String string2, int n, String string3, FormFields formFields) {
        this.setProtocol(string);
        this._host = string2;
        this._port = n;
        this.setPath(string3);
        this._queryFields = formFields;
    }

    public Url(String string, String string2, int n, String string3, FormFields formFields, String string4) {
        this.setProtocol(string);
        this._host = string2;
        this._port = n;
        this.setPath(string3);
        this._queryFields = formFields;
        this._fragment = string4;
    }

    public Url(Scheme scheme, String string, String string2) {
        this._scheme = scheme;
        this._host = string;
        this.setPath(string2);
    }

    public Url(Scheme scheme, String string, String string2, FormFields formFields) {
        this._scheme = scheme;
        this._host = string;
        this.setPath(string2);
        this._queryFields = formFields;
    }

    public Url(Scheme scheme, String string, String string2, FormFields formFields, String string3) {
        this._scheme = scheme;
        this._host = string;
        this.setPath(string2);
        this._queryFields = formFields;
        this._fragment = string3;
    }

    public Url(String string, String string2, String string3) {
        this.setProtocol(string);
        this._host = string2;
        this.setPath(string3);
    }

    public Url(String string, String string2, String string3, FormFields formFields) {
        this.setProtocol(string);
        this._host = string2;
        this.setPath(string3);
        this._queryFields = formFields;
    }

    public Url(Url url, Url url2) {
        this(url != null ? url : url2);
        if (url != null) {
            String string;
            if (url2.getScheme() != null) {
                this.setScheme(url2.getScheme());
            } else if (url2.toProtocol() != null) {
                this.setProtocol(url2.toProtocol());
            }
            if (url2.getIdentity() != null) {
                this._identity = url2.getIdentity();
            }
            if (url2.getSecret() != null) {
                this._secret = url2.getSecret();
            }
            if (url2.getHost() != null) {
                this.setHost(url2.getHost());
            }
            if ((string = url2.getPath()) != null) {
                String string2 = this.getPath();
                if (string2 == null) {
                    string2 = "";
                }
                string2 = Url.toTruncatePathSuffix(string2);
                string = Url.toTruncatePathPrefix(string);
                this.setPath(string2 + Delimiter.PATH.getChar() + string);
            }
            this.getQueryFields().putAll(url2.getQueryFields());
            if (url2.getFragment() != null) {
                this._fragment = url2.getFragment();
            }
        }
    }

    public Url(String string, String string2, String string3, FormFields formFields, String string4) {
        this.setProtocol(string);
        this._host = string2;
        this.setPath(string3);
        this._queryFields = formFields;
        this._fragment = string4;
    }

    public Url(Url url, String ... stringArray) {
        this(url);
        this._path = this._path != null && this._path.length() != 0 ? Url.toTruncatePathSuffix(this._path) : "" + Delimiter.PATH.getChar();
        Object object = "";
        for (String string : stringArray) {
            if (((String)object).length() > 0) {
                object = (String)object + Delimiter.PATH.getChar();
            }
            object = (String)object + Url.toTruncatePath(string);
        }
        this._path = this._path + Delimiter.PATH.getChar() + (String)object;
    }

    @Override
    public String getFragment() {
        return this._fragment;
    }

    @Override
    public String getHost() {
        return this._host;
    }

    public String getIdentity() {
        return this._identity;
    }

    public int[] getIpAddress() {
        return this._ipAddress;
    }

    public String getPath() {
        return this._path;
    }

    public int getPort() {
        return this._port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FormFields getQueryFields() {
        if (this._queryFields == null) {
            Url url = this;
            synchronized (url) {
                if (this._queryFields == null) {
                    this._queryFields = new FormFields();
                }
            }
        }
        return this._queryFields;
    }

    @Override
    public Scheme getScheme() {
        return this._scheme;
    }

    public String getSecret() {
        return this._secret;
    }

    @Override
    public String toProtocol() {
        return this._scheme != null ? this._scheme.toProtocol() : this._protocol;
    }

    public String toHost() {
        String string = this.getHost();
        String string2 = this.toCidrNotation();
        if (string != null && string.length() > 0 && string2 != null && string2.length() > 0) {
            throw new IllegalStateException("Either the <host> or the <IP-Address> can be set, but not both of them: Host := <" + string + ">, IP-Address = <" + string2 + ">. Make sure only one ofd them is set!");
        }
        return string != null ? string : string2;
    }

    public String toHttpUrl() {
        String string;
        FormFields formFields;
        String string2;
        String string3;
        StringBuilder stringBuilder = new StringBuilder();
        String string4 = this.toProtocol();
        if (string4 != null && string4.length() != 0) {
            stringBuilder.append(string4);
        }
        if ((string3 = this.getIdentity()) != null) {
            stringBuilder.append(string3);
            if (this.getSecret() != null) {
                stringBuilder.append(Delimiter.URL_CREDENTIALS.getChar());
                stringBuilder.append(this.getSecret());
            }
            stringBuilder.append(Delimiter.URL_USER_INFO.getChar());
        } else if (this.getSecret() != null) {
            throw new IllegalStateException("The <secret> property requires an <identiry> property not being null or of an empty length!");
        }
        String string5 = this.toHost();
        if (string5 != null && string5.length() != 0) {
            stringBuilder.append(string5);
            int n = this.getPort();
            if (n != -1) {
                stringBuilder.append(Delimiter.URL_PORT.getChar());
                stringBuilder.append(n);
            }
        }
        if ((string2 = this.getPath()) != null) {
            while (string2.length() > 0 && string2.charAt(0) == Delimiter.PATH.getChar()) {
                string2 = string2.substring(1);
            }
            if (!stringBuilder.toString().endsWith("" + Delimiter.PATH.getChar())) {
                stringBuilder.append(Delimiter.PATH.getChar());
            }
            stringBuilder.append(string2);
        }
        if ((formFields = this.getQueryFields()) != null && formFields.size() > 0 && (string = formFields.toUrlQueryString()) != null && string.length() > 0) {
            stringBuilder.append(string);
        }
        if ((string = this.getFragment()) != null && string.length() > 0) {
            stringBuilder.append(Delimiter.URL_FRAGMENT.getChar());
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public String toLocator() {
        String string;
        String string2;
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = this.toProtocol();
        if (string3 != null && string3.length() != 0) {
            stringBuilder.append(string3);
        }
        if ((string2 = this.getIdentity()) != null) {
            stringBuilder.append(string2);
            if (this.getSecret() != null) {
                stringBuilder.append(Delimiter.URL_CREDENTIALS.getChar());
                stringBuilder.append(this.getSecret());
            }
            stringBuilder.append(Delimiter.URL_USER_INFO.getChar());
        } else if (this.getSecret() != null) {
            throw new IllegalStateException("The <secret> property requires an <identiry> property not being null or of an empty length!");
        }
        String string4 = this.toHost();
        if (string4 != null && string4.length() != 0) {
            stringBuilder.append(string4);
            int n = this.getPort();
            if (n != -1) {
                stringBuilder.append(Delimiter.URL_PORT.getChar());
                stringBuilder.append(n);
            }
        }
        if ((string = this.getPath()) != null) {
            while (string.length() > 0 && string.charAt(0) == Delimiter.PATH.getChar()) {
                string = string.substring(1);
            }
            if (!stringBuilder.toString().endsWith("" + Delimiter.PATH.getChar())) {
                stringBuilder.append(Delimiter.PATH.getChar());
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public URL toURL() throws MalformedURLException {
        return new URL(this.toHttpUrl());
    }

    public String toString() {
        return this.toHttpUrl();
    }

    protected void fromUrl(String string) throws MalformedURLException {
        try {
            int n;
            String string2;
            int n2;
            String string3 = string;
            Scheme scheme = Scheme.fromScheme((String)string3);
            if (scheme != null) {
                this.setScheme(scheme);
                string3 = string3.substring(scheme.toProtocol().length());
            }
            if ((n2 = string3.indexOf(Delimiter.URL_USER_INFO.getChar())) != -1) {
                string2 = string3.substring(0, n2);
                if (string2.length() > 0) {
                    n = string2.indexOf(Delimiter.URL_CREDENTIALS.getChar());
                    if (n == -1) {
                        this._identity = string2;
                    } else {
                        this._identity = string2.substring(0, n);
                        this._secret = string2.substring(n + 1);
                    }
                }
                string3 = string3.substring(n2 + 1);
            }
            if ((n2 = string3.indexOf(Delimiter.PATH.getChar())) != 0) {
                if (n2 == -1 && (n2 = string3.indexOf(Delimiter.URL_QUERY.getChar())) == -1) {
                    n2 = string3.indexOf(Delimiter.URL_FRAGMENT.getChar());
                }
                if (n2 == -1) {
                    this.setHost(string3);
                    string3 = null;
                } else {
                    string2 = string3.substring(0, n2);
                    if (string2 != null && string2.length() > 0) {
                        n = string2.indexOf(Delimiter.URL_PORT.getChar());
                        if (n == -1) {
                            this.setHost(string2);
                        } else {
                            this.setHost(string2.substring(0, n));
                            this.setPort(Integer.parseInt(string2.substring(n + 1)));
                        }
                    }
                    string3 = string3.substring(n2);
                }
            }
            if (string3 != null && string3.length() > 0) {
                n2 = string3.indexOf(Delimiter.URL_QUERY.getChar(), 1);
                if (n2 == -1) {
                    n2 = string3.indexOf(Delimiter.URL_FRAGMENT.getChar(), 1);
                }
                if (n2 == -1) {
                    this.setPath(string3);
                } else {
                    string2 = string3.substring(0, n2);
                    this.setPath(string2);
                    string3 = string3.substring(n2);
                    if (string3.length() > 0) {
                        if (string3.charAt(0) == Delimiter.URL_QUERY.getChar()) {
                            FormFields formFields;
                            n2 = string3.indexOf(Delimiter.URL_FRAGMENT.getChar());
                            String string4 = n2 == -1 ? string3 : string3.substring(0, n2);
                            this._queryFields = formFields = new FormFields(string4);
                        }
                        if ((n2 = string3.indexOf(Delimiter.URL_FRAGMENT.getChar())) != -1) {
                            String string5;
                            this._fragment = string5 = string3.substring(n2 + 1);
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            this.fromURL(new URL(string));
        }
    }

    protected void fromURL(URL uRL) {
        String string;
        Scheme scheme = Scheme.fromName((String)uRL.getProtocol());
        if (scheme == null) {
            scheme = Scheme.fromProtocol((String)uRL.getProtocol());
        }
        this.setScheme(scheme);
        this.setHost(uRL.getHost());
        this.setPort(uRL.getPort());
        String string2 = uRL.getUserInfo();
        if (string2 != null && string2.length() > 0) {
            int n = string2.indexOf(Delimiter.URL_CREDENTIALS.getChar());
            if (n == -1) {
                this._identity = string2;
            } else {
                this._identity = string2.substring(0, n);
                this._secret = string2.substring(n + 1);
            }
        }
        if ((string = uRL.getPath()) != null && string.length() > 0) {
            this.setPath(string);
        }
        if (uRL.getQuery() != null && uRL.getQuery().length() > 0) {
            FormFields formFields;
            this._queryFields = formFields = new FormFields(uRL.getQuery());
        }
        if (uRL.getRef() != null && uRL.getRef().length() > 0) {
            this._fragment = uRL.getRef();
        }
    }

    protected void setScheme(Scheme scheme) {
        this._scheme = scheme;
        this._protocol = null;
    }

    protected void setProtocol(String string) {
        Scheme scheme = Scheme.fromProtocol((String)string);
        if (scheme != null) {
            this._scheme = scheme;
            this._protocol = null;
        } else {
            this._scheme = null;
            this._protocol = string;
        }
    }

    protected void setHost(String string) {
        try {
            int[] nArray = IpAddress.fromAnyCidrNotation((String)string);
            if (nArray != null && nArray.length > 0) {
                this._ipAddress = nArray;
                this._host = null;
            } else {
                this._ipAddress = null;
                this._host = string;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this._host = string;
            this._ipAddress = null;
        }
    }

    protected void setIpAddress(int[] nArray) {
        IpAddress.toString((int[])nArray);
        this._ipAddress = nArray;
        this._host = null;
    }

    protected void setPort(int n) {
        this._port = n;
    }

    protected void setPath(String object) {
        if (object != null && ((String)object).length() != 0 && ((String)object).charAt(0) != Delimiter.PATH.getChar()) {
            object = Delimiter.PATH.getChar() + (String)object;
        }
        this._path = object;
    }

    protected static String toTruncatePathPrefix(String string) {
        if (string != null) {
            while (string.length() > 0 && string.charAt(0) == Delimiter.PATH.getChar()) {
                string = string.substring(1);
            }
        }
        return string;
    }

    protected static String toTruncatePathSuffix(String string) {
        if (string != null) {
            while (string.length() > 0 && string.charAt(string.length() - 1) == Delimiter.PATH.getChar()) {
                string = string.substring(0, string.length() - 1);
            }
        }
        return string;
    }

    protected static String toTruncatePath(String string) {
        return Url.toTruncatePathPrefix(Url.toTruncatePathSuffix(string));
    }
}

