/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.web;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.time.DateTimeException;
import java.time.Instant;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;
import org.refcodes.data.Delimiter;
import org.refcodes.data.Encoding;
import org.refcodes.mixin.DomainAccessor;
import org.refcodes.mixin.PathAccessor;
import org.refcodes.struct.PropertyImpl;
import org.refcodes.time.DateFormat;
import org.refcodes.time.DateFormats;
import org.refcodes.time.TimeUnit;
import org.refcodes.web.Cookie;
import org.refcodes.web.CookieAttribute;

public class ResponseCookie
extends PropertyImpl.PropertyBuilderImpl
implements Cookie,
PathAccessor.PathProperty,
PathAccessor.PathBuilder<ResponseCookie>,
DomainAccessor.DomainProperty,
DomainAccessor.DomainBuilder<ResponseCookie> {
    private Date _expiresDate = null;
    private int _maxAge = -1;
    private String _domain = null;
    private String _path = null;
    private boolean _isSecure = false;
    private boolean _isHttpOnly = false;
    private String _version = null;

    public ResponseCookie() {
    }

    public ResponseCookie(String string, String string2) {
        super(string, string2);
    }

    public ResponseCookie(String string) {
        this.fromHttpCookie(string);
    }

    public ResponseCookie(Cookie cookie) {
        super((String)cookie.getKey(), (String)cookie.getValue());
        if (cookie instanceof ResponseCookie) {
            ResponseCookie responseCookie = (ResponseCookie)cookie;
            this.setDomain(responseCookie.getDomain());
            this.setPath(responseCookie.getPath());
            this.setExpiresDate(responseCookie.getExpiresDate());
            this.setHttpOnly(responseCookie.isHttpOnly());
            this.setSecure(responseCookie.isSecure());
            this.setMaxAge(responseCookie.getMaxAge());
            this.setVersion(responseCookie.getVersion());
        }
    }

    public ResponseCookie(String string, String string2, Date date, String string3, String string4, boolean bl, boolean bl2, String string5) {
        super(string, string2);
        this._expiresDate = date;
        this._domain = string3;
        this._path = string4;
        this._isSecure = bl;
        this._isHttpOnly = bl2;
        this._version = string5;
    }

    public ResponseCookie(String string, String string2, int n, String string3, String string4, boolean bl, boolean bl2, String string5) {
        super(string, string2);
        this._maxAge = n;
        this._domain = string3;
        this._path = string4;
        this._isSecure = bl;
        this._isHttpOnly = bl2;
        this._version = string5;
    }

    public int getMaxAge() {
        return this._maxAge;
    }

    public void setMaxAge(int n) {
        this._maxAge = n;
    }

    public String getVersion() {
        return this._version;
    }

    public void setVersion(String string) {
        this._version = string;
    }

    public String getPath() {
        return this._path;
    }

    public void setPath(String string) {
        this._path = string;
    }

    public Date getExpiresDate() {
        return this._expiresDate;
    }

    public void setExpiresDate(Date date) {
        this._expiresDate = date;
    }

    public String getDomain() {
        return this._domain;
    }

    public void setDomain(String string) {
        this._domain = string;
    }

    public void setSecure(boolean bl) {
        this._isSecure = bl;
    }

    public boolean isSecure() {
        return this._isSecure;
    }

    public boolean isHttpOnly() {
        return this._isHttpOnly;
    }

    public void setHttpOnly(boolean bl) {
        this._isHttpOnly = bl;
    }

    public void setExpiresAfter(TimeUnit timeUnit, long l) {
        long l2 = TimeUnit.toMilliseconds((TimeUnit)timeUnit, (long)l);
        Date date = new Date();
        date = new Date(date.getTime() + l2);
        this.setExpiresDate(date);
    }

    public ResponseCookie withExpiresDate(Date date) {
        this.setExpiresDate(date);
        return this;
    }

    public ResponseCookie withPath(String string) {
        this.setPath(string);
        return this;
    }

    public ResponseCookie withDomain(String string) {
        this.setDomain(string);
        return this;
    }

    public ResponseCookie withHttpOnly(boolean bl) {
        this.setHttpOnly(bl);
        return this;
    }

    public ResponseCookie withExpiresAfter(TimeUnit timeUnit, long l) {
        this.setExpiresAfter(timeUnit, l);
        return this;
    }

    public ResponseCookie withVersion(String string) {
        this.setVersion(string);
        return this;
    }

    public ResponseCookie withMaxAge(int n) {
        this.setMaxAge(n);
        return this;
    }

    public ResponseCookie withSecure(boolean bl) {
        this.setSecure(bl);
        return this;
    }

    @Override
    public ResponseCookie withHttpCookie(String string) {
        this.fromHttpCookie(string);
        return this;
    }

    @Override
    public void fromHttpCookie(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "" + Delimiter.COOKIE_PROPERTIES.getChar());
        String string2 = stringTokenizer.nextToken();
        PropertyImpl propertyImpl = new PropertyImpl(string2);
        this.setKey((String)propertyImpl.getKey());
        try {
            this.setValue(URLDecoder.decode((String)propertyImpl.getValue(), Encoding.UTF_8.getCode()));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.setValue((String)propertyImpl.getValue());
        }
        block15: while (stringTokenizer.hasMoreTokens()) {
            CookieAttribute cookieAttribute;
            string2 = stringTokenizer.nextToken();
            if (string2.equalsIgnoreCase(CookieAttribute.SECURE.getKey())) {
                cookieAttribute = CookieAttribute.SECURE;
            } else if (string2.equalsIgnoreCase(CookieAttribute.HTTPONLY.getKey())) {
                cookieAttribute = CookieAttribute.HTTPONLY;
            } else {
                propertyImpl = new PropertyImpl(string2);
                cookieAttribute = CookieAttribute.fromKey((String)propertyImpl.getKey());
            }
            if (cookieAttribute == null) continue;
            switch (cookieAttribute) {
                case DOMAIN: {
                    this.setDomain((String)propertyImpl.getValue());
                    continue block15;
                }
                case EXPIRES: {
                    try {
                        this.setExpiresDate(DateFormats.COOKIE_DATE_FORMATS.toDate((String)propertyImpl.getValue()));
                        continue block15;
                    }
                    catch (DateTimeException dateTimeException) {
                        throw new IllegalArgumentException("Encountered unparsable date <" + (String)propertyImpl.getValue() + "> for key <" + cookieAttribute.getKey() + ">.", dateTimeException);
                    }
                }
                case HTTPONLY: {
                    this.setHttpOnly(true);
                    continue block15;
                }
                case PATH: {
                    this.setPath((String)propertyImpl.getValue());
                    continue block15;
                }
                case SECURE: {
                    this.setSecure(true);
                    continue block15;
                }
                case VERSION: {
                    this.setVersion((String)propertyImpl.getValue());
                    continue block15;
                }
                case MAX_AGE: {
                    int n = -1;
                    try {
                        n = Integer.parseInt((String)propertyImpl.getValue());
                        this.setMaxAge(n);
                        continue block15;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException("Encountered unparsable max-age <" + (String)propertyImpl.getValue() + "> for key <" + cookieAttribute.getKey() + ">.", numberFormatException);
                    }
                }
            }
        }
    }

    @Override
    public String toHttpCookie() {
        String string = null;
        try {
            string = URLEncoder.encode((String)this.getValue(), Encoding.UTF_8.getCode());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string = (String)this.getValue();
        }
        String string2 = (String)this.getKey() + Delimiter.COOKIE_TUPEL.getChar() + string;
        if (this.getExpiresDate() != null) {
            string2 = string2 + Delimiter.COOKIE_PROPERTIES.getChar() + CookieAttribute.EXPIRES.getKey() + Delimiter.COOKIE_TUPEL.getChar() + DateFormat.NETSCAPE_COOKIE_DATE_FORMAT.getFormatter().withLocale(Locale.ENGLISH).format(Instant.ofEpochMilli(this.getExpiresDate().getTime()));
        }
        if (this.getMaxAge() != -1) {
            string2 = string2 + Delimiter.COOKIE_PROPERTIES.getChar() + CookieAttribute.MAX_AGE.getKey() + Delimiter.COOKIE_TUPEL.getChar() + this.getMaxAge();
        }
        if (this.getDomain() != null) {
            string2 = string2 + Delimiter.COOKIE_PROPERTIES.getChar() + CookieAttribute.DOMAIN.getKey() + Delimiter.COOKIE_TUPEL.getChar() + this.getDomain();
        }
        if (this.getPath() != null) {
            string2 = string2 + Delimiter.COOKIE_PROPERTIES.getChar() + CookieAttribute.PATH.getKey() + Delimiter.COOKIE_TUPEL.getChar() + this.getPath();
        }
        if (this.isSecure()) {
            string2 = string2 + Delimiter.COOKIE_PROPERTIES.getChar() + CookieAttribute.SECURE.getKey();
        }
        if (this.isHttpOnly()) {
            string2 = string2 + Delimiter.COOKIE_PROPERTIES.getChar() + CookieAttribute.HTTPONLY.getKey();
        }
        if (this.getVersion() != null) {
            string2 = string2 + Delimiter.COOKIE_PROPERTIES.getChar() + CookieAttribute.VERSION.getKey() + Delimiter.COOKIE_TUPEL.getChar() + this.getVersion();
        }
        return string2;
    }

    public String toString() {
        return this.getClass().getName() + "@[key=" + (String)this._key + ", value=" + (String)this._value + ", expiresDate=" + this._expiresDate + ", maxAge=" + this._maxAge + ", domain=" + this._domain + ", path=" + this._path + ", isSecure=" + this._isSecure + ", isHttpOnly=" + this._isHttpOnly + ", version=" + this._version + "]";
    }
}

