/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.web;

import org.refcodes.mixin.Disposable;
import org.refcodes.mixin.ValidAccessor;
import org.refcodes.web.GrantType;
import org.refcodes.web.HttpBodyMap;
import org.refcodes.web.OauthField;

public class OauthToken
implements ValidAccessor,
Disposable.Disposedable {
    private static final String PREFIX_TOKEN_PATH = "token";
    private long _creationTimeMillis;
    protected String _accessToken;
    protected String _refreshToken;
    protected String _tokenType;
    protected Integer _expiresIn;
    protected Integer _refreshExpiresIn;
    protected String _scope;
    protected String _notBeforePolicy;
    protected String _sessionState;
    protected GrantType _grantType;
    private boolean _isDisposed;

    public OauthToken(OauthToken oauthToken) {
        this(oauthToken.getAccessToken(), oauthToken.getRefreshToken(), oauthToken.getTokenType(), null, oauthToken.getNotBeforePolicy(), oauthToken.getExpiresIn(), oauthToken.getRefreshExpiresIn(), oauthToken.getScope(), oauthToken.getSessionState());
    }

    public OauthToken(String string, String string2, String string3, Integer n, String string4) {
        this(string, string2, string3, null, null, n, null, string4, null);
    }

    public OauthToken(String string, String string2, String string3, String string4, Integer n, Integer n2, String string5, String string6) {
        this(string, string2, string3, null, string4, n, n2, string5, string6);
    }

    public OauthToken(String string, String string2, String string3, GrantType grantType, String string4, Integer n, Integer n2, String string5, String string6) {
        this._creationTimeMillis = System.currentTimeMillis();
        this._accessToken = string;
        this._refreshToken = string2;
        this._tokenType = string3;
        this._notBeforePolicy = string4;
        this._expiresIn = n;
        this._refreshExpiresIn = n2;
        this._scope = string5;
        this._sessionState = string6;
        this._grantType = grantType;
    }

    public OauthToken(HttpBodyMap httpBodyMap) {
        this.fromHttpBodyMap(httpBodyMap);
    }

    public void dispose() {
        this._isDisposed = true;
        this._accessToken = null;
        this._expiresIn = null;
        this._refreshToken = null;
        this._scope = null;
        this._tokenType = null;
        this._sessionState = null;
        this._refreshExpiresIn = null;
        this._notBeforePolicy = null;
    }

    public boolean isDisposed() {
        return this._isDisposed;
    }

    public String getAccessToken() {
        return this._accessToken;
    }

    public String getRefreshToken() {
        return this._refreshToken;
    }

    public String getScope() {
        return this._scope;
    }

    public String getTokenType() {
        return this._tokenType;
    }

    public GrantType getGrantType() {
        return this._grantType;
    }

    public Integer getExpiresIn() {
        return this._expiresIn;
    }

    public String getNotBeforePolicy() {
        return this._notBeforePolicy;
    }

    public String getSessionState() {
        return this._sessionState;
    }

    public Integer getRefreshExpiresIn() {
        return this._refreshExpiresIn;
    }

    public boolean isValid() {
        if (this._isDisposed) {
            return false;
        }
        if (this._expiresIn == null) {
            return true;
        }
        return this._creationTimeMillis + (long)(this._expiresIn * 1000) > System.currentTimeMillis();
    }

    protected void fromHttpBodyMap(HttpBodyMap httpBodyMap) {
        this._creationTimeMillis = System.currentTimeMillis();
        this._accessToken = (String)httpBodyMap.get(OauthField.ACCESS_TOKEN.getPath());
        this._refreshToken = (String)httpBodyMap.get(OauthField.REFRESH_TOKEN.getPath());
        this._tokenType = (String)httpBodyMap.get(OauthField.TOKEN_TYPE.getPath());
        this._notBeforePolicy = (String)httpBodyMap.get(OauthField.NOT_BEFORE_POLICY.getPath());
        this._expiresIn = httpBodyMap.getInt(OauthField.EXPIRES_IN.getPath());
        this._refreshExpiresIn = httpBodyMap.getInt(OauthField.REFRESH_EXPIRES_IN.getPath());
        this._scope = (String)httpBodyMap.get(OauthField.SCOPE.getPath());
        this._sessionState = (String)httpBodyMap.get(OauthField.SESSION_STATE.getPath());
        this._grantType = GrantType.fromName((String)httpBodyMap.get(OauthField.GRANT_TYPE.getPath()));
        if (this._accessToken == null || this._accessToken.length() == 0) {
            this._accessToken = (String)httpBodyMap.get(new String[]{PREFIX_TOKEN_PATH, OauthField.ACCESS_TOKEN.getPath()});
        }
        if (this._refreshToken == null || this._refreshToken.length() == 0) {
            this._refreshToken = (String)httpBodyMap.get(new String[]{PREFIX_TOKEN_PATH, OauthField.REFRESH_TOKEN.getPath()});
        }
        if (this._tokenType == null || this._tokenType.length() == 0) {
            this._tokenType = (String)httpBodyMap.get(new String[]{PREFIX_TOKEN_PATH, OauthField.TOKEN_TYPE.getPath()});
        }
        if (this._notBeforePolicy == null || this._notBeforePolicy.length() == 0) {
            this._notBeforePolicy = (String)httpBodyMap.get(new String[]{PREFIX_TOKEN_PATH, OauthField.NOT_BEFORE_POLICY.getPath()});
        }
        if (this._expiresIn == null) {
            this._expiresIn = httpBodyMap.getInt(new String[]{PREFIX_TOKEN_PATH, OauthField.EXPIRES_IN.getPath()});
        }
        if (this._refreshExpiresIn == null) {
            this._refreshExpiresIn = httpBodyMap.getInt(new String[]{PREFIX_TOKEN_PATH, OauthField.REFRESH_EXPIRES_IN.getPath()});
        }
        if (this._scope == null || this._scope.length() == 0) {
            this._scope = (String)httpBodyMap.get(new String[]{PREFIX_TOKEN_PATH, OauthField.SCOPE.getPath()});
        }
        if (this._sessionState == null || this._sessionState.length() == 0) {
            this._sessionState = (String)httpBodyMap.get(new String[]{PREFIX_TOKEN_PATH, OauthField.SESSION_STATE.getPath()});
        }
        if (this._grantType == null) {
            this._grantType = GrantType.fromName((String)httpBodyMap.get(new String[]{PREFIX_TOKEN_PATH, OauthField.GRANT_TYPE.getPath()}));
        }
    }
}

