/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.web;

import org.refcodes.data.Delimiter;
import org.refcodes.mixin.NameAccessor;
import org.refcodes.mixin.PathAccessor;
import org.refcodes.web.HeaderField;
import org.refcodes.web.HeaderFieldAccessor;

public enum OauthField implements PathAccessor,
HeaderFieldAccessor,
NameAccessor
{
    SCOPE(HeaderField.SCOPE),
    EXPIRES_IN(HeaderField.EXPIRES_IN),
    REFRESH_TOKEN(HeaderField.REFRESH_TOKEN),
    TOKEN_TYPE(HeaderField.TOKEN_TYPE),
    ACCESS_TOKEN(HeaderField.ACCESS_TOKEN),
    CLIENT_ID(HeaderField.CLIENT_ID),
    CLIENT_SECRET(HeaderField.CLIENT_SECRET),
    GRANT_TYPE(HeaderField.GRANT_TYPE),
    REDIRECT_URI(HeaderField.REDIRECT_URI),
    USERNAME(HeaderField.USERNAME),
    PASSWORD(HeaderField.PASSWORD),
    SESSION_STATE(HeaderField.SESSION_STATE),
    REFRESH_EXPIRES_IN(HeaderField.REFRESH_EXPIRES_IN),
    NOT_BEFORE_POLICY(HeaderField.NOT_BEFORE_POLICY);

    private HeaderField _field;

    private OauthField(HeaderField headerField) {
        this._field = headerField;
    }

    @Override
    public HeaderField getHeaderField() {
        return this._field;
    }

    public String getPath() {
        return Delimiter.PATH.getChar() + this._field.getName();
    }

    public String getName() {
        return this._field.getName();
    }

    public static OauthField fromPath(String object) {
        if (object != null) {
            if (((String)object).length() > 0 && ((String)object).charAt(0) != Delimiter.PATH.getChar()) {
                object = Delimiter.PATH.getChar() + (String)object;
            }
            for (OauthField oauthField : OauthField.values()) {
                if (!oauthField.getPath().equals(object)) continue;
                return oauthField;
            }
        }
        return null;
    }

    public static OauthField fromHeaderField(HeaderField headerField) {
        if (headerField != null) {
            for (OauthField oauthField : OauthField.values()) {
                if (oauthField.getHeaderField() != headerField) continue;
                return oauthField;
            }
        }
        return null;
    }
}

