/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.web;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.stream.Collectors;
import org.refcodes.exception.MarshalException;
import org.refcodes.exception.UnmarshalException;
import org.refcodes.factory.MarshalFactory;
import org.refcodes.factory.UnmarshalFactory;
import org.refcodes.struct.PathMap;
import org.refcodes.web.MediaTypesAccessor;

public interface MediaTypeFactory
extends UnmarshalFactory.UnmarshalFactoryComposite<String, InputStream>,
MarshalFactory.MarshalFactoryComposite<String, InputStream>,
MediaTypesAccessor {
    public static final String VALUE_SELECTOR = "value";
    public static final String ARRAY_SELECTOR = "array";
    public static final String COLLECTION_SELECTOR = "collection";
    public static final String TYPE_ANNOTATION = PathMap.ANNOTATOR + "type";

    default public <T> T fromMarshaled(InputStream inputStream, Class<T> clazz) throws UnmarshalException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string = bufferedReader.lines().collect(Collectors.joining("\n"));
        return (T)this.toUnmarshaled(string, clazz);
    }

    default public Object fromMarshaled(InputStream inputStream, Class<?> ... classArray) throws UnmarshalException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string = bufferedReader.lines().collect(Collectors.joining("\n"));
        return this.toUnmarshaled(string, classArray);
    }

    default public Object fromMarshaled(InputStream inputStream, Map<String, String> map, Class<?> ... classArray) throws UnmarshalException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string = bufferedReader.lines().collect(Collectors.joining("\n"));
        return this.toUnmarshaled(string, map, classArray);
    }

    default public <T> T fromMarshaled(InputStream inputStream, Class<T> clazz, Map<String, String> map) throws UnmarshalException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string = bufferedReader.lines().collect(Collectors.joining("\n"));
        return (T)this.toUnmarshaled(string, clazz, map);
    }

    default public <SRC> InputStream fromUnmarshaled(SRC SRC) throws MarshalException {
        return new ByteArrayInputStream(((String)this.toMarshaled(SRC)).getBytes(StandardCharsets.UTF_8));
    }

    default public <SRC> InputStream fromUnmarshaled(SRC SRC, Map<String, String> map) throws MarshalException {
        return new ByteArrayInputStream(((String)this.toMarshaled(SRC, map)).getBytes(StandardCharsets.UTF_8));
    }
}

