/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.web;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.refcodes.exception.MarshalException;
import org.refcodes.exception.UnmarshalException;
import org.refcodes.web.MediaType;
import org.refcodes.web.MediaTypeFactory;

public class JsonMediaTypeFactory
implements MediaTypeFactory {
    private static MediaType[] MEDIA_TYPES = new MediaType[]{MediaType.APPLICATION_JSON, MediaType.APPLICATION_HAL_JSON, MediaType.APPLICATION_SCHEMA_JSON};
    private ObjectMapper _mapper = new ObjectMapper();

    public JsonMediaTypeFactory() {
        this._mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    @Override
    public MediaType[] getMediaTypes() {
        return MEDIA_TYPES;
    }

    public String toMarshaled(Object object) throws MarshalException {
        try {
            String string = this._mapper.writeValueAsString(object);
            return string;
        }
        catch (Exception exception) {
            throw new MarshalException("A problem occurred marshaling an object of type <" + object.getClass().getName() + ">.", (Throwable)exception);
        }
    }

    public <T> T toUnmarshaled(String string, Class<T> clazz) throws UnmarshalException {
        try {
            if (string == null) {
                return null;
            }
            if (string.length() == 0) {
                return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            Object object = this._mapper.readValue(string, clazz);
            return (T)object;
        }
        catch (JsonParseException | JsonMappingException throwable) {
            throw new UnmarshalException("A problem occurred unmarshaling the HTTP body \"" + string + "\" to type  <" + clazz.getName() + "> at column <" + throwable.getLocation().getColumnNr() + ">: " + throwable.getMessage(), throwable);
        }
        catch (Exception exception) {
            throw new UnmarshalException("A problem occurred unmarshaling the HTTP body \"" + string + "\" to type  <" + clazz.getName() + ">: " + exception.getMessage(), (Throwable)exception);
        }
    }

    protected String toPlainJson(String string) {
        return string.replaceFirst("^\"[A-Za-z][A-Za-z0-9]+\"\\s*:", "");
    }

    protected String toUnboxed(String string) {
        if (string.startsWith("{") && string.endsWith("}")) {
            string = string.substring(1, string.length() - 1);
            string = this.toPlainJson(string);
        }
        return string;
    }

    protected String toElementName(Class<?> clazz) {
        Object object = clazz.getSimpleName();
        if (clazz.isArray()) {
            object = ((String)object).substring(0, ((String)object).length() - 2) + "Array";
        }
        String string = ("" + ((String)object).charAt(0)).toLowerCase();
        object = string + ((String)object).substring(1);
        return object;
    }

    protected String toVariableDeclaration(Class<?> clazz) {
        return "\"" + this.toElementName(clazz) + "\": ";
    }
}

