/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.web;

import org.refcodes.mixin.StatusCodeAccessor;

public enum HttpSuccessCode implements StatusCodeAccessor<Integer>
{
    OK(200),
    CREATED(201),
    ACCEPTED(202),
    NON_AUTHORITATIVE_INFORMATION(203),
    NO_CONTENT(204),
    RESET_CONTENT(205),
    PARTIAL_CONTENT(206),
    MULTI_STATUS(207);

    private Integer _statusCode;

    private HttpSuccessCode(Integer n2) {
        this._statusCode = n2;
    }

    public Integer getStatusCode() {
        return this._statusCode;
    }

    public static HttpSuccessCode toHttpSuccessCode(int n) {
        for (HttpSuccessCode httpSuccessCode : HttpSuccessCode.values()) {
            if (!httpSuccessCode.getStatusCode().equals(n)) continue;
            return httpSuccessCode;
        }
        return null;
    }

    public static HttpSuccessCode toHttpSuccessCode(StatusCodeAccessor<Integer> statusCodeAccessor) {
        for (HttpSuccessCode httpSuccessCode : HttpSuccessCode.values()) {
            if (!httpSuccessCode.getStatusCode().equals(statusCodeAccessor.getStatusCode())) continue;
            return httpSuccessCode;
        }
        return null;
    }
}

