/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.web;

import java.util.HashMap;
import org.refcodes.exception.MarshalException;
import org.refcodes.mixin.Dumpable;
import org.refcodes.textual.VerboseTextBuilder;
import org.refcodes.web.AbstractHttpResponse;
import org.refcodes.web.BadResponseException;
import org.refcodes.web.ContentType;
import org.refcodes.web.HeaderField;
import org.refcodes.web.HttpBodyAccessor;
import org.refcodes.web.HttpBodyMap;
import org.refcodes.web.HttpResponse;
import org.refcodes.web.HttpStatusCode;
import org.refcodes.web.HttpStatusCodeAccessor;
import org.refcodes.web.MediaTypeFactory;
import org.refcodes.web.MediaTypeFactoryLookup;
import org.refcodes.web.MediaTypeParameter;
import org.refcodes.web.ResponseHeaderFields;

public class HttpServerResponse
extends AbstractHttpResponse
implements HttpResponse,
HttpStatusCodeAccessor.HttpStatusCodeProperty,
HttpStatusCodeAccessor.HttpStatusCodeBuilder<HttpServerResponse>,
HttpBodyAccessor.HttpBodyProvider<BadResponseException>,
Dumpable {
    protected MediaTypeFactoryLookup _mediaTypeFactoryLookup;
    private Object _response = null;

    public HttpServerResponse(MediaTypeFactoryLookup mediaTypeFactoryLookup) {
        this._mediaTypeFactoryLookup = mediaTypeFactoryLookup;
    }

    public HttpServerResponse(HttpStatusCode httpStatusCode, MediaTypeFactoryLookup mediaTypeFactoryLookup) {
        super(httpStatusCode);
        this._mediaTypeFactoryLookup = mediaTypeFactoryLookup;
    }

    public HttpServerResponse(ResponseHeaderFields responseHeaderFields, MediaTypeFactoryLookup mediaTypeFactoryLookup) {
        super(responseHeaderFields);
        this._mediaTypeFactoryLookup = mediaTypeFactoryLookup;
    }

    @Override
    public HttpServerResponse withHttpStatusCode(HttpStatusCode httpStatusCode) {
        this.setHttpStatusCode(httpStatusCode);
        return this;
    }

    public <RES> HttpServerResponse withResponse(RES RES) {
        this.setResponse(RES);
        return this;
    }

    public <RES> RES getResponse() {
        return (RES)this._response;
    }

    public <RES> void setResponse(RES RES) {
        this._response = RES;
    }

    @Override
    public void setHttpStatusCode(HttpStatusCode httpStatusCode) {
        this._httpStatusCode = httpStatusCode;
    }

    @Override
    public String toHttpBody() throws BadResponseException {
        if (this._response != null) {
            MediaTypeFactory mediaTypeFactory = null;
            ContentType contentType = this.getHeaderFields().getContentType();
            String string = null;
            if (contentType == null) {
                throw new BadResponseException("No (known) Media-Type provided in response's Header-Field <" + HeaderField.CONTENT_TYPE.getName() + ">: " + new VerboseTextBuilder().withElements(this.getHeaderFields().get(HeaderField.CONTENT_TYPE)));
            }
            mediaTypeFactory = this._mediaTypeFactoryLookup.toMediaTypeFactory(contentType.getMediaType());
            string = contentType.getCharsetParametrer();
            if (mediaTypeFactory == null) {
                throw new BadResponseException("No Media-Type factory found (added) for Media-Type <" + contentType + "> (raw requested Media-Type is <" + this.getHeaderFields().get(HeaderField.CONTENT_TYPE) + ">)");
            }
            HashMap<String, String> hashMap = null;
            if (string != null) {
                hashMap = new HashMap<String, String>();
                hashMap.put(MediaTypeParameter.CHARSET.getName(), string);
            }
            try {
                Object object = this._response;
                if (this._response instanceof HttpBodyMap) {
                    object = ((HttpBodyMap)((Object)this._response)).toDataStructure();
                }
                return (String)mediaTypeFactory.toMarshaled(object, hashMap);
            }
            catch (MarshalException marshalException) {
                throw new BadResponseException("Unable to marshal response <" + this.getResponse() + ">.", (Throwable)marshalException);
            }
        }
        return null;
    }

    public String toString() {
        return this.getClass().getName() + " [_httpStatusCode=" + this._httpStatusCode + "]";
    }
}

