/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.web;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.refcodes.data.Encoding;
import org.refcodes.exception.UnmarshalException;
import org.refcodes.io.InputStreamStringBuilder;
import org.refcodes.textual.VerboseTextBuilder;
import org.refcodes.web.AbstractHttpRequest;
import org.refcodes.web.BadRequestException;
import org.refcodes.web.ContentType;
import org.refcodes.web.HeaderField;
import org.refcodes.web.HttpBodyAccessor;
import org.refcodes.web.HttpBodyMap;
import org.refcodes.web.HttpInputStreamAccessor;
import org.refcodes.web.HttpMethod;
import org.refcodes.web.HttpRequest;
import org.refcodes.web.MediaType;
import org.refcodes.web.MediaTypeFactoryLookup;
import org.refcodes.web.MediaTypeParameter;
import org.refcodes.web.RequestHeaderFields;
import org.refcodes.web.Url;

public class HttpServerRequest
extends AbstractHttpRequest
implements HttpRequest,
HttpBodyAccessor,
HttpInputStreamAccessor {
    protected MediaTypeFactoryLookup _mediaTypeFactoryLookup;
    private String _httpBody = null;
    private InputStream _httpInputStream = null;

    public HttpServerRequest(HttpMethod httpMethod, Url url, RequestHeaderFields requestHeaderFields, InputStream inputStream, MediaTypeFactoryLookup mediaTypeFactoryLookup) {
        super(httpMethod, url, requestHeaderFields);
        this._httpInputStream = inputStream;
        this._mediaTypeFactoryLookup = mediaTypeFactoryLookup;
    }

    public HttpBodyMap getRequest() throws BadRequestException {
        return this.getRequest(HttpBodyMap.class);
    }

    public <REQ> REQ getRequest(Class<REQ> clazz) throws BadRequestException {
        if (clazz.isAssignableFrom(InputStream.class)) {
            return (REQ)this._httpInputStream;
        }
        String string = this.getHttpBody();
        if (string == null) {
            return null;
        }
        if (clazz.isAssignableFrom(String.class)) {
            return (REQ)string;
        }
        HashMap<String, String> hashMap = null;
        ContentType object2 = this.getHeaderFields().getContentType();
        if (object2 == null && this.getHeaderFields().getAcceptTypes() != null && this.getHeaderFields().getAcceptTypes().size() != 0) {
            for (ContentType object3 : this.getHeaderFields().getAcceptTypes()) {
                if (!this._mediaTypeFactoryLookup.hasMediaTypeFactory(object3.getMediaType())) continue;
                object2 = object3;
                break;
            }
        }
        Object object4 = null;
        if (object2 == null) {
            MediaType[] unmarshalException = this._mediaTypeFactoryLookup.getFactoryMediaTypes();
            if (unmarshalException != null && unmarshalException.length != 0) {
                object4 = this._mediaTypeFactoryLookup.toMediaTypeFactory(unmarshalException[0]);
            }
        } else {
            object4 = this._mediaTypeFactoryLookup.toMediaTypeFactory(object2.getMediaType());
            String string2 = object2.getCharsetParametrer();
            if (string2 != null) {
                hashMap = new HashMap<String, String>();
                hashMap.put(MediaTypeParameter.CHARSET.getName(), string2);
            }
        }
        if (object4 == null) {
            throw new BadRequestException("No Media-Type factory found (added) for Media-Type <" + object2 + "> (raw requested Media-Type is <" + this.getHeaderFields().get(HeaderField.CONTENT_TYPE) + ">)");
        }
        try {
            if (HttpBodyMap.class.isAssignableFrom(clazz)) {
                if (string.length() == 0) {
                    return (REQ)((Object)new HttpBodyMap());
                }
                Map map = (Map)object4.toUnmarshaled((Object)string, Map.class, hashMap);
                return (REQ)((Object)new HttpBodyMap(map));
            }
            return (REQ)object4.toUnmarshaled((Object)string, clazz, hashMap);
        }
        catch (UnmarshalException unmarshalException) {
            throw new BadRequestException("Unable to unmarshal request body with Media-Type <" + new VerboseTextBuilder().toString((Object[])object4.getMediaTypes()) + "> from URL <" + this.getUrl().toHttpUrl() + "> with HTTP-Method <" + this.getHttpMethod() + "> and request body <" + this.getHttpBody() + ">.", (Throwable)unmarshalException);
        }
    }

    @Override
    public InputStream getHttpInputStream() {
        return this._httpInputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getHttpBody() {
        if (this._httpBody == null) {
            HttpServerRequest httpServerRequest = this;
            synchronized (httpServerRequest) {
                if (this._httpBody == null) {
                    try {
                        ContentType contentType = this.getHeaderFields().getContentType();
                        String string = contentType != null && contentType.getCharsetParametrer() != null ? contentType.getCharsetParametrer() : Encoding.UTF_8.getCode();
                        this._httpBody = new InputStreamStringBuilder().toString(this._httpInputStream, string);
                    }
                    catch (IOException iOException) {
                        this._httpBody = iOException.getMessage();
                    }
                }
            }
        }
        return this._httpBody;
    }

    public String toString() {
        return this.getClass().getName() + " [_httpMethod=" + this._httpMethod + ", _url=" + this._url + "]";
    }
}

