/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.web;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.refcodes.data.Encoding;
import org.refcodes.io.InputStreamStringBuilder;
import org.refcodes.web.AbstractHttpResponse;
import org.refcodes.web.BadResponseException;
import org.refcodes.web.ContentType;
import org.refcodes.web.HeaderField;
import org.refcodes.web.HttpBodyAccessor;
import org.refcodes.web.HttpBodyMap;
import org.refcodes.web.HttpInputStreamAccessor;
import org.refcodes.web.HttpResponse;
import org.refcodes.web.HttpStatusCode;
import org.refcodes.web.MediaType;
import org.refcodes.web.MediaTypeFactory;
import org.refcodes.web.MediaTypeFactoryLookup;
import org.refcodes.web.MediaTypeParameter;
import org.refcodes.web.ResponseHeaderFields;
import org.refcodes.web.Url;
import org.refcodes.web.UrlAccessor;

public class HttpClientResponse
extends AbstractHttpResponse
implements HttpResponse,
HttpBodyAccessor,
HttpInputStreamAccessor,
UrlAccessor {
    protected MediaTypeFactoryLookup _mediaTypeFactoryLookup;
    private Url _url = null;
    private String _httpBody = null;
    private InputStream _httpInputStream = null;

    public HttpClientResponse(Url url, HttpStatusCode httpStatusCode, ResponseHeaderFields responseHeaderFields, InputStream inputStream, MediaTypeFactoryLookup mediaTypeFactoryLookup) {
        super(httpStatusCode, responseHeaderFields);
        this._mediaTypeFactoryLookup = mediaTypeFactoryLookup;
        this._httpInputStream = inputStream;
        this._url = url;
    }

    public HttpBodyMap getResponse() throws BadResponseException {
        return this.getResponse(HttpBodyMap.class);
    }

    public <RES> RES getResponse(Class<RES> clazz) throws BadResponseException {
        if (clazz.isAssignableFrom(InputStream.class)) {
            return (RES)this._httpInputStream;
        }
        if (clazz.isAssignableFrom(String.class)) {
            return (RES)this.getHttpBody();
        }
        MediaTypeFactory mediaTypeFactory = null;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String string = this.getHttpBody();
        if (string != null) {
            Object object;
            ContentType contentType = this.getHeaderFields().getContentType();
            if (contentType == null) {
                object = this._mediaTypeFactoryLookup.getFactoryMediaTypes();
                if (object != null && ((MediaType[])object).length != 0) {
                    mediaTypeFactory = this._mediaTypeFactoryLookup.toMediaTypeFactory(object[0]);
                }
            } else {
                mediaTypeFactory = this._mediaTypeFactoryLookup.toMediaTypeFactory(contentType.getMediaType());
                object = contentType.getCharsetParametrer();
                if (object != null) {
                    hashMap.put(MediaTypeParameter.CHARSET.getName(), object);
                }
            }
            if (mediaTypeFactory == null) {
                throw new BadResponseException("No Media-Type factory found (added) for Media-Type <" + contentType + "> (raw requested Media-Type is <" + this.getHeaderFields().get(HeaderField.CONTENT_TYPE) + ">)");
            }
            try {
                hashMap.put(MediaTypeParameter.BASE_URL.getName(), this._url.toHttpUrl());
                if (HttpBodyMap.class.isAssignableFrom(clazz)) {
                    object = (Map)mediaTypeFactory.toUnmarshaled(string, Map.class, hashMap);
                    return (RES)((Object)new HttpBodyMap(object));
                }
                return (RES)mediaTypeFactory.toUnmarshaled(string, clazz, hashMap);
            }
            catch (Exception exception) {
                throw new BadResponseException("Unable to parse response body {" + this.getHttpBody() + "}.", (Throwable)exception);
            }
        }
        return null;
    }

    @Override
    public InputStream getHttpInputStream() {
        return this._httpInputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getHttpBody() {
        if (this._httpBody == null) {
            HttpClientResponse httpClientResponse = this;
            synchronized (httpClientResponse) {
                if (this._httpBody == null) {
                    try {
                        ContentType contentType = this.getHeaderFields().getContentType();
                        String string = contentType != null && contentType.getCharsetParametrer() != null ? contentType.getCharsetParametrer() : Encoding.UTF_8.getCode();
                        this._httpBody = new InputStreamStringBuilder().toString(this._httpInputStream, string);
                    }
                    catch (IOException iOException) {
                        this._httpBody = iOException.getMessage();
                    }
                }
            }
        }
        return this._httpBody;
    }

    @Override
    public Url getUrl() {
        return this._url;
    }

    public String toString() {
        return this.getClass().getName() + " [httpStatusCode=" + this._httpStatusCode + "]";
    }
}

