/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.web;

import java.util.HashMap;
import org.refcodes.exception.MarshalException;
import org.refcodes.struct.PathMap;
import org.refcodes.textual.VerboseTextBuilder;
import org.refcodes.web.AbstractHttpRequest;
import org.refcodes.web.BadRequestException;
import org.refcodes.web.ContentType;
import org.refcodes.web.FormFields;
import org.refcodes.web.HeaderField;
import org.refcodes.web.HttpBodyAccessor;
import org.refcodes.web.HttpMethod;
import org.refcodes.web.HttpRequest;
import org.refcodes.web.MediaType;
import org.refcodes.web.MediaTypeFactory;
import org.refcodes.web.MediaTypeFactoryLookup;
import org.refcodes.web.MediaTypeParameter;
import org.refcodes.web.RedirectDepthAccessor;
import org.refcodes.web.RequestHeaderFields;
import org.refcodes.web.Url;

public class HttpClientRequest
extends AbstractHttpRequest
implements HttpRequest,
HttpBodyAccessor.HttpBodyProvider<BadRequestException>,
RedirectDepthAccessor.RedirectDepthProperty {
    public static final int DEFAULT_REDIRECT_DEPTH = -1;
    protected MediaTypeFactoryLookup _mediaTypeFactoryLookup;
    private int _redirectDepth = -1;
    private Object _request = null;

    public HttpClientRequest(HttpMethod httpMethod, Url url, MediaTypeFactoryLookup mediaTypeFactoryLookup) {
        this(httpMethod, url, (Object)null, -1, mediaTypeFactoryLookup);
    }

    public HttpClientRequest(HttpMethod httpMethod, Url url, Object object, MediaTypeFactoryLookup mediaTypeFactoryLookup) {
        this(httpMethod, url, null, object, -1, mediaTypeFactoryLookup);
    }

    public HttpClientRequest(HttpMethod httpMethod, Url url, RequestHeaderFields requestHeaderFields, Object object, MediaTypeFactoryLookup mediaTypeFactoryLookup) {
        this(httpMethod, url, requestHeaderFields, object, -1, mediaTypeFactoryLookup);
    }

    public HttpClientRequest(HttpMethod httpMethod, Url url, int n, MediaTypeFactoryLookup mediaTypeFactoryLookup) {
        this(httpMethod, url, (Object)null, n, mediaTypeFactoryLookup);
    }

    public HttpClientRequest(HttpMethod httpMethod, Url url, Object object, int n, MediaTypeFactoryLookup mediaTypeFactoryLookup) {
        this(httpMethod, url, null, object, n, mediaTypeFactoryLookup);
    }

    public HttpClientRequest(HttpMethod httpMethod, Url url, RequestHeaderFields requestHeaderFields, Object object, int n, MediaTypeFactoryLookup mediaTypeFactoryLookup) {
        super(httpMethod, url, requestHeaderFields);
        this._mediaTypeFactoryLookup = mediaTypeFactoryLookup;
        this._redirectDepth = n;
        this.setRequest(object);
    }

    public <REQ> REQ getRequest() {
        return (REQ)this._request;
    }

    public <REQ> void setRequest(REQ REQ) {
        this._request = REQ;
        if (REQ != null && this.getHeaderFields() != null && this.getHeaderFields().getContentType() == null) {
            this.getHeaderFields().putContentType(this.toPreferredContentType());
        }
    }

    @Override
    public String toHttpBody() throws BadRequestException {
        if (this._request == null) {
            return null;
        }
        HashMap<String, String> hashMap = null;
        ContentType contentType = this.toPreferredContentType();
        MediaTypeFactory mediaTypeFactory = this._mediaTypeFactoryLookup.toMediaTypeFactory(contentType.getMediaType());
        String string = contentType.getCharsetParametrer();
        if (string != null) {
            hashMap = new HashMap<String, String>();
            hashMap.put(MediaTypeParameter.CHARSET.getName(), string);
        }
        if (mediaTypeFactory == null) {
            throw new BadRequestException("No Media-Type factory found (added) for request's Media-Type <" + contentType + "> (raw requested Media-Type is <" + this.getHeaderFields().get(HeaderField.CONTENT_TYPE) + ">)");
        }
        try {
            Object object = this._request;
            if (this._request instanceof PathMap) {
                object = ((PathMap)this._request).toDataStructure();
            }
            return (String)mediaTypeFactory.toMarshaled(object, hashMap);
        }
        catch (MarshalException marshalException) {
            throw new BadRequestException("Unable to marshal request <" + this.getRequest() + "> to request's Media-Type <" + new VerboseTextBuilder().toString((Object[])mediaTypeFactory.getMediaTypes()) + ">.", (Throwable)marshalException);
        }
    }

    public String toString() {
        return this.getClass().getName() + " [httpMethod=" + this._httpMethod + ", url=" + this._url + "]";
    }

    private ContentType toPreferredContentType() {
        ContentType contentType = this.getHeaderFields().getContentType();
        if (contentType == null) {
            if (this._request instanceof FormFields && this._mediaTypeFactoryLookup.hasMediaTypeFactory(MediaType.APPLICATION_X_WWW_FORM_URLENCODED)) {
                return MediaType.APPLICATION_X_WWW_FORM_URLENCODED.toContentType();
            }
            MediaType[] mediaTypeArray = this._mediaTypeFactoryLookup.getFactoryMediaTypes();
            if (mediaTypeArray != null && mediaTypeArray.length != 0) {
                this.getHeaderFields().putContentType(mediaTypeArray[0]);
                contentType = new ContentType(mediaTypeArray[0]);
            }
        }
        return contentType;
    }

    @Override
    public int getRedirectDepth() {
        return this._redirectDepth;
    }

    @Override
    public void setRedirectDepth(int n) {
        this._redirectDepth = n;
    }
}

