/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.web;

import java.util.Collection;
import java.util.regex.Pattern;
import org.refcodes.struct.CanonicalMap;
import org.refcodes.struct.CanonicalMapBuilderImpl;
import org.refcodes.struct.PathMap;
import org.refcodes.struct.Property;
import org.refcodes.struct.Relation;
import org.refcodes.web.HttpStatusCode;

public class HttpBodyMap
extends CanonicalMapBuilderImpl
implements CanonicalMap.CanonicalMapBuilder {
    private static final long serialVersionUID = 1L;
    public static final String STATUS_CODE_PATH = "/status/code";
    public static final String STATUS_ALIAS_PATH = "/status/alias";
    public static final String STATUS_MESSAGE_PATH = "/status/message";
    public static final String STATUS_EXCEPTION_PATH = "/status/exception";
    public static final String STATUS_TIMESTAMP_PATH = "/status/timestamp";

    public HttpBodyMap() {
    }

    public HttpBodyMap(Object object) {
        super(object);
    }

    public HttpBodyMap(String string, Object object) {
        super(string, object);
    }

    public HttpBodyMap(Object object, String string) {
        super(object, string);
    }

    public HttpBodyMap(String string, Object object, String string2) {
        super(string, object, string2);
    }

    private HttpBodyMap(PathMap<String> pathMap) {
        for (String string : pathMap.paths()) {
            this.put(string, (String)pathMap.get((Object)string));
        }
    }

    public HttpBodyMap retrieveFrom(String string) {
        return new HttpBodyMap((PathMap<String>)super.retrieveFrom(string));
    }

    public HttpBodyMap retrieveTo(String string) {
        return new HttpBodyMap((PathMap<String>)super.retrieveTo(string));
    }

    public HttpBodyMap retrieveBetween(String string, String string2) {
        return new HttpBodyMap((PathMap<String>)super.retrieveBetween(string, string2));
    }

    public HttpBodyMap withPut(String string, String string2) {
        this.put(string, string2);
        return this;
    }

    public HttpBodyMap getDirAt(int n) {
        return this.getDirAt(this.getRootPath(), n);
    }

    public HttpBodyMap getDirAt(String string, int n) {
        return this.retrieveFrom(string, n);
    }

    public String getStatusAlias() {
        return (String)this.get(STATUS_ALIAS_PATH);
    }

    public HttpStatusCode getStatusCode() {
        return HttpStatusCode.toHttpStatusCode(this.getInt(STATUS_CODE_PATH));
    }

    public Class<?> getStatusException() {
        try {
            return Class.forName((String)this.get(STATUS_EXCEPTION_PATH));
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public String getStatusMessage() {
        return (String)this.get(STATUS_MESSAGE_PATH);
    }

    public Long getStatusTimeStamp() {
        return this.getLong(STATUS_TIMESTAMP_PATH);
    }

    public boolean hasStatusAlias() {
        try {
            return this.getStatusAlias() != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean hasStatusCode() {
        try {
            return this.getStatusCode() != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean hasStatusException() {
        try {
            return Class.forName((String)this.get(STATUS_EXCEPTION_PATH)) != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean hasStatusMessage() {
        return this.containsKey(STATUS_MESSAGE_PATH);
    }

    public boolean hasStatusTimeStamp() {
        try {
            return this.getStatusTimeStamp() != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public HttpBodyMap putDirAt(Collection<?> collection, int n, Object object) throws IllegalArgumentException {
        return this.putDirAt(this.toPath(collection), n, object);
    }

    public HttpBodyMap putDirAt(Collection<?> collection, int n, PathMap<String> pathMap) throws IllegalArgumentException {
        return this.putDirAt(this.toPath(collection), n, pathMap);
    }

    public HttpBodyMap putDirAt(int n, Object object) throws IllegalArgumentException {
        return this.putDirAt(this.getRootPath(), n, object);
    }

    public HttpBodyMap putDirAt(int n, PathMap<String> pathMap) throws IllegalArgumentException {
        return this.putDirAt(this.getRootPath(), n, pathMap);
    }

    public HttpBodyMap putDirAt(Object object, int n, Object object2) throws IllegalArgumentException {
        return this.putDirAt(this.toPath(object), n, object2);
    }

    public HttpBodyMap putDirAt(Object object, int n, PathMap<String> pathMap) throws IllegalArgumentException {
        return this.putDirAt(this.toPath(object), n, pathMap);
    }

    public HttpBodyMap putDirAt(Object[] objectArray, int n, Object object) throws IllegalArgumentException {
        return this.putDirAt(this.toPath(objectArray), n, object);
    }

    public HttpBodyMap putDirAt(Object[] objectArray, int n, PathMap<String> pathMap) throws IllegalArgumentException {
        return this.putDirAt(this.toPath(objectArray), n, pathMap);
    }

    public HttpBodyMap putDirAt(String string, int n, Object object) throws IllegalArgumentException {
        HttpBodyMap httpBodyMap = this.removeDirAt(string, n);
        this.insertTo(this.toPath(new Object[]{string, n}), object);
        return httpBodyMap;
    }

    public HttpBodyMap putDirAt(String string, int n, PathMap<String> pathMap) throws IllegalArgumentException {
        HttpBodyMap httpBodyMap = this.removeDirAt(string, n);
        this.insertTo(this.toPath(new Object[]{string, n}), pathMap);
        return httpBodyMap;
    }

    public HttpBodyMap putDirAt(String[] stringArray, int n, Object object) throws IllegalArgumentException {
        return this.putDirAt(this.toPath(stringArray), n, object);
    }

    public HttpBodyMap putDirAt(String[] stringArray, int n, PathMap<String> pathMap) throws IllegalArgumentException {
        return this.putDirAt(this.toPath(stringArray), n, pathMap);
    }

    public String putStatusAlias(HttpStatusCode httpStatusCode) {
        return (String)this.put(STATUS_ALIAS_PATH, httpStatusCode.toVerbose());
    }

    public String putStatusAlias(String string) {
        return (String)this.put(STATUS_ALIAS_PATH, string);
    }

    public String putStatusCode(HttpStatusCode httpStatusCode) {
        return (String)this.putInt(STATUS_CODE_PATH, httpStatusCode.getStatusCode());
    }

    public String putStatusCode(int n) {
        return (String)this.putInt(STATUS_CODE_PATH, n);
    }

    public String putStatusException(Class<Exception> clazz) {
        return (String)this.put(STATUS_EXCEPTION_PATH, clazz.getName());
    }

    public String putStatusException(Exception exception) {
        return (String)this.put(STATUS_EXCEPTION_PATH, exception.getClass().getName());
    }

    public String putStatusMessage(String string) {
        return (String)this.put(STATUS_MESSAGE_PATH, string);
    }

    public String putStatusTimeStamp() {
        return (String)this.putLong(STATUS_TIMESTAMP_PATH, System.currentTimeMillis());
    }

    public String putStatusTimeStamp(long l) {
        return (String)this.putLong(STATUS_TIMESTAMP_PATH, l);
    }

    public HttpBodyMap query(Collection<?> collection) {
        return this.query(this.toPath(collection));
    }

    public HttpBodyMap query(Object ... objectArray) {
        return this.query(this.toPath(objectArray));
    }

    public HttpBodyMap query(String string) {
        return new HttpBodyMap((PathMap<String>)super.query(string));
    }

    public HttpBodyMap query(Pattern pattern) {
        return new HttpBodyMap((PathMap<String>)super.query(pattern));
    }

    public HttpBodyMap query(String ... stringArray) {
        return this.query(this.toPath(stringArray));
    }

    public HttpBodyMap queryBetween(Collection<?> collection, Collection<?> collection2, Collection<?> collection3) {
        return this.queryBetween(this.toPath(collection), this.toPath(collection2), this.toPath(collection3));
    }

    public HttpBodyMap queryBetween(Object object, Object object2, Object object3) {
        return this.queryBetween(this.toPath(object), this.toPath(object2), this.toPath(object3));
    }

    public HttpBodyMap queryBetween(Object[] objectArray, Object[] objectArray2, Object[] objectArray3) {
        return this.queryBetween(this.toPath(objectArray), this.toPath(objectArray2), this.toPath(objectArray3));
    }

    public HttpBodyMap queryBetween(String string, String string2, String string3) {
        return new HttpBodyMap((PathMap<String>)super.queryBetween(string, string2, string3));
    }

    public HttpBodyMap queryBetween(String string, Pattern pattern, String string2) {
        return new HttpBodyMap((PathMap<String>)super.queryBetween(string, pattern, string2));
    }

    public HttpBodyMap queryBetween(String[] stringArray, String[] stringArray2, String[] stringArray3) {
        return this.queryBetween(this.toPath(stringArray), this.toPath(stringArray2), this.toPath(stringArray3));
    }

    public HttpBodyMap queryFrom(Collection<?> collection, Collection<?> collection2) {
        return this.queryFrom(this.toPath(collection), this.toPath(collection2));
    }

    public HttpBodyMap queryFrom(Object object, Object object2) {
        return this.queryFrom(this.toPath(object), this.toPath(object2));
    }

    public HttpBodyMap queryFrom(Object[] objectArray, Object[] objectArray2) {
        return this.queryFrom(this.toPath(objectArray), this.toPath(objectArray2));
    }

    public HttpBodyMap queryFrom(String string, String string2) {
        return new HttpBodyMap((PathMap<String>)super.queryFrom(string, string2));
    }

    public HttpBodyMap queryFrom(Pattern pattern, String string) {
        return new HttpBodyMap((PathMap<String>)super.queryFrom(pattern, string));
    }

    public HttpBodyMap queryFrom(String[] stringArray, String[] stringArray2) {
        return this.queryFrom(this.toPath(stringArray), this.toPath(stringArray2));
    }

    public HttpBodyMap queryTo(Collection<?> collection, String string) {
        return this.queryTo(this.toPath(collection), this.toPath(string));
    }

    public HttpBodyMap queryTo(Object object, String string) {
        return this.queryTo(this.toPath(object), this.toPath(string));
    }

    public HttpBodyMap queryTo(Object[] objectArray, String string) {
        return this.queryTo(this.toPath(objectArray), this.toPath(string));
    }

    public HttpBodyMap queryTo(String string, String string2) {
        return new HttpBodyMap((PathMap<String>)super.queryTo(string, string2));
    }

    public HttpBodyMap queryTo(Pattern pattern, String string) {
        return new HttpBodyMap((PathMap<String>)super.queryTo(pattern, string));
    }

    public HttpBodyMap queryTo(String[] stringArray, String string) {
        return this.queryTo(this.toPath(stringArray), this.toPath(string));
    }

    public HttpBodyMap removePaths(Collection<?> collection) {
        return new HttpBodyMap((PathMap<String>)super.removePaths(collection));
    }

    public HttpBodyMap removePaths(String ... stringArray) {
        return new HttpBodyMap((PathMap<String>)super.removePaths(stringArray));
    }

    public HttpBodyMap removeAll(String ... stringArray) {
        return new HttpBodyMap((PathMap<String>)super.removeAll(stringArray));
    }

    public HttpBodyMap removeAll(Object ... objectArray) {
        return new HttpBodyMap((PathMap<String>)super.removeAll(objectArray));
    }

    public HttpBodyMap removeAll(Collection<?> collection) {
        return new HttpBodyMap((PathMap<String>)super.removeAll(collection));
    }

    public HttpBodyMap removeAll(String string) {
        return new HttpBodyMap((PathMap<String>)super.removeAll(string));
    }

    public HttpBodyMap removeAll(Pattern pattern) {
        return new HttpBodyMap((PathMap<String>)super.removeAll(pattern));
    }

    public HttpBodyMap removeAll(Object object) {
        return new HttpBodyMap((PathMap<String>)super.removeAll(object));
    }

    public HttpBodyMap removeDirAt(int n) {
        return new HttpBodyMap((PathMap<String>)super.removeDirAt(n));
    }

    public HttpBodyMap removeDirAt(Object object, int n) {
        return new HttpBodyMap((PathMap<String>)super.removeDirAt(object, n));
    }

    public HttpBodyMap removeDirAt(Object[] objectArray, int n) {
        return new HttpBodyMap((PathMap<String>)super.removeDirAt(objectArray, n));
    }

    public HttpBodyMap removeDirAt(String string, int n) {
        return new HttpBodyMap((PathMap<String>)super.removeDirAt(string, n));
    }

    public HttpBodyMap removeDirAt(String[] stringArray, int n) {
        return new HttpBodyMap((PathMap<String>)super.removeDirAt(stringArray, n));
    }

    public HttpBodyMap removeFrom(Object ... objectArray) {
        return new HttpBodyMap((PathMap<String>)super.removeFrom(objectArray));
    }

    public HttpBodyMap removeFrom(Object object) {
        return new HttpBodyMap((PathMap<String>)super.removeFrom(object));
    }

    public HttpBodyMap removeFrom(String string) {
        return new HttpBodyMap((PathMap<String>)super.removeFrom(string));
    }

    public HttpBodyMap removeFrom(String ... stringArray) {
        return new HttpBodyMap((PathMap<String>)super.removeFrom(stringArray));
    }

    public HttpBodyMap retrieveBetween(Collection<?> collection, Collection<?> collection2) {
        return this.retrieveBetween(this.toPath(collection), this.toPath(collection2));
    }

    public HttpBodyMap retrieveBetween(Object object, Object object2) {
        return this.retrieveBetween(this.toPath(object), this.toPath(object2));
    }

    public HttpBodyMap retrieveBetween(Object[] objectArray, Object[] objectArray2) {
        return this.retrieveBetween(this.toPath(objectArray), this.toPath(objectArray2));
    }

    public HttpBodyMap retrieveBetween(String[] stringArray, String[] stringArray2) {
        return this.retrieveBetween(this.toPath(stringArray), this.toPath(stringArray2));
    }

    public HttpBodyMap retrieveFrom(Collection<?> collection) {
        return this.retrieveFrom(this.toPath(collection));
    }

    public HttpBodyMap retrieveFrom(Object object) {
        return this.retrieveFrom(this.toPath(object));
    }

    public HttpBodyMap retrieveFrom(Object ... objectArray) {
        return this.retrieveFrom(this.toPath(objectArray));
    }

    public HttpBodyMap retrieveFrom(String ... stringArray) {
        return this.retrieveFrom(this.toPath(stringArray));
    }

    public HttpBodyMap retrieveTo(Collection<?> collection) {
        return this.retrieveTo(this.toPath(collection));
    }

    public HttpBodyMap retrieveTo(Object object) {
        return this.retrieveTo(this.toPath(object));
    }

    public HttpBodyMap retrieveTo(Object ... objectArray) {
        return this.retrieveTo(this.toPath(objectArray));
    }

    public HttpBodyMap retrieveTo(String ... stringArray) {
        return this.retrieveTo(this.toPath(stringArray));
    }

    public HttpBodyMap withPutStatusAlias(HttpStatusCode httpStatusCode) {
        this.put(STATUS_ALIAS_PATH, httpStatusCode.toVerbose());
        return this;
    }

    public HttpBodyMap withPutStatusAlias(String string) {
        this.put(STATUS_ALIAS_PATH, string);
        return this;
    }

    public HttpBodyMap withPutStatusCode(HttpStatusCode httpStatusCode) {
        this.putInt(STATUS_CODE_PATH, httpStatusCode.getStatusCode());
        return this;
    }

    public HttpBodyMap withPutStatusCode(int n) {
        this.putInt(STATUS_CODE_PATH, n);
        return this;
    }

    public HttpBodyMap withPut(Collection<?> collection, String string) {
        this.put(collection, string);
        return this;
    }

    public HttpBodyMap withPut(Object[] objectArray, String string) throws NumberFormatException {
        this.put(objectArray, string);
        return this;
    }

    public HttpBodyMap withPut(Relation<String, String> relation) {
        this.put(relation);
        return this;
    }

    public HttpBodyMap withPut(Property property) {
        this.put(property);
        return this;
    }

    public HttpBodyMap withPut(String[] stringArray, String string) {
        this.put(stringArray, string);
        return this;
    }

    public HttpBodyMap withPutBoolean(Collection<?> collection, Boolean bl) {
        this.putBoolean(collection, bl);
        return this;
    }

    public HttpBodyMap withPutBoolean(Object object, Boolean bl) {
        this.putBoolean(object, bl);
        return this;
    }

    public HttpBodyMap withPutBoolean(Object[] objectArray, Boolean bl) {
        this.putBoolean(objectArray, bl);
        return this;
    }

    public HttpBodyMap withPutBoolean(String string, Boolean bl) {
        this.putBoolean(string, bl);
        return this;
    }

    public HttpBodyMap withPutBoolean(String[] stringArray, Boolean bl) {
        this.putBoolean(stringArray, bl);
        return this;
    }

    public HttpBodyMap withPutByte(Collection<?> collection, Byte by) {
        this.putByte(collection, by);
        return this;
    }

    public HttpBodyMap withPutByte(Object object, Byte by) {
        this.putByte(object, by);
        return this;
    }

    public HttpBodyMap withPutByte(Object[] objectArray, Byte by) {
        this.putByte(objectArray, by);
        return this;
    }

    public HttpBodyMap withPutByte(String string, Byte by) {
        this.putByte(string, by);
        return this;
    }

    public HttpBodyMap withPutByte(String[] stringArray, Byte by) {
        this.putByte(stringArray, by);
        return this;
    }

    public HttpBodyMap withPutChar(Collection<?> collection, Character c) {
        this.putChar(collection, c);
        return this;
    }

    public HttpBodyMap withPutChar(Object object, Character c) {
        this.putChar(object, c);
        return this;
    }

    public HttpBodyMap withPutChar(Object[] objectArray, Character c) {
        this.putChar(objectArray, c);
        return this;
    }

    public HttpBodyMap withPutChar(String string, Character c) {
        this.putChar(string, c);
        return this;
    }

    public HttpBodyMap withPutChar(String[] stringArray, Character c) {
        this.putChar(stringArray, c);
        return this;
    }

    public <C> HttpBodyMap withPutClass(Collection<?> collection, Class<C> clazz) {
        this.putClass(collection, clazz);
        return this;
    }

    public <C> HttpBodyMap withPutClass(Object object, Class<C> clazz) {
        this.putClass(object, clazz);
        return this;
    }

    public <C> HttpBodyMap withPutClass(Object[] objectArray, Class<C> clazz) {
        this.putClass(objectArray, clazz);
        return this;
    }

    public <C> HttpBodyMap withPutClass(String string, Class<C> clazz) {
        this.putClass(string, clazz);
        return this;
    }

    public <C> HttpBodyMap withPutClass(String[] stringArray, Class<C> clazz) {
        this.putClass(stringArray, clazz);
        return this;
    }

    public HttpBodyMap withPutDouble(Collection<?> collection, Double d) {
        this.putDouble(collection, d);
        return this;
    }

    public HttpBodyMap withPutDouble(Object object, Double d) {
        this.putDouble(object, d);
        return this;
    }

    public HttpBodyMap withPutDouble(Object[] objectArray, Double d) {
        this.putDouble(objectArray, d);
        return this;
    }

    public HttpBodyMap withPutDouble(String string, Double d) {
        this.putDouble(string, d);
        return this;
    }

    public HttpBodyMap withPutDouble(String[] stringArray, Double d) {
        this.putDouble(stringArray, d);
        return this;
    }

    public <E extends Enum<E>> HttpBodyMap withPutEnum(Collection<?> collection, E e) {
        this.putEnum(collection, e);
        return this;
    }

    public <E extends Enum<E>> HttpBodyMap withPutEnum(Object object, E e) {
        this.putEnum(object, e);
        return this;
    }

    public <E extends Enum<E>> HttpBodyMap withPutEnum(Object[] objectArray, E e) {
        this.putEnum(objectArray, e);
        return this;
    }

    public <E extends Enum<E>> HttpBodyMap withPutEnum(String string, E e) {
        this.putEnum(string, e);
        return this;
    }

    public <E extends Enum<E>> HttpBodyMap withPutEnum(String[] stringArray, E e) {
        this.putEnum(stringArray, e);
        return this;
    }

    public HttpBodyMap withPutFloat(Collection<?> collection, Float f) {
        this.putFloat(collection, f);
        return this;
    }

    public HttpBodyMap withPutFloat(Object object, Float f) {
        this.putFloat(object, f);
        return this;
    }

    public HttpBodyMap withPutFloat(Object[] objectArray, Float f) {
        this.putFloat(objectArray, f);
        return this;
    }

    public HttpBodyMap withPutFloat(String string, Float f) {
        this.putFloat(string, f);
        return this;
    }

    public HttpBodyMap withPutFloat(String[] stringArray, Float f) {
        this.putFloat(stringArray, f);
        return this;
    }

    public HttpBodyMap withPutInt(Collection<?> collection, Integer n) {
        this.putInt(collection, n);
        return this;
    }

    public HttpBodyMap withPutInt(Object object, Integer n) {
        this.putInt(object, n);
        return this;
    }

    public HttpBodyMap withPutInt(Object[] objectArray, Integer n) {
        this.putInt(objectArray, n);
        return this;
    }

    public HttpBodyMap withPutInt(String string, Integer n) {
        this.putInt(string, n);
        return this;
    }

    public HttpBodyMap withPutInt(String[] stringArray, Integer n) {
        this.putInt(stringArray, n);
        return this;
    }

    public HttpBodyMap withPutLong(Collection<?> collection, Long l) {
        this.putLong(collection, l);
        return this;
    }

    public HttpBodyMap withPutLong(Object object, Long l) {
        this.putLong(object, l);
        return this;
    }

    public HttpBodyMap withPutLong(Object[] objectArray, Long l) {
        this.putLong(objectArray, l);
        return this;
    }

    public HttpBodyMap withPutLong(String string, Long l) {
        this.putLong(string, l);
        return this;
    }

    public HttpBodyMap withPutLong(String[] stringArray, Long l) {
        this.putLong(stringArray, l);
        return this;
    }

    public HttpBodyMap withPutShort(Collection<?> collection, Short s) {
        this.putShort(collection, s);
        return this;
    }

    public HttpBodyMap withPutShort(Object object, Short s) {
        this.putShort(object, s);
        return this;
    }

    public HttpBodyMap withPutShort(Object[] objectArray, Short s) {
        this.putShort(objectArray, s);
        return this;
    }

    public HttpBodyMap withPutShort(String string, Short s) {
        this.putShort(string, s);
        return this;
    }

    public HttpBodyMap withPutShort(String[] stringArray, Short s) {
        this.putShort(stringArray, s);
        return this;
    }

    public HttpBodyMap withPutString(Collection<?> collection, String string) {
        this.putString(collection, string);
        return this;
    }

    public HttpBodyMap withPutString(Object object, String string) {
        this.putString(object, string);
        return this;
    }

    public HttpBodyMap withPutString(Object[] objectArray, String string) {
        this.putString(objectArray, string);
        return this;
    }

    public HttpBodyMap withPutString(String string, String string2) {
        this.putString(string, string2);
        return this;
    }

    public HttpBodyMap withPutString(String[] stringArray, String string) {
        this.putString(stringArray, string);
        return this;
    }

    public HttpBodyMap withInsert(Object object) {
        this.insert(object);
        return this;
    }

    public HttpBodyMap withInsert(PathMap<String> pathMap) {
        this.insert(pathMap);
        return this;
    }

    public HttpBodyMap withInsertBetween(Collection<?> collection, Object object, Collection<?> collection2) {
        this.insertBetween(collection, object, collection2);
        return this;
    }

    public HttpBodyMap withInsertBetween(Collection<?> collection, PathMap<String> pathMap, Collection<?> collection2) {
        this.insertBetween(collection, pathMap, collection2);
        return this;
    }

    public HttpBodyMap withInsertBetween(Object object, Object object2, Object object3) {
        this.insertBetween(object, object2, object3);
        return this;
    }

    public HttpBodyMap withInsertBetween(Object object, PathMap<String> pathMap, Object object2) {
        this.insertBetween(object, pathMap, object2);
        return this;
    }

    public HttpBodyMap withInsertBetween(Object[] objectArray, Object object, Object[] objectArray2) {
        this.insertBetween(objectArray, object, objectArray2);
        return this;
    }

    public HttpBodyMap withInsertBetween(Object[] objectArray, PathMap<String> pathMap, Object[] objectArray2) {
        this.insertBetween(objectArray, pathMap, objectArray2);
        return this;
    }

    public HttpBodyMap withInsertBetween(String string, Object object, String string2) {
        this.insertBetween(string, object, string2);
        return this;
    }

    public HttpBodyMap withInsertBetween(String string, PathMap<String> pathMap, String string2) {
        this.insertBetween(string, pathMap, string2);
        return this;
    }

    public HttpBodyMap withInsertBetween(String[] stringArray, Object object, String[] stringArray2) {
        this.insertBetween(stringArray, object, stringArray2);
        return this;
    }

    public HttpBodyMap withInsertBetween(String[] stringArray, PathMap<String> pathMap, String[] stringArray2) {
        this.insertBetween(stringArray, pathMap, stringArray2);
        return this;
    }

    public HttpBodyMap withInsertFrom(Object object, Collection<?> collection) {
        this.insertFrom(object, collection);
        return this;
    }

    public HttpBodyMap withInsertFrom(Object object, Object object2) {
        this.insertFrom(object, object2);
        return this;
    }

    public HttpBodyMap withInsertFrom(Object object, Object ... objectArray) {
        this.withInsertFrom(object, objectArray);
        return this;
    }

    public HttpBodyMap withInsertFrom(Object object, String string) {
        this.insertFrom(object, string);
        return this;
    }

    public HttpBodyMap withInsertFrom(Object object, String ... stringArray) {
        this.insertFrom(object, stringArray);
        return this;
    }

    public HttpBodyMap withInsertFrom(PathMap<String> pathMap, Collection<?> collection) {
        this.insertFrom(pathMap, collection);
        return this;
    }

    public HttpBodyMap withInsertFrom(PathMap<String> pathMap, Object object) {
        this.insertFrom(pathMap, object);
        return this;
    }

    public HttpBodyMap withInsertFrom(PathMap<String> pathMap, Object ... objectArray) {
        this.withInsertFrom((PathMap)pathMap, objectArray);
        return this;
    }

    public HttpBodyMap withInsertFrom(PathMap<String> pathMap, String string) {
        this.insertFrom(pathMap, string);
        return this;
    }

    public HttpBodyMap withInsertFrom(PathMap<String> pathMap, String ... stringArray) {
        this.insertFrom(pathMap, stringArray);
        return this;
    }

    public HttpBodyMap withInsertTo(Collection<?> collection, Object object) {
        this.insertTo(collection, object);
        return this;
    }

    public HttpBodyMap withInsertTo(Collection<?> collection, PathMap<String> pathMap) {
        this.insertTo(collection, pathMap);
        return this;
    }

    public HttpBodyMap withInsertTo(Object object, Object object2) {
        this.insertTo(object, object2);
        return this;
    }

    public HttpBodyMap withInsertTo(Object object, PathMap<String> pathMap) {
        this.insertTo(object, pathMap);
        return this;
    }

    public HttpBodyMap withInsertTo(Object[] objectArray, Object object) {
        this.insertTo(objectArray, object);
        return this;
    }

    public HttpBodyMap withInsertTo(Object[] objectArray, PathMap<String> pathMap) {
        this.insertTo(objectArray, pathMap);
        return this;
    }

    public HttpBodyMap withInsertTo(String string, Object object) {
        this.insertTo(string, object);
        return this;
    }

    public HttpBodyMap withInsertTo(String string, PathMap<String> pathMap) {
        this.insertTo(string, pathMap);
        return this;
    }

    public HttpBodyMap withInsertTo(String[] stringArray, Object object) {
        this.insertTo(stringArray, object);
        return this;
    }

    public HttpBodyMap withInsertTo(String[] stringArray, PathMap<String> pathMap) {
        this.insertTo(stringArray, pathMap);
        return this;
    }

    public HttpBodyMap withMerge(Object object) {
        this.merge(object);
        return this;
    }

    public HttpBodyMap withMerge(PathMap<String> pathMap) {
        this.merge(pathMap);
        return this;
    }

    public HttpBodyMap withMergeBetween(Collection<?> collection, Object object, Collection<?> collection2) {
        this.mergeBetween(collection, object, collection2);
        return this;
    }

    public HttpBodyMap withMergeBetween(Collection<?> collection, PathMap<String> pathMap, Collection<?> collection2) {
        this.mergeBetween(collection, pathMap, collection2);
        return this;
    }

    public HttpBodyMap withMergeBetween(Object object, Object object2, Object object3) {
        this.mergeBetween(object, object2, object3);
        return this;
    }

    public HttpBodyMap withMergeBetween(Object object, PathMap<String> pathMap, Object object2) {
        this.mergeBetween(object, pathMap, object2);
        return this;
    }

    public HttpBodyMap withMergeBetween(Object[] objectArray, Object object, Object[] objectArray2) {
        this.mergeBetween(objectArray, object, objectArray2);
        return this;
    }

    public HttpBodyMap withMergeBetween(Object[] objectArray, PathMap<String> pathMap, Object[] objectArray2) {
        this.mergeBetween(objectArray, objectArray2, objectArray2);
        return this;
    }

    public HttpBodyMap withMergeBetween(String string, Object object, String string2) {
        this.mergeBetween(string, object, string2);
        return this;
    }

    public HttpBodyMap withMergeBetween(String string, PathMap<String> pathMap, String string2) {
        this.mergeBetween(string, pathMap, string2);
        return this;
    }

    public HttpBodyMap withMergeBetween(String[] stringArray, Object object, String[] stringArray2) {
        this.mergeBetween(stringArray, object, stringArray2);
        return this;
    }

    public HttpBodyMap withMergeBetween(String[] stringArray, PathMap<String> pathMap, String[] stringArray2) {
        this.mergeBetween(stringArray, pathMap, stringArray2);
        return this;
    }

    public HttpBodyMap withMergeFrom(Object object, Collection<?> collection) {
        this.mergeFrom(object, collection);
        return this;
    }

    public HttpBodyMap withMergeFrom(Object object, Object object2) {
        this.mergeFrom(object, object2);
        return this;
    }

    public HttpBodyMap withMergeFrom(Object object, Object ... objectArray) {
        this.mergeFrom(object, objectArray);
        return this;
    }

    public HttpBodyMap withMergeFrom(Object object, String string) {
        this.mergeFrom(object, string);
        return this;
    }

    public HttpBodyMap withMergeFrom(Object object, String ... stringArray) {
        this.mergeFrom(object, stringArray);
        return this;
    }

    public HttpBodyMap withMergeFrom(PathMap<String> pathMap, Collection<?> collection) {
        this.mergeFrom(pathMap, collection);
        return this;
    }

    public HttpBodyMap withMergeFrom(PathMap<String> pathMap, Object object) {
        this.mergeFrom(pathMap, object);
        return this;
    }

    public HttpBodyMap withMergeFrom(PathMap<String> pathMap, Object ... objectArray) {
        this.mergeFrom(pathMap, objectArray);
        return this;
    }

    public HttpBodyMap withMergeFrom(PathMap<String> pathMap, String string) {
        this.mergeFrom(pathMap, string);
        return this;
    }

    public HttpBodyMap withMergeFrom(PathMap<String> pathMap, String ... stringArray) {
        this.mergeFrom(pathMap, stringArray);
        return this;
    }

    public HttpBodyMap withMergeTo(Collection<?> collection, Object object) {
        this.mergeTo(collection, object);
        return this;
    }

    public HttpBodyMap withMergeTo(Collection<?> collection, PathMap<String> pathMap) {
        this.mergeTo(collection, pathMap);
        return this;
    }

    public HttpBodyMap withMergeTo(Object object, Object object2) {
        this.mergeTo(object, object2);
        return this;
    }

    public HttpBodyMap withMergeTo(Object object, PathMap<String> pathMap) {
        this.mergeTo(object, pathMap);
        return this;
    }

    public HttpBodyMap withMergeTo(Object[] objectArray, Object object) {
        this.mergeTo(objectArray, object);
        return this;
    }

    public HttpBodyMap withMergeTo(Object[] objectArray, PathMap<String> pathMap) {
        this.mergeTo(objectArray, pathMap);
        return this;
    }

    public HttpBodyMap withMergeTo(String string, Object object) {
        this.mergeTo(string, object);
        return this;
    }

    public HttpBodyMap withMergeTo(String string, PathMap<String> pathMap) {
        this.mergeTo(string, pathMap);
        return this;
    }

    public HttpBodyMap withMergeTo(String[] stringArray, Object object) {
        this.mergeTo(stringArray, object);
        return this;
    }

    public HttpBodyMap withMergeTo(String[] stringArray, PathMap<String> pathMap) {
        this.mergeTo(stringArray, pathMap);
        return this;
    }

    public HttpBodyMap withPutDirAt(Collection<?> collection, int n, Object object) throws IllegalArgumentException {
        this.putDirAt(collection, n, object);
        return this;
    }

    public HttpBodyMap withPutDirAt(Collection<?> collection, int n, PathMap<String> pathMap) throws IllegalArgumentException {
        this.putDirAt(collection, n, pathMap);
        return this;
    }

    public HttpBodyMap withPutDirAt(int n, Object object) throws IllegalArgumentException {
        this.putDirAt(n, object);
        return this;
    }

    public HttpBodyMap withPutDirAt(int n, PathMap<String> pathMap) throws IllegalArgumentException {
        this.putDirAt(n, pathMap);
        return this;
    }

    public HttpBodyMap withPutDirAt(Object object, int n, Object object2) throws IllegalArgumentException {
        this.putDirAt(object, n, object2);
        return this;
    }

    public HttpBodyMap withPutDirAt(Object object, int n, PathMap<String> pathMap) throws IllegalArgumentException {
        this.putDirAt(object, n, pathMap);
        return this;
    }

    public HttpBodyMap withPutDirAt(Object[] objectArray, int n, Object object) throws IllegalArgumentException {
        this.putDirAt(objectArray, n, object);
        return this;
    }

    public HttpBodyMap withPutDirAt(Object[] objectArray, int n, PathMap<String> pathMap) throws IllegalArgumentException {
        this.putDirAt(objectArray, n, pathMap);
        return this;
    }

    public HttpBodyMap withPutDirAt(String string, int n, Object object) throws IllegalArgumentException {
        this.putDirAt(string, n, object);
        return this;
    }

    public HttpBodyMap withPutDirAt(String string, int n, PathMap<String> pathMap) throws IllegalArgumentException {
        this.putDirAt(string, n, pathMap);
        return this;
    }

    public HttpBodyMap withPutDirAt(String[] stringArray, int n, Object object) throws IllegalArgumentException {
        this.putDirAt(stringArray, n, object);
        return this;
    }

    public HttpBodyMap withPutDirAt(String[] stringArray, int n, PathMap<String> pathMap) throws IllegalArgumentException {
        this.putDirAt(stringArray, n, pathMap);
        return this;
    }

    public HttpBodyMap withRemoveFrom(Collection<?> collection) {
        this.removeFrom(collection);
        return this;
    }

    public HttpBodyMap withRemoveFrom(Object object) {
        this.removeFrom(object);
        return this;
    }

    public HttpBodyMap withRemoveFrom(Object ... objectArray) {
        this.removeFrom(objectArray);
        return this;
    }

    public HttpBodyMap withRemoveFrom(String string) {
        this.removeFrom(string);
        return this;
    }

    public HttpBodyMap withRemoveFrom(String ... stringArray) {
        this.removeFrom(stringArray);
        return this;
    }

    public HttpBodyMap withRemovePaths(String ... stringArray) {
        this.removeFrom(stringArray);
        return this;
    }
}

