/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.web;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.refcodes.data.Delimiter;
import org.refcodes.web.AuthType;
import org.refcodes.web.BasicAuthCredentials;
import org.refcodes.web.BearerAuthCredentials;
import org.refcodes.web.ContentEncoding;
import org.refcodes.web.ContentType;
import org.refcodes.web.Cookie;
import org.refcodes.web.HeaderField;
import org.refcodes.web.HttpFields;
import org.refcodes.web.HttpMediaType;
import org.refcodes.web.HttpMethod;
import org.refcodes.web.MediaType;

public interface HeaderFields<C extends Cookie, B extends HeaderFields<C, B>>
extends HttpFields<B> {
    public static final String BASIC_REALM = "Basic realm";

    default public List<HttpMethod> getAllowMethods() {
        List<String> list = this.get(HeaderField.ALLOW);
        if (list != null && list.size() != 0) {
            ArrayList<HttpMethod> arrayList = new ArrayList<HttpMethod>();
            for (String string : list) {
                HttpMethod httpMethod = HttpMethod.fromHttpMethod(string);
                if (httpMethod == null) continue;
                arrayList.add(httpMethod);
            }
            if (arrayList.size() != 0) {
                return arrayList;
            }
        }
        return null;
    }

    default public List<HttpMethod> putAllowMethods(HttpMethod ... httpMethodArray) {
        if (httpMethodArray == null || httpMethodArray.length == 0) {
            return this.removeAllowMethods();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (HttpMethod httpMethod : httpMethodArray) {
            if (httpMethod == null) continue;
            arrayList.add(httpMethod.name());
        }
        if (arrayList.size() == 0) {
            return this.removeAllowMethods();
        }
        List<HttpMethod> list = this.getAllowMethods();
        this.put(HeaderField.ALLOW, arrayList);
        return list;
    }

    default public List<HttpMethod> putAllowMethods(List<HttpMethod> list) {
        if (list == null || list.size() == 0) {
            return this.removeAllowMethods();
        }
        return this.putAllowMethods(list.toArray(new HttpMethod[list.size()]));
    }

    default public B withAllowMethods(HttpMethod ... httpMethodArray) {
        this.putAllowMethods(httpMethodArray);
        return (B)this;
    }

    default public B withAllowMethods(List<HttpMethod> list) {
        this.putAllowMethods(list);
        return (B)this;
    }

    default public List<HttpMethod> removeAllowMethods() {
        List<HttpMethod> list = this.getAllowMethods();
        this.remove(HeaderField.ALLOW);
        return list;
    }

    default public Integer getContentLength() {
        String string = this.getFirst(HeaderField.CONTENT_LENGTH);
        if (string != null) {
            try {
                return Integer.parseInt(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    default public Integer putContentLength(Integer n) {
        if (n == null) {
            return this.removeContentLength();
        }
        Integer n2 = this.getContentLength();
        this.put(HeaderField.CONTENT_LENGTH, n.toString());
        return n2;
    }

    default public B withContentLength(Integer n) {
        this.putContentLength(n);
        return (B)this;
    }

    default public Integer removeContentLength() {
        Integer n = this.getContentLength();
        this.remove(HeaderField.CONTENT_LENGTH);
        return n;
    }

    default public ContentType getContentType() {
        String string = this.getFirst(HeaderField.CONTENT_TYPE);
        if (string != null) {
            try {
                return new ContentType(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    default public List<String> getUnknownContentTypes() {
        List<String> list = this.get(HeaderField.CONTENT_TYPE);
        if (list != null && list.size() != 0) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string : list) {
                String[] stringArray;
                for (String string2 : stringArray = string.split("" + Delimiter.HTTP_HEADER_ELEMENTS.getChar())) {
                    try {
                        new ContentType(string2);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        arrayList.add(string2);
                    }
                }
            }
            if (arrayList.size() != 0) {
                return arrayList;
            }
        }
        return null;
    }

    default public ContentType putContentType(HttpMediaType httpMediaType) {
        if (httpMediaType == null) {
            return this.removeContentType();
        }
        ContentType contentType = this.getContentType();
        this.put(HeaderField.CONTENT_TYPE, httpMediaType.toHttpMediaType());
        return contentType;
    }

    default public ContentType putContentType(MediaType mediaType, Map<String, String> map) {
        if (mediaType == null) {
            return this.removeContentType();
        }
        return this.putContentType(new ContentType(mediaType, map));
    }

    default public B withContentType(HttpMediaType httpMediaType) {
        this.putContentType(httpMediaType);
        return (B)this;
    }

    default public B withContentType(MediaType mediaType, Map<String, String> map) {
        this.putContentType(mediaType, map);
        return (B)this;
    }

    default public ContentType removeContentType() {
        ContentType contentType = this.getContentType();
        this.remove(HeaderField.CONTENT_TYPE);
        return contentType;
    }

    default public List<ContentType> getAcceptTypes() {
        List<String> list = this.get(HeaderField.ACCEPT);
        if (list != null && list.size() != 0) {
            ArrayList<ContentType> arrayList = new ArrayList<ContentType>();
            for (String string : list) {
                String[] stringArray;
                for (String string2 : stringArray = string.split("" + Delimiter.HTTP_HEADER_ELEMENTS.getChar())) {
                    try {
                        arrayList.add(new ContentType(string2));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
            if (arrayList.size() != 0) {
                return arrayList;
            }
        }
        return null;
    }

    default public List<String> getUnknownAcceptTypes() {
        List<String> list = this.get(HeaderField.ACCEPT);
        if (list != null && list.size() != 0) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string : list) {
                String[] stringArray;
                for (String string2 : stringArray = string.split("" + Delimiter.HTTP_HEADER_ELEMENTS.getChar())) {
                    try {
                        new ContentType(string2);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        arrayList.add(string2);
                    }
                }
            }
            if (arrayList.size() != 0) {
                return arrayList;
            }
        }
        return null;
    }

    default public List<ContentType> putAcceptTypes(HttpMediaType ... httpMediaTypeArray) {
        if (httpMediaTypeArray == null || httpMediaTypeArray.length == 0) {
            return this.removeAcceptTypes();
        }
        Object object = "";
        for (int i = 0; i < httpMediaTypeArray.length; ++i) {
            if (httpMediaTypeArray[i] == null) continue;
            object = (String)object + httpMediaTypeArray[i].toHttpMediaType();
            if (i >= httpMediaTypeArray.length - 1) continue;
            object = (String)object + Delimiter.HTTP_HEADER_ELEMENTS.getChar();
        }
        if (((String)object).length() == 0) {
            return this.removeAcceptTypes();
        }
        List<ContentType> list = this.getAcceptTypes();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add((String)object);
        this.put(HeaderField.ACCEPT, arrayList);
        return list;
    }

    default public List<ContentType> putAcceptTypes(List<? extends HttpMediaType> list) {
        if (list == null || list.size() == 0) {
            return this.removeAcceptTypes();
        }
        return this.putAcceptTypes(list.toArray(new HttpMediaType[list.size()]));
    }

    default public B withAcceptTypes(HttpMediaType ... httpMediaTypeArray) {
        this.putAcceptTypes(httpMediaTypeArray);
        return (B)this;
    }

    default public B withAcceptTypes(List<? extends HttpMediaType> list) {
        this.putAcceptTypes(list);
        return (B)this;
    }

    default public List<ContentType> removeAcceptTypes() {
        List<ContentType> list = this.getAcceptTypes();
        this.remove(HeaderField.ACCEPT);
        return list;
    }

    default public List<String> getAcceptCharsets() {
        List<String> list = this.get(HeaderField.ACCEPT_CHARSET);
        if (list != null && list.size() != 0) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string : list) {
                String[] stringArray;
                for (String string2 : stringArray = string.split("" + Delimiter.HTTP_HEADER_ELEMENTS.getChar())) {
                    if (string2 == null || string2.length() <= 0) continue;
                    arrayList.add(string2);
                }
            }
            if (arrayList.size() != 0) {
                return arrayList;
            }
        }
        return null;
    }

    default public List<String> putAcceptCharsets(String ... stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return this.removeAcceptCharsets();
        }
        Object object = "";
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null || stringArray[i].length() == 0) continue;
            object = (String)object + stringArray[i];
            if (i >= stringArray.length - 1) continue;
            object = (String)object + Delimiter.HTTP_HEADER_ELEMENTS.getChar();
        }
        if (((String)object).length() == 0) {
            return this.removeAcceptCharsets();
        }
        List<String> list = this.getAcceptCharsets();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add((String)object);
        this.put(HeaderField.ACCEPT_CHARSET, arrayList);
        return list;
    }

    default public List<String> putAcceptCharsets(List<String> list) {
        if (list == null || list.size() == 0) {
            return this.removeAcceptCharsets();
        }
        return this.putAcceptCharsets(list.toArray(new String[list.size()]));
    }

    default public B withAcceptCharsets(List<String> list) {
        this.putAcceptCharsets(list);
        return (B)this;
    }

    default public B withAcceptCharsets(String ... stringArray) {
        this.putAcceptCharsets(stringArray);
        return (B)this;
    }

    default public List<String> removeAcceptCharsets() {
        List<String> list = this.getAcceptCharsets();
        this.remove(HeaderField.ACCEPT_CHARSET);
        return list;
    }

    default public List<ContentEncoding> getAcceptEncodings() {
        List<String> list = this.get(HeaderField.ACCEPT_ENCODING);
        if (list != null && list.size() != 0) {
            ArrayList<ContentEncoding> arrayList = new ArrayList<ContentEncoding>();
            for (String string : list) {
                String[] stringArray;
                for (String string2 : stringArray = string.split("" + Delimiter.HTTP_HEADER_ELEMENTS.getChar())) {
                    try {
                        arrayList.add(ContentEncoding.fromHttpEncoding(string2));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
            if (arrayList.size() != 0) {
                return arrayList;
            }
        }
        return null;
    }

    default public List<ContentEncoding> putAcceptEncodings(ContentEncoding ... contentEncodingArray) {
        if (contentEncodingArray == null || contentEncodingArray.length == 0) {
            return this.removeAcceptEncodings();
        }
        Object object = "";
        for (int i = 0; i < contentEncodingArray.length; ++i) {
            if (contentEncodingArray[i] == null) continue;
            object = (String)object + contentEncodingArray[i].getName();
            if (i >= contentEncodingArray.length - 1) continue;
            object = (String)object + Delimiter.HTTP_HEADER_ELEMENTS.getChar();
        }
        if (((String)object).length() == 0) {
            return this.removeAcceptEncodings();
        }
        List<ContentEncoding> list = this.getAcceptEncodings();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add((String)object);
        this.put(HeaderField.ACCEPT_ENCODING, arrayList);
        return list;
    }

    default public List<ContentEncoding> putAcceptEncodings(List<ContentEncoding> list) {
        if (list == null || list.size() == 0) {
            return this.removeAcceptEncodings();
        }
        return this.putAcceptEncodings(list.toArray(new ContentEncoding[list.size()]));
    }

    default public B withAcceptEncodings(ContentEncoding ... contentEncodingArray) {
        this.putAcceptEncodings(contentEncodingArray);
        return (B)this;
    }

    default public B withAcceptEncodings(List<ContentEncoding> list) {
        this.putAcceptEncodings(list);
        return (B)this;
    }

    default public List<ContentEncoding> removeAcceptEncodings() {
        List<ContentEncoding> list = this.getAcceptEncodings();
        this.remove(HeaderField.ACCEPT_ENCODING);
        return list;
    }

    default public List<Locale> getAcceptLanguages() {
        List<String> list = this.get(HeaderField.ACCEPT_LANGUAGE);
        if (list != null && list.size() != 0) {
            ArrayList<Locale> arrayList = new ArrayList<Locale>();
            for (String string : list) {
                String[] stringArray;
                for (String string2 : stringArray = string.split("" + Delimiter.HTTP_HEADER_ELEMENTS.getChar())) {
                    try {
                        arrayList.add(Locale.forLanguageTag(string2));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
            if (arrayList.size() != 0) {
                return arrayList;
            }
        }
        return null;
    }

    default public List<Locale> putAcceptLanguages(Locale ... localeArray) {
        if (localeArray == null || localeArray.length == 0) {
            return this.removeAcceptLanguages();
        }
        Object object = "";
        for (int i = 0; i < localeArray.length; ++i) {
            if (localeArray[i] == null) continue;
            object = (String)object + (localeArray[i].getLanguage() != null ? localeArray[i].getLanguage() : "");
            object = (String)object + (localeArray[i].getLanguage() != null && localeArray[i].getCountry() != null && localeArray[i].getCountry().length() != 0 ? "-" : "");
            object = (String)object + (localeArray[i].getCountry() != null ? localeArray[i].getCountry() : "");
            if (i >= localeArray.length - 1) continue;
            object = (String)object + Delimiter.HTTP_HEADER_ELEMENTS.getChar();
        }
        if (((String)object).length() == 0) {
            return this.removeAcceptLanguages();
        }
        List<Locale> list = this.getAcceptLanguages();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add((String)object);
        this.put(HeaderField.ACCEPT_LANGUAGE, arrayList);
        return list;
    }

    default public List<Locale> putAcceptLanguages(List<Locale> list) {
        if (list == null || list.size() == 0) {
            return this.removeAcceptLanguages();
        }
        return this.putAcceptLanguages(list.toArray(new Locale[list.size()]));
    }

    default public B withAcceptLanguages(Locale ... localeArray) {
        this.putAcceptLanguages(localeArray);
        return (B)this;
    }

    default public B withAcceptLanguages(List<Locale> list) {
        this.putAcceptLanguages(list);
        return (B)this;
    }

    default public List<Locale> removeAcceptLanguages() {
        List<Locale> list = this.getAcceptLanguages();
        this.remove(HeaderField.ACCEPT_LANGUAGE);
        return list;
    }

    default public ContentEncoding getContentEncoding() {
        String string = this.getFirst(HeaderField.CONTENT_ENCODING);
        if (string != null) {
            return ContentEncoding.fromHttpEncoding(string);
        }
        return null;
    }

    default public ContentEncoding putContentEncoding(ContentEncoding contentEncoding) {
        if (contentEncoding == null) {
            return this.removeContentEncoding();
        }
        ContentEncoding contentEncoding2 = this.getContentEncoding();
        this.put(HeaderField.CONTENT_ENCODING, contentEncoding.getName());
        return contentEncoding2;
    }

    default public B withContentEncoding(ContentEncoding contentEncoding) {
        this.putContentEncoding(contentEncoding);
        return (B)this;
    }

    default public ContentEncoding removeContentEncoding() {
        ContentEncoding contentEncoding = this.getContentEncoding();
        this.remove(HeaderField.CONTENT_ENCODING);
        return contentEncoding;
    }

    default public String getUserAgent() {
        return this.getFirst(HeaderField.USER_AGENT);
    }

    default public String putUserAgent(String string) {
        if (string == null || string.length() == 0) {
            return this.removeUserAgent();
        }
        String string2 = this.getUserAgent();
        this.put(HeaderField.USER_AGENT, string);
        return string2;
    }

    default public B withUserAgent(String string) {
        this.putUserAgent(string);
        return (B)this;
    }

    default public String removeUserAgent() {
        String string = this.getUserAgent();
        this.remove(HeaderField.USER_AGENT);
        return string;
    }

    default public String getHost() {
        return this.getFirst(HeaderField.HOST);
    }

    default public String putHost(String string) {
        if (string == null || string.length() == 0) {
            return this.removeHost();
        }
        String string2 = this.getHost();
        this.put(HeaderField.HOST, string);
        return string2;
    }

    default public B withHost(String string) {
        this.putHost(string);
        return (B)this;
    }

    default public String removeHost() {
        String string = this.getHost();
        this.remove(HeaderField.HOST);
        return string;
    }

    default public String getRequestId() {
        return this.getFirst(HeaderField.REQUEST_ID);
    }

    default public String putRequestId(String string) {
        if (string == null || string.length() == 0) {
            return this.removeRequestId();
        }
        String string2 = this.getRequestId();
        this.put(HeaderField.REQUEST_ID, string);
        return string2;
    }

    default public B withRequestId(String string) {
        this.putRequestId(string);
        return (B)this;
    }

    default public String removeRequestId() {
        String string = this.getRequestId();
        this.remove(HeaderField.REQUEST_ID);
        return string;
    }

    default public String getSessionId() {
        return this.getFirst(HeaderField.SESSION_ID);
    }

    default public String putSessionId(String string) {
        if (string == null || string.length() == 0) {
            return this.removeSessionId();
        }
        String string2 = this.getSessionId();
        this.put(HeaderField.SESSION_ID, string);
        return string2;
    }

    default public B withSessionId(String string) {
        this.putSessionId(string);
        return (B)this;
    }

    default public String removeSessionId() {
        String string = this.getSessionId();
        this.remove(HeaderField.SESSION_ID);
        return string;
    }

    default public String getAuthenticate() {
        return this.getFirst(HeaderField.WWW_AUTHENTICATE);
    }

    default public String putAuthenticate(String string) {
        if (string == null || string.length() == 0) {
            return this.removeAuthenticate();
        }
        String string2 = this.getAuthenticate();
        this.put(HeaderField.WWW_AUTHENTICATE, string);
        return string2;
    }

    default public B withAuthenticate(String string) {
        this.putAuthenticate(string);
        return (B)this;
    }

    default public String removeAuthenticate() {
        String string = this.getAuthenticate();
        this.remove(HeaderField.WWW_AUTHENTICATE);
        return string;
    }

    default public String getBasicAuth() {
        String string = this.getFirst(HeaderField.WWW_AUTHENTICATE);
        if (string != null && string.startsWith(BASIC_REALM)) {
            return string;
        }
        return null;
    }

    default public String putBasicAuthRequired(String string) {
        if (string == null) {
            return this.removeBasicAuthenticate();
        }
        String string2 = this.getBasicAuth();
        this.put(HeaderField.WWW_AUTHENTICATE.getName(), "Basic realm=\"" + string + "\"");
        return string2;
    }

    default public B withBasicAuthRequired(String string) {
        this.putBasicAuthRequired(string);
        return (B)this;
    }

    default public String removeBasicAuthenticate() {
        String string = this.getBasicAuth();
        if (string != null) {
            this.remove(HeaderField.WWW_AUTHENTICATE);
        }
        return string;
    }

    default public String toBasicAuthRealm() {
        String string;
        String string2 = this.getAuthenticate();
        if (string2 != null && string2.startsWith(string = "Basic realm=\"") && (string2 = string2.substring(string.length())).endsWith("\"")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    default public String getAuthorization() {
        return this.getFirst(HeaderField.AUTHORIZATION);
    }

    default public String putAuthorization(String string, String string2) {
        if (!(string2 != null && string2.length() != 0 || string != null && string.length() != 0)) {
            return this.removeAuthorization();
        }
        String string3 = this.getAuthorization();
        this.put(HeaderField.AUTHORIZATION, string + " " + string2);
        return string3;
    }

    default public B withAuthorization(String string, String string2) {
        this.putAuthorization(string, string2);
        return (B)this;
    }

    default public String putAuthorization(AuthType authType, String string) {
        if ((string == null || string.length() == 0) && authType == null) {
            return this.removeAuthorization();
        }
        String string2 = this.getAuthorization();
        this.put(HeaderField.AUTHORIZATION, authType.getName() + " " + string);
        return string2;
    }

    default public B withAuthorization(AuthType authType, String string) {
        this.putAuthorization(authType, string);
        return (B)this;
    }

    default public String putAuthorization(String string) {
        if (string == null || string.length() == 0) {
            return this.removeAuthorization();
        }
        String string2 = this.getAuthorization();
        this.put(HeaderField.AUTHORIZATION, string);
        return string2;
    }

    default public B withAuthorization(String string) {
        this.putAuthorization(string);
        return (B)this;
    }

    default public String removeAuthorization() {
        String string = this.getAuthorization();
        this.remove(HeaderField.AUTHORIZATION);
        return string;
    }

    default public BearerAuthCredentials getBearerAuthCredentials() {
        String string = this.getFirst(HeaderField.AUTHORIZATION);
        if (string != null) {
            try {
                return new BearerAuthCredentials().withHttpAuthorization(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    default public BearerAuthCredentials putBearerAuthCredentials(String string) {
        return this.putBearerAuthCredentials(new BearerAuthCredentials(string));
    }

    default public BearerAuthCredentials putBearerAuthCredentials(BearerAuthCredentials bearerAuthCredentials) {
        if (bearerAuthCredentials == null) {
            return this.removeBearerAuthCredentials();
        }
        BearerAuthCredentials bearerAuthCredentials2 = this.getBearerAuthCredentials();
        this.put(HeaderField.AUTHORIZATION, bearerAuthCredentials.toHttpAuthorization());
        return bearerAuthCredentials2;
    }

    default public B withBearerAuthCredentials(BearerAuthCredentials bearerAuthCredentials) {
        this.putBearerAuthCredentials(bearerAuthCredentials);
        return (B)this;
    }

    default public B withBearerAuthCredentials(String string) {
        this.putBearerAuthCredentials(string);
        return (B)this;
    }

    default public BearerAuthCredentials removeBearerAuthCredentials() {
        BearerAuthCredentials bearerAuthCredentials = this.getBearerAuthCredentials();
        if (bearerAuthCredentials != null) {
            this.remove(HeaderField.AUTHORIZATION);
        }
        return bearerAuthCredentials;
    }

    default public BasicAuthCredentials getBasicAuthCredentials() {
        String string = this.getFirst(HeaderField.AUTHORIZATION);
        if (string != null) {
            try {
                return new BasicAuthCredentials().withHttpAuthorization(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    default public BasicAuthCredentials putBasicAuthCredentials(String string, String string2) {
        return this.putBasicAuthCredentials(new BasicAuthCredentials(string, string2));
    }

    default public BasicAuthCredentials putBasicAuthCredentials(BasicAuthCredentials basicAuthCredentials) {
        if (basicAuthCredentials == null) {
            return this.removeBasicAuthCredentials();
        }
        BasicAuthCredentials basicAuthCredentials2 = this.getBasicAuthCredentials();
        this.put(HeaderField.AUTHORIZATION, basicAuthCredentials.toHttpAuthorization());
        return basicAuthCredentials2;
    }

    default public B withBasicAuthCredentials(BasicAuthCredentials basicAuthCredentials) {
        this.putBasicAuthCredentials(basicAuthCredentials);
        return (B)this;
    }

    default public B withBasicAuthCredentials(String string, String string2) {
        this.putBasicAuthCredentials(string, string2);
        return (B)this;
    }

    default public BasicAuthCredentials removeBasicAuthCredentials() {
        BasicAuthCredentials basicAuthCredentials = this.getBasicAuthCredentials();
        if (basicAuthCredentials != null) {
            this.remove(HeaderField.AUTHORIZATION);
        }
        return basicAuthCredentials;
    }

    default public List<String> get(HeaderField headerField) {
        return (List)this.get(headerField.getName());
    }

    default public String getFirst(HeaderField headerField) {
        return this.getFirst(headerField.getName());
    }

    default public void addTo(HeaderField headerField, String string) {
        this.addTo(headerField.getName(), string);
    }

    default public HeaderFields<C, B> withAddTo(HeaderField headerField, String string) {
        return (HeaderFields)this.withAddTo(headerField.getName(), string);
    }

    default public void addTo(HeaderField headerField, String ... stringArray) {
        this.addTo(headerField.getName(), stringArray);
    }

    default public void addTo(HeaderField headerField, List<String> list) {
        this.addTo(headerField.getName(), list);
    }

    default public HeaderFields<C, B> withAddTo(HeaderField headerField, String ... stringArray) {
        return (HeaderFields)this.withAddTo(headerField.getName(), stringArray);
    }

    default public HeaderFields<C, B> withAddTo(HeaderField headerField, List<String> list) {
        return (HeaderFields)this.withAddTo(headerField.getName(), list);
    }

    @Override
    default public List<String> put(HeaderField headerField, String string) {
        return this.put(headerField.getName(), string);
    }

    default public HeaderFields<C, B> withPut(HeaderField headerField, String string) {
        return (HeaderFields)this.withPut(headerField.getName(), string);
    }

    @Override
    default public List<String> put(HeaderField headerField, String ... stringArray) {
        return this.put(headerField.getName(), stringArray);
    }

    @Override
    default public List<String> put(HeaderField headerField, List<String> list) {
        return this.put(headerField.getName(), list);
    }

    default public HeaderFields<C, B> withPut(HeaderField headerField, String ... stringArray) {
        return (HeaderFields)this.withPut(headerField.getName(), stringArray);
    }

    default public HeaderFields<C, B> withPut(HeaderField headerField, List<String> list) {
        return (HeaderFields)this.withPut(headerField.getName(), list);
    }

    default public List<String> remove(HeaderField headerField) {
        return (List)this.remove(headerField.getName());
    }

    public C addCookie(String var1);

    public C addCookie(String var1, String var2);

    public C addCookie(C var1);

    default public HeaderFields<C, B> withAddCookie(String string, String string2) {
        this.addCookie(string, string2);
        return this;
    }

    default public HeaderFields<C, B> withAddCookie(C c) {
        this.addCookie(c);
        return this;
    }

    public List<C> getAllCookies();

    default public List<C> getCookies(String string) {
        List<C> list = this.getAllCookies();
        ArrayList<Cookie> arrayList = new ArrayList<Cookie>();
        for (Cookie cookie : list) {
            if (!string.equals(cookie.getKey())) continue;
            arrayList.add(cookie);
        }
        return arrayList;
    }

    default public C getFirstCookie(String string) {
        List<C> list = this.getCookies(string);
        if (list != null && !list.isEmpty()) {
            return (C)((Cookie)list.get(0));
        }
        return null;
    }

    default public String[] toHttpCookies() {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<C> list = this.getAllCookies();
        if (list == null) {
            return null;
        }
        for (Cookie cookie : list) {
            arrayList.add(cookie.toHttpCookie());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    default public void toHeaderFields(Map<String, List<String>> map) {
        for (String string : this.keySet()) {
            map.put(string, (List)this.get(string));
        }
    }
}

