/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.web;

import java.util.Map;
import org.refcodes.exception.MarshalException;
import org.refcodes.exception.UnmarshalException;
import org.refcodes.web.FormFields;
import org.refcodes.web.MediaType;
import org.refcodes.web.MediaTypeFactory;

public class FormMediaTypeFactory
implements MediaTypeFactory {
    @Override
    public MediaType[] getMediaTypes() {
        return new MediaType[]{MediaType.APPLICATION_X_WWW_FORM_URLENCODED};
    }

    public String toMarshaled(Object object) throws MarshalException {
        try {
            if (object instanceof FormFields) {
                return ((FormFields)object).toBodyFormFields();
            }
            if (object instanceof Map) {
                FormFields formFields = new FormFields();
                formFields.putAll((Map)object);
                return formFields.toBodyFormFields();
            }
            throw new MarshalException("Cannot marshal HTTP Form-Fields from <" + object + "> to type  <" + String.class.getName() + "> as this factory can only marshal HTTP Form-Fields of (sub-)type \"Map<String, List<String>\".");
        }
        catch (Exception exception) {
            throw new MarshalException("A problem occurred marshaling an object of type <" + object.getClass().getName() + ">.", (Throwable)exception);
        }
    }

    public <T> T toUnmarshaled(String string, Class<T> clazz) throws UnmarshalException {
        try {
            if (FormFields.class.equals(clazz)) {
                return (T)(string != null ? new FormFields(string) : null);
            }
            if (FormFields.class.isAssignableFrom(clazz)) {
                FormFields formFields = (FormFields)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                if (string != null && string.length() != 0) {
                    formFields.fromBodyFormFields(string);
                }
                return (T)formFields;
            }
            throw new UnmarshalException("Cannot unmarshal HTTP Form-Fields \"" + string + "\" to type  <" + clazz.getName() + "> as this factory only supports the type <" + FormFields.class.getName() + ">.");
        }
        catch (Exception exception) {
            throw new UnmarshalException("A problem occurred unmarshaling the HTTP body \"" + string + "\" to type  <" + clazz.getName() + ">: " + exception.getMessage(), (Throwable)exception);
        }
    }
}

