/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.web;

import org.refcodes.web.AuthType;
import org.refcodes.web.AuthTypeCredentials;
import org.refcodes.web.ForbiddenException;
import org.refcodes.web.TokenCredentials;

public class BearerAuthCredentials
implements TokenCredentials,
AuthTypeCredentials<BearerAuthCredentials, TokenCredentials> {
    public static final char DELIMITER_AUTH_TYPE = ' ';
    private String _token;

    public BearerAuthCredentials() {
    }

    public BearerAuthCredentials(String string) {
        this._token = string;
    }

    @Override
    public void validate(TokenCredentials tokenCredentials) throws ForbiddenException {
        if (!this.isValid(tokenCredentials)) {
            throw new ForbiddenException("Access denied as of unsuccessfull authentification!");
        }
    }

    @Override
    public void validate(String string) throws ForbiddenException {
        if (!this.isValid(string)) {
            throw new ForbiddenException("Access denied as of unsuccessfull authentification!");
        }
    }

    @Override
    public BearerAuthCredentials withHttpAuthorization(String string) throws IllegalArgumentException {
        this.fromHttpAuthorization(string);
        return this;
    }

    @Override
    public AuthType getAuthType() {
        return AuthType.BEARER;
    }

    public String getToken() {
        return this._token;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this._token == null ? 0 : this._token.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        BearerAuthCredentials bearerAuthCredentials = (BearerAuthCredentials)object;
        return !(this._token == null ? bearerAuthCredentials._token != null : !this._token.equals(bearerAuthCredentials._token));
    }

    public String toString() {
        return "<...>";
    }

    @Override
    public void fromHttpAuthorization(String string) {
        if (string == null) {
            throw new IllegalArgumentException("The provided HTTP authorization value does not conform to the format expected for bearer authentication.");
        }
        int n = string.indexOf(32);
        if (n == -1 || !string.substring(0, n).equalsIgnoreCase(AuthType.BEARER.getName())) {
            throw new IllegalArgumentException("The provided HTTP authorization value does not conform to the format expected for <" + AuthType.BEARER.getName() + "> authentication.");
        }
        this._token = string.substring(n + 1);
    }

    @Override
    public String toHttpAuthorization() {
        return this.getAuthType().getName() + " " + this.getToken();
    }
}

