/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.web;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.refcodes.data.Delimiter;
import org.refcodes.web.AbstractHttpFields;
import org.refcodes.web.Cookie;
import org.refcodes.web.HeaderField;
import org.refcodes.web.HeaderFields;

public abstract class AbstractHeaderFields<C extends Cookie, T extends HeaderFields<C, T>>
extends AbstractHttpFields<T>
implements HeaderFields<C, T> {
    private List<C> _cookies = new ArrayList<C>();

    public AbstractHeaderFields() {
    }

    public AbstractHeaderFields(Map<String, List<String>> map) {
        AbstractHeaderFields.toHeaderFields(map, this);
    }

    @Override
    public List<String> get(Object object) {
        String string = this.toHeaderField(object);
        if (string != null && string.equalsIgnoreCase(this.getCookieFieldName())) {
            String[] stringArray = this.toHttpCookies();
            if (stringArray != null) {
                return new ArrayList<String>(Arrays.asList(stringArray));
            }
            return null;
        }
        return (List)super.get(string);
    }

    @Override
    public Set<String> keySet() {
        if (this._cookies.size() != 0) {
            HashSet<String> hashSet = new HashSet<String>(super.keySet());
            hashSet.add(this.getCookieFieldName());
            return hashSet;
        }
        return super.keySet();
    }

    @Override
    public Set<Map.Entry<String, List<String>>> entrySet() {
        String[] stringArray;
        if (this._cookies.size() != 0 && (stringArray = this.toHttpCookies()) != null) {
            HashSet<Map.Entry<String, List<String>>> hashSet = new HashSet<Map.Entry<String, List<String>>>(super.entrySet());
            hashSet.add(new Field(this.getCookieFieldName(), new ArrayList<String>(Arrays.asList(stringArray))));
            return hashSet;
        }
        return super.entrySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> put(String string, List<String> list) {
        String string2 = this.toHeaderField(string);
        if (string2 != null && string2.equalsIgnoreCase(this.getCookieFieldName())) {
            List<C> list2 = this._cookies;
            synchronized (list2) {
                ArrayList<String> arrayList = null;
                if (this._cookies != null && this._cookies.size() != 0) {
                    arrayList = new ArrayList<String>();
                    for (Cookie object : this._cookies) {
                        arrayList.add(object.toHttpCookie());
                    }
                }
                this._cookies.clear();
                for (String string3 : list) {
                    this.addCookie(this.createCookie(string3));
                }
                return arrayList;
            }
        }
        return super.put(string2, list);
    }

    @Override
    public void addTo(String string, String string2) {
        String string3 = this.toHeaderField(string);
        if (string3.equals(this.getCookieFieldName())) {
            this.addCookie(this.createCookie(string2));
        } else {
            HeaderFields.super.addTo(string3, string2);
        }
    }

    @Override
    public C addCookie(C c) {
        this._cookies.add(c);
        return c;
    }

    @Override
    public List<C> getAllCookies() {
        return this._cookies;
    }

    @Override
    public C addCookie(String string, String string2) {
        return this.addCookie(this.createCookie(string, string2));
    }

    @Override
    public void putAll(Map<? extends String, ? extends List<String>> map) {
        for (String string : map.keySet()) {
            List<String> list = map.get(string);
            String string2 = HeaderField.toHttpHeaderField(string);
            if (this.getCookieFieldName().equalsIgnoreCase(string2)) {
                if (list == null || list.isEmpty()) continue;
                for (String string3 : list) {
                    this.addCookie((C)string3);
                }
                continue;
            }
            this.put(string2, (List<String>)new ArrayList<String>(list));
        }
    }

    protected static boolean isCommaSeparatedHeaderField(String string) {
        return HeaderField.ACCEPT.getName().equalsIgnoreCase(string) || HeaderField.COOKIE.getName().equalsIgnoreCase(string) || HeaderField.SET_COOKIE.getName().equalsIgnoreCase(string);
    }

    protected static void toHeaderFields(Map<String, List<String>> map, HeaderFields<?, ?> headerFields) {
        for (String string : map.keySet()) {
            List<String> list = map.get(string);
            string = HeaderField.toHttpHeaderField(string);
            if (list == null) continue;
            for (String string2 : list) {
                if (string2 == null || string2.trim().length() == 0) continue;
                if (AbstractHeaderFields.isCommaSeparatedHeaderField(string)) {
                    String[] stringArray = string2.split("" + Delimiter.HTTP_HEADER_ELEMENTS.getChar());
                    headerFields.addTo(string, stringArray);
                    continue;
                }
                headerFields.addTo(string, string2);
            }
        }
    }

    protected String toHeaderField(Object object) {
        if (object == null) {
            return null;
        }
        String string = !(object instanceof String) ? object.toString() : (String)object;
        return HeaderField.toHttpHeaderField(string);
    }

    protected abstract String getCookieFieldName();

    protected abstract C createCookie(String var1, String var2);

    protected abstract C createCookie(String var1);

    private static class Field
    implements Map.Entry<String, List<String>> {
        private String _key;
        private List<String> _value;

        public Field(String string, List<String> list) {
            this._key = string;
            this._value = list;
        }

        @Override
        public String getKey() {
            return this._key;
        }

        @Override
        public List<String> getValue() {
            return this._value;
        }

        @Override
        public List<String> setValue(List<String> list) {
            List<String> list2 = this._value;
            this._value = list;
            return list2;
        }
    }
}

