/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.textual;

import org.refcodes.data.EnvironmentVariable;
import org.refcodes.runtime.OperatingSystem;
import org.refcodes.runtime.RuntimeUtility;
import org.refcodes.textual.TextBoxGrid;
import org.refcodes.textual.TextBoxGridImpl;

public enum TextBoxStyle {
    SINGLE(new String[]{"\u250c\u2500\u252c\u2500\u2510", "\u2502 \u2502 \u2502", "\u251c\u2500\u253c\u2500\u2524", "\u2502 \u2502 \u2502", "\u2514\u2500\u2534\u2500\u2518"}),
    SINGLE_DASHED(new String[]{"\u250c\u2500\u252c\u2500\u2510", "\u2502 \u2502 \u2502", "\u251c\u2500\u253c\u2500\u2524", "\u2502 \u2502 \u2502", "\u2514\u2500\u2534\u2500\u2518"}),
    SINGLE_DOUBLE(new String[]{"\u2552\u2550\u2564\u2550\u2555", "\u2502 \u2502 \u2502", "\u255e\u2550\u256a\u2550\u2561", "\u2502 \u2502 \u2502", "\u2558\u2550\u2567\u2550\u255b"}),
    DOUBLE_SINGLE(new String[]{"\u2553\u2500\u2565\u2500\u2556", "\u2551 \u2551 \u2551", "\u255f\u2500\u256b\u2500\u2562", "\u2551 \u2551 \u2551", "\u2559\u2500\u2568\u2500\u255c"}),
    DOUBLE(new String[]{"\u2554\u2550\u2566\u2550\u2557", "\u2551 \u2551 \u2551", "\u2560\u2550\u256c\u2550\u2563", "\u2551 \u2551 \u2551", "\u255a\u2550\u2569\u2550\u255d"}),
    BOLD(new String[]{"\u250f\u2501\u2533\u2501\u2513", "\u2503 \u2503 \u2503", "\u2523\u2501\u254b\u2501\u252b", "\u2503 \u2503 \u2503", "\u2517\u2501\u253b\u2501\u251b"}),
    HYBRID_BOLD_SINGLE(new String[]{"\u250f\u2501\u252f\u2501\u2513", "\u2503 \u2502 \u2503", "\u2520\u2500\u253c\u2500\u2528", "\u2503 \u2502 \u2503", "\u2517\u2501\u2537\u2501\u251b"}),
    HYBRID_SINGLE_BOLD(new String[]{"\u250c\u2500\u2530\u2500\u2510", "\u2502 \u2503 \u2502", "\u251d\u2501\u254b\u2501\u2525", "\u2502 \u2503 \u2502", "\u2514\u2500\u2538\u2500\u2518"}),
    BOLD_HEADER_SINGLE_BODY(new String[]{"\u250f\u2501\u2533\u2501\u2513", "\u2503 \u2503 \u2503", "\u2521\u2501\u2547\u2501\u2529", "\u2502 \u2502 \u2502", "\u2514\u2500\u2534\u2500\u2518"}),
    SINGLE_HEADER_BOLD_BODY(new String[]{"\u250c\u2500\u252c\u2500\u2510", "\u2502 \u2502 \u2502", "\u2522\u2501\u2548\u2501\u252a", "\u2503 \u2503 \u2503", "\u2517\u2501\u253b\u2501\u251b"}),
    HYBRID_BOLD_HEADER_SINGLE_BODY(new String[]{"\u250f\u2501\u252f\u2501\u2513", "\u2503 \u2502 \u2503", "\u2521\u2501\u253f\u2501\u2529", "\u2502 \u2502 \u2502", "\u2514\u2500\u2534\u2500\u2518"}),
    HYBRID_SINGLE_HEADER_BOLD_BODY(new String[]{"\u250c\u2500\u252c\u2500\u2510", "\u2502 \u2502 \u2502", "\u2522\u2501\u253f\u2501\u252a", "\u2503 \u2502 \u2503", "\u2517\u2501\u2537\u2501\u251b"}),
    HYBRID_DOUBLE_SINGLE(new String[]{"\u2554\u2550\u2564\u2550\u2557", "\u2551 \u2502 \u2551", "\u2560\u2550\u256a\u2550\u2563", "\u2551 \u2502 \u2551", "\u255a\u2550\u2567\u2550\u255d"}),
    HYBRID_SINGLE_DOUBLE(new String[]{"\u250c\u2500\u2565\u2500\u2510", "\u2502 \u2551 \u2502", "\u251c\u2500\u256b\u2500\u2524", "\u2502 \u2551 \u2502", "\u2514\u2500\u2568\u2500\u2518"}),
    DOUBLE_BORDER_SINGLE_CONTENT(new String[]{"\u2554\u2550\u2564\u2550\u2557", "\u2551 \u2502 \u2551", "\u255f\u2500\u253c\u2500\u2562", "\u2551 \u2502 \u2551", "\u255a\u2550\u2567\u2550\u255d"}),
    SINGLE_BORDER_DOUBLE_CONTENT(new String[]{"\u250c\u2500\u2565\u2500\u2510", "\u2502 \u2551 \u2502", "\u255e\u2550\u256c\u2550\u2561", "\u2502 \u2551 \u2502", "\u2514\u2500\u2568\u2500\u2518"}),
    ASCII(new String[]{"/-+-\\", "| | |", "+-+-+", "| | |", "\\-+-/"}),
    BLANK(new String[]{"     ", "     ", "     ", "     ", "     "}),
    SINGLE_BLANK(new String[]{" \u2500 \u2500 ", "     ", " \u2500 \u2500 ", "     ", " \u2500 \u2500 "}),
    ASCII_BLANK(new String[]{" - - ", "     ", " - - ", "     ", " - - "});

    public static final TextBoxStyle UNICODE_TEXT_BOX_STYLE;
    public static final TextBoxStyle WINDOWS_TEXT_BOX_STYLE;
    public static final TextBoxStyle OTHER_TEXT_BOX_STYLE;
    private static String CP1252;
    private static String XTERM;
    private TextBoxGrid _textBoxGrid;

    private TextBoxStyle(String[] stringArray) {
        this._textBoxGrid = new TextBoxGridImpl(stringArray);
    }

    public TextBoxGrid getTextBoxGrid() {
        return this._textBoxGrid;
    }

    public static TextBoxStyle toTableStyle(String string) {
        string = string.replaceAll("-", "").replaceAll("_", "");
        for (TextBoxStyle textBoxStyle : TextBoxStyle.values()) {
            if (!textBoxStyle.name().replaceAll("-", "").replaceAll("_", "").equalsIgnoreCase(string)) continue;
            return textBoxStyle;
        }
        return null;
    }

    public static TextBoxStyle toRuntimeTextBoxStyle() {
        if (XTERM.equalsIgnoreCase(EnvironmentVariable.TERM.getValue()) || CP1252.equalsIgnoreCase(EnvironmentVariable.TERMINAL_ENCODING.getValue())) {
            return OTHER_TEXT_BOX_STYLE;
        }
        return RuntimeUtility.isUnderTest() ? OTHER_TEXT_BOX_STYLE : (OperatingSystem.toOperatingSystem() == OperatingSystem.WINDOWS ? WINDOWS_TEXT_BOX_STYLE : UNICODE_TEXT_BOX_STYLE);
    }

    static {
        UNICODE_TEXT_BOX_STYLE = HYBRID_BOLD_SINGLE;
        WINDOWS_TEXT_BOX_STYLE = SINGLE;
        OTHER_TEXT_BOX_STYLE = ASCII;
        CP1252 = "Cp1252";
        XTERM = "xterm";
    }
}

