/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.textual;

import org.refcodes.data.EnvironmentVariable;
import org.refcodes.runtime.OperatingSystem;
import org.refcodes.runtime.RuntimeUtility;
import org.refcodes.textual.TextBoxGrid;
import org.refcodes.textual.TextBoxStyle;

public enum TableStyle {
    SINGLE_HEADER_SINGLE_BODY(TextBoxStyle.SINGLE, TextBoxStyle.SINGLE, TextBoxStyle.SINGLE),
    DOUBLE_SINGLE_HEADER_SINGLE_BODY(TextBoxStyle.DOUBLE_SINGLE, TextBoxStyle.SINGLE, TextBoxStyle.SINGLE),
    DOUBLE_HEADER_DOUBLE_BODY(TextBoxStyle.DOUBLE, TextBoxStyle.DOUBLE, TextBoxStyle.DOUBLE),
    DOUBLE_SINGLE_HEADER_DOUBLE_SINGLE_BODY(TextBoxStyle.DOUBLE_SINGLE, TextBoxStyle.DOUBLE_SINGLE, TextBoxStyle.DOUBLE_SINGLE),
    SINGLE_DOUBLE_HEADER_SINGLE_BODY(TextBoxStyle.SINGLE_DOUBLE, TextBoxStyle.SINGLE, TextBoxStyle.SINGLE),
    SINGLE_DOUBLE_HEADER_SINGLE_DOUBLE_BODY(TextBoxStyle.SINGLE_DOUBLE, TextBoxStyle.SINGLE_DOUBLE, TextBoxStyle.SINGLE_DOUBLE),
    DOUBLE_HEADER_DOUBLE_SINGLE_BODY(TextBoxStyle.DOUBLE, TextBoxStyle.DOUBLE_SINGLE, TextBoxStyle.DOUBLE_SINGLE),
    DOUBLE_SINGLE_HEADER_SINGLE_DASHED_BODY(TextBoxStyle.DOUBLE_SINGLE, TextBoxStyle.SINGLE_DASHED, TextBoxStyle.SINGLE_DASHED),
    BOLD_HEADER_SINGLE_BODY(TextBoxStyle.BOLD_HEADER_SINGLE_BODY, TextBoxStyle.SINGLE, TextBoxStyle.SINGLE),
    HYBRID_BOLD_HEADER_SINGLE_BODY(TextBoxStyle.HYBRID_BOLD_HEADER_SINGLE_BODY, TextBoxStyle.SINGLE, TextBoxStyle.SINGLE),
    ASCII_HEADER_ASCII_BODY(TextBoxStyle.ASCII, TextBoxStyle.ASCII, TextBoxStyle.ASCII),
    BLANK_HEADER_BLANK_BODY(TextBoxStyle.BLANK, TextBoxStyle.BLANK, TextBoxStyle.BLANK),
    SINGLE_BLANK_HEADER_SINGLE_BLANK_BODY(TextBoxStyle.SINGLE_BLANK, TextBoxStyle.SINGLE_BLANK, TextBoxStyle.SINGLE_BLANK),
    ASCII_BLANK_HEADER_ASCII_BLANK_BODY(TextBoxStyle.ASCII_BLANK, TextBoxStyle.ASCII_BLANK, TextBoxStyle.ASCII_BLANK);

    public static final TableStyle UNICODE_TABLE_STYLE;
    public static final TableStyle WINDOWS_TABLE_STYLE;
    public static final TableStyle OTHER_TABLE_STYLE;
    private static String CP1252;
    private static String XTERM;
    private TextBoxGrid _tableHeader;
    private TextBoxGrid _tableBody;
    private TextBoxGrid _tableTail;

    private TableStyle(TextBoxStyle textBoxStyle, TextBoxStyle textBoxStyle2, TextBoxStyle textBoxStyle3) {
        this._tableHeader = textBoxStyle.getTextBoxGrid();
        this._tableBody = textBoxStyle2.getTextBoxGrid();
        this._tableTail = textBoxStyle3.getTextBoxGrid();
    }

    public TextBoxGrid getHeader() {
        return this._tableHeader;
    }

    public TextBoxGrid getBody() {
        return this._tableBody;
    }

    public TextBoxGrid getTail() {
        return this._tableTail;
    }

    public static TableStyle toTableStyle(String string) {
        string = string.replaceAll("-", "").replaceAll("_", "");
        for (TableStyle tableStyle : TableStyle.values()) {
            if (!tableStyle.name().replaceAll("-", "").replaceAll("_", "").equalsIgnoreCase(string)) continue;
            return tableStyle;
        }
        return null;
    }

    public static TableStyle toRuntimeTableStyle() {
        if (XTERM.equalsIgnoreCase(EnvironmentVariable.TERM.getValue()) || CP1252.equalsIgnoreCase(EnvironmentVariable.TERMINAL_ENCODING.getValue())) {
            return OTHER_TABLE_STYLE;
        }
        return RuntimeUtility.isUnderTest() ? OTHER_TABLE_STYLE : (OperatingSystem.toOperatingSystem() == OperatingSystem.WINDOWS ? WINDOWS_TABLE_STYLE : UNICODE_TABLE_STYLE);
    }

    static {
        UNICODE_TABLE_STYLE = HYBRID_BOLD_HEADER_SINGLE_BODY;
        WINDOWS_TABLE_STYLE = SINGLE_HEADER_SINGLE_BODY;
        OTHER_TABLE_STYLE = ASCII_HEADER_ASCII_BODY;
        CP1252 = "Cp1252";
        XTERM = "xterm";
    }
}

