/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.textual;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.refcodes.data.AnsiEscapeCode;
import org.refcodes.data.MoreText;
import org.refcodes.exception.BugException;
import org.refcodes.mixin.EscapeCodesStatusAccessor;
import org.refcodes.mixin.PrintStreamAccessor;
import org.refcodes.mixin.ResetEscapeCodeAccessor;
import org.refcodes.mixin.RowWidthAccessor;
import org.refcodes.numerical.NumericalUtility;
import org.refcodes.runtime.Terminal;
import org.refcodes.textual.ColumnFormatMetrics;
import org.refcodes.textual.ColumnFormatMetricsImpl;
import org.refcodes.textual.ColumnWidthMetrics;
import org.refcodes.textual.ColumnWidthType;
import org.refcodes.textual.HorizAlignTextBuilder;
import org.refcodes.textual.HorizAlignTextMode;
import org.refcodes.textual.MoreTextBuilder;
import org.refcodes.textual.MoreTextMode;
import org.refcodes.textual.SplitTextMode;
import org.refcodes.textual.TablePrinter;
import org.refcodes.textual.TableStatus;
import org.refcodes.textual.TableStyle;
import org.refcodes.textual.TextBlockBuilder;
import org.refcodes.textual.TextBoxGrid;
import org.refcodes.textual.TextFormatMode;
import org.refcodes.textual.TextLineBuilder;
import org.refcodes.textual.VertAlignTextBuilder;
import org.refcodes.textual.VertAlignTextMode;

public class TableBuilder
implements TablePrinter,
RowWidthAccessor.RowWidthProperty,
RowWidthAccessor.RowWidthBuilder<TableBuilder>,
PrintStreamAccessor.PrintStreamProperty,
PrintStreamAccessor.PrintStreamBuilder<TableBuilder>,
ResetEscapeCodeAccessor.ResetEscapeCodeProperty,
ResetEscapeCodeAccessor.ResetEscapeCodeBuilder<TableBuilder>,
EscapeCodesStatusAccessor.EscapeCodeStatusProperty,
EscapeCodesStatusAccessor.EscapeCodeStatusBuilder<TableBuilder> {
    private TableStatus _tableStatus = TableStatus.NONE;
    private List<ColumnRecord> _columnRecords = new ArrayList<ColumnRecord>();
    private int[] _columnWidths = null;
    private int _rowWidth = Terminal.toPreferredTerminalWidth();
    private TableStyle _tableStyle = TableStyle.DOUBLE_SINGLE_HEADER_SINGLE_BODY;
    private String _lineBreak = Terminal.getLineBreak();
    private PrintStream _printStream = System.out;
    private HorizAlignTextMode _headerAlignMode = HorizAlignTextMode.CENTER;
    private HorizAlignTextMode _rowAlignMode = HorizAlignTextMode.LEFT;
    private SplitTextMode _headerSplitMode = SplitTextMode.AT_SPACE;
    private SplitTextMode _rowSplitMode = SplitTextMode.AT_SPACE;
    private MoreTextMode _headerMoreMode = MoreTextMode.NONE;
    private MoreTextMode _rowMoreMode = MoreTextMode.NONE;
    private String _rowEscCode = null;
    private String _borderEscCode = null;
    private String _headerEscCode = null;
    private String _resetEscCode = AnsiEscapeCode.toEscapeSequence((AnsiEscapeCode[])new AnsiEscapeCode[]{AnsiEscapeCode.RESET});
    private boolean _hasLeftBorder = true;
    private boolean _hasRightBorder = true;
    private boolean _hasDividerLine = true;
    private TextFormatMode _headerFormatMode = TextFormatMode.TEXT;
    private boolean _isEscCodesEnabled = true;
    private TextFormatMode _rowFormatMode = TextFormatMode.TEXT;

    public TableBuilder() {
    }

    public TableBuilder(int n) {
        this._rowWidth = n;
    }

    private String[][] toColumns(String[][] stringArray, VertAlignTextMode vertAlignTextMode) {
        int n = TableBuilder.toMaxLength(stringArray);
        String[][] stringArray2 = new String[stringArray.length][];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = ((VertAlignTextBuilder)new VertAlignTextBuilder().withText(stringArray[i])).withRowHeight(n).withVertAlignTextMode(vertAlignTextMode).withEscapeCodesEnabled(this._isEscCodesEnabled).toStrings();
        }
        return stringArray2;
    }

    static int[] toColumnWidths(int n, ColumnWidthMetrics ... columnWidthMetricsArray) {
        int n2 = -1;
        int n3 = -1;
        block8: for (ColumnWidthMetrics columnWidthMetrics : columnWidthMetricsArray) {
            switch (columnWidthMetrics.getColumnWidthType()) {
                case ABSOLUTE: {
                    if (n2 == -1) {
                        n2 = columnWidthMetrics.getColumnWidth();
                        continue block8;
                    }
                    n2 += columnWidthMetrics.getColumnWidth();
                    continue block8;
                }
                case RELATIVE: {
                    if (n3 == -1) {
                        n3 = columnWidthMetrics.getColumnWidth();
                        continue block8;
                    }
                    n3 += columnWidthMetrics.getColumnWidth();
                    continue block8;
                }
                default: {
                    throw new BugException("Missing case statement for <" + columnWidthMetrics.getColumnWidthType() + "> in implementation!");
                }
            }
        }
        if (n == -1) {
            n = n2;
        }
        if (n2 < n && n3 == -1) {
            throw new IllegalArgumentException("Your provided overall number of char width <" + n2 + "> does not add up to the total width available of <" + n + "> and you did not specify an percent (%) width to fill up the missing gap.");
        }
        if (n2 > n) {
            throw new IllegalArgumentException("The total width available <" + n + "> is exceeded by the provided overall number of char widths <" + n2 + "> requested.");
        }
        int[] nArray = new int[columnWidthMetricsArray.length];
        int n4 = n - n2;
        int n5 = 0;
        ColumnWidthMetrics[] columnWidthMetricsArray2 = columnWidthMetricsArray;
        int n6 = columnWidthMetricsArray2.length;
        for (int i = 0; i < n6; ++i) {
            ColumnWidthMetrics columnWidthMetrics = columnWidthMetricsArray2[i];
            if (columnWidthMetrics.getColumnWidthType() != ColumnWidthType.RELATIVE) continue;
            n5 += columnWidthMetrics.getColumnWidth();
        }
        block10: for (n6 = 0; n6 < columnWidthMetricsArray.length; ++n6) {
            ColumnWidthMetrics columnWidthMetrics = columnWidthMetricsArray[n6];
            switch (columnWidthMetrics.getColumnWidthType()) {
                case ABSOLUTE: {
                    nArray[n6] = columnWidthMetrics.getColumnWidth();
                    continue block10;
                }
                case RELATIVE: {
                    nArray[n6] = (int)((double)n4 / (double)n5 * (double)columnWidthMetrics.getColumnWidth());
                    continue block10;
                }
                default: {
                    throw new BugException("Missing case statement for <" + columnWidthMetrics.getColumnWidthType() + "> in implementation!");
                }
            }
        }
        block11: while (NumericalUtility.sum((int[])nArray) < n) {
            for (n6 = 0; n6 < nArray.length; ++n6) {
                if (columnWidthMetricsArray[n6].getColumnWidthType() != ColumnWidthType.RELATIVE) continue;
                int n7 = n6;
                nArray[n7] = nArray[n7] + 1;
                if (NumericalUtility.sum((int[])nArray) == n) break block11;
            }
        }
        block13: while (NumericalUtility.sum((int[])nArray) > n) {
            n6 = 0;
            while (n6 < nArray.length) {
                int n8 = n6++;
                nArray[n8] = nArray[n8] - 1;
                if (NumericalUtility.sum((int[])nArray) == n) break block13;
            }
        }
        block15: while (NumericalUtility.sum((int[])nArray) < n) {
            n6 = 0;
            while (n6 < nArray.length) {
                int n9 = n6++;
                nArray[n9] = nArray[n9] + 1;
                if (NumericalUtility.sum((int[])nArray) == n) break block15;
            }
        }
        return nArray;
    }

    public TableBuilder addColumn() {
        this._columnRecords.add(new ColumnRecord());
        this._columnWidths = null;
        return this;
    }

    public PrintStream getPrintStream() {
        return this._printStream;
    }

    public String getResetEscapeCode() {
        return this._resetEscCode;
    }

    public int getRowWidth() {
        return this._rowWidth;
    }

    @Override
    public TableStatus getTableStatus() {
        return this._tableStatus;
    }

    public boolean isEscapeCodesEnabled() {
        return this._isEscCodesEnabled;
    }

    public void setPrintStream(PrintStream printStream) {
        this._printStream = printStream;
    }

    public void setResetEscapeCode(String string) {
        this._resetEscCode = string;
    }

    public void setRowWidth(int n) {
        this._rowWidth = n;
        this.updateColumnWidths();
    }

    @Override
    public TableBuilder setTableStatus(TableStatus tableStatus) {
        this._tableStatus = tableStatus;
        return this;
    }

    public int[] toColumnWidths() {
        if (this._columnWidths == null) {
            this.updateColumnWidths();
        }
        return this._columnWidths;
    }

    @Override
    public String toHeader(String ... stringArray) {
        if (this._columnRecords.size() < stringArray.length) {
            int n = stringArray.length - this._columnRecords.size();
            for (int i = 0; i < n; ++i) {
                this.addColumn();
            }
        }
        if (this._columnWidths == null) {
            this.updateColumnWidths();
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.printlnTopBorder(this._columnWidths, TableSection.HEADER, stringBuilder);
        this.printlnLine(this._columnWidths, TableSection.HEADER, stringBuilder, stringArray);
        this._tableStatus = TableStatus.HEADER_CONTINUE;
        return stringBuilder.toString();
    }

    @Override
    public String toHeaderBegin() {
        if (this._columnRecords.size() == 0) {
            throw new IllegalStateException("You must add least a column before printing the header.");
        }
        if (this._columnWidths == null) {
            this.updateColumnWidths();
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.printlnTopBorder(this._columnWidths, TableSection.HEADER, stringBuilder);
        this._tableStatus = TableStatus.HEADER_BEGIN;
        return stringBuilder.toString();
    }

    @Override
    public String toHeaderContinue(String ... stringArray) {
        if (this._columnRecords.size() == 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.addColumn();
            }
        }
        if (this._columnWidths == null) {
            this.updateColumnWidths();
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.printlnLine(this._columnWidths, TableSection.HEADER, stringBuilder, stringArray);
        this._tableStatus = TableStatus.HEADER_CONTINUE;
        return stringBuilder.toString();
    }

    @Override
    public String toHeaderEnd() {
        if (this._columnRecords.size() == 0) {
            throw new IllegalStateException("You must add least a column before printing the header.");
        }
        if (this._columnWidths == null) {
            this.updateColumnWidths();
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.printlnBottomBorder(this._columnWidths, TableSection.HEADER, stringBuilder);
        this._tableStatus = TableStatus.HEADER_END;
        return stringBuilder.toString();
    }

    @Override
    public String toHeaderEnd(TableBuilder tableBuilder) {
        if (this._columnRecords.size() == 0) {
            throw new IllegalStateException("You must add least a column to this table printer before joining the tables.");
        }
        if (this._columnWidths == null) {
            this.updateColumnWidths();
        }
        if (tableBuilder.toColumnWidths().length == 0) {
            throw new IllegalStateException("You must add least a column to the provided table printer before joining the tables.");
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.joinRow(tableBuilder, TableSection.HEADER, stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    public String toRow(String ... stringArray) {
        if (this._columnRecords.size() == 0 && this._columnRecords.size() == 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.addColumn();
            }
        }
        if (this._columnWidths == null) {
            this.updateColumnWidths();
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (this._tableStatus == TableStatus.NONE) {
            this.printlnTopBorder(this._columnWidths, TableSection.BODY, stringBuilder);
        } else if (this._tableStatus == TableStatus.ROW_CONTINUE) {
            this.printlnTopBorder(this._columnWidths, TableSection.BODY, stringBuilder);
        } else if (this._tableStatus == TableStatus.HEADER_CONTINUE) {
            this.printlnTopBorder(this._columnWidths, TableSection.HEADER, stringBuilder);
        }
        this.printlnLine(this._columnWidths, TableSection.BODY, stringBuilder, stringArray);
        this._tableStatus = TableStatus.ROW_CONTINUE;
        return stringBuilder.toString();
    }

    @Override
    public String toRowBegin() {
        if (this._columnRecords.size() == 0) {
            throw new IllegalStateException("You must add least a column before printing the header.");
        }
        if (this._columnWidths == null) {
            this.updateColumnWidths();
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.printlnTopBorder(this._columnWidths, TableSection.BODY, stringBuilder);
        this._tableStatus = TableStatus.ROW_BEGIN;
        return stringBuilder.toString();
    }

    @Override
    public String toRowContinue(String ... stringArray) {
        if (this._columnRecords.size() == 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.addColumn();
            }
        }
        if (this._columnWidths == null) {
            this.updateColumnWidths();
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.printlnLine(this._columnWidths, TableSection.BODY, stringBuilder, stringArray);
        this._tableStatus = TableStatus.ROW_CONTINUE;
        return stringBuilder.toString();
    }

    @Override
    public String toRowEnd(TableBuilder tableBuilder) {
        if (this._columnRecords.size() == 0) {
            throw new IllegalStateException("You must add least a column to this table printer before joining the tables.");
        }
        if (this._columnWidths == null) {
            this.updateColumnWidths();
        }
        if (tableBuilder.toColumnWidths().length == 0) {
            throw new IllegalStateException("You must add least a column to the provided table printer before joining the tables.");
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.joinRow(tableBuilder, TableSection.BODY, stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    public String toTail() {
        StringBuilder stringBuilder = new StringBuilder();
        this.printlnBottomBorder(this._columnWidths, TableSection.TAIL, stringBuilder);
        return stringBuilder.toString();
    }

    public TableBuilder withBorderEscapeCode(String string) {
        this._borderEscCode = string;
        return this;
    }

    public TableBuilder withColumnFormatMetrics(ColumnFormatMetrics columnFormatMetrics) throws IllegalStateException {
        ColumnRecord columnRecord = this.currentColumnRecord();
        columnRecord.fromColumnFormatMetrics(columnFormatMetrics);
        this._columnWidths = null;
        return this;
    }

    public TableBuilder withColumnHorizAlignTextMode(HorizAlignTextMode horizAlignTextMode) {
        ColumnRecord columnRecord = this.currentColumnRecord();
        columnRecord.setHeaderHorizAlignTextMode(horizAlignTextMode);
        columnRecord.setRowHorizAlignTextMode(horizAlignTextMode);
        return this;
    }

    public TableBuilder withColumnMoreTextMode(MoreTextMode moreTextMode) {
        ColumnRecord columnRecord = this.currentColumnRecord();
        columnRecord.setHeaderMoreTextMode(moreTextMode);
        columnRecord.setRowMoreTextMode(moreTextMode);
        return this;
    }

    public TableBuilder withColumnSplitTextMode(SplitTextMode splitTextMode) {
        ColumnRecord columnRecord = this.currentColumnRecord();
        columnRecord.setHeaderSplitTextMode(splitTextMode);
        columnRecord.setRowSplitTextMode(splitTextMode);
        return this;
    }

    public TableBuilder withColumnTextFormatMode(TextFormatMode textFormatMode) {
        ColumnRecord columnRecord = this.currentColumnRecord();
        columnRecord.setHeaderTextFormatMode(textFormatMode);
        columnRecord.setRowTextFormatMode(textFormatMode);
        return this;
    }

    public TableBuilder withColumnWidth(int n) throws IllegalStateException {
        return this.withColumnWidth(n, ColumnWidthType.ABSOLUTE);
    }

    public TableBuilder withColumnWidth(int n, ColumnWidthType columnWidthType) throws IllegalStateException {
        this.currentColumnRecord().setColumnWidth(n);
        this.currentColumnRecord().setColumnWidthType(columnWidthType);
        this._columnWidths = null;
        return this;
    }

    public TableBuilder withColumnWidthMetrics(ColumnWidthMetrics columnWidthMetrics) throws IllegalStateException {
        this.currentColumnRecord().setColumnWidth(columnWidthMetrics.getColumnWidth());
        this.currentColumnRecord().setColumnWidthType(columnWidthMetrics.getColumnWidthType());
        this._columnWidths = null;
        return this;
    }

    public TableBuilder withEscapeCode(String string) {
        this.withBorderEscapeCode(string);
        this.withTextEscapeCode(string);
        return this;
    }

    public void setEscapeCodesEnabled(boolean bl) {
        this._isEscCodesEnabled = bl;
    }

    public TableBuilder withHeaderColumnEscapeCode(String string) {
        this.currentColumnRecord().setHeaderEscapeCode(string);
        return this;
    }

    public TableBuilder withHeaderColumnHorizAlignTextMode(HorizAlignTextMode horizAlignTextMode) {
        this.currentColumnRecord().setHeaderHorizAlignTextMode(horizAlignTextMode);
        return this;
    }

    public TableBuilder withHeaderColumnMoreTextMode(MoreTextMode moreTextMode) {
        this.currentColumnRecord().setHeaderMoreTextMode(moreTextMode);
        return this;
    }

    public TableBuilder withHeaderColumnSplitTextMode(SplitTextMode splitTextMode) {
        this.currentColumnRecord().setHeaderSplitTextMode(splitTextMode);
        return this;
    }

    public TableBuilder withHeaderColumnTextFormatMode(TextFormatMode textFormatMode) {
        this.currentColumnRecord().setHeaderTextFormatMode(textFormatMode);
        return this;
    }

    public TableBuilder withHeaderEscapeCode(String string) {
        if (string != null) {
            if (string.length() > 0 && !string.startsWith("" + AnsiEscapeCode.ESCAPE)) {
                throw new IllegalArgumentException("The provided ANSI Escape-Code does not start with \"" + AnsiEscapeCode.toEscapedSequence((String)("" + AnsiEscapeCode.ESCAPE)) + "\".");
            }
            if (string.length() == 0) {
                throw new IllegalArgumentException("Either use null to reset the ANSI Escape-Code or provide a valid ANSI Escape-Code with a length > 0.");
            }
        }
        this._headerEscCode = string;
        for (ColumnRecord columnRecord : this._columnRecords) {
            columnRecord.setHeaderEscapeCode(string);
        }
        return this;
    }

    public TableBuilder withHeaderHorizAlignTextMode(HorizAlignTextMode horizAlignTextMode) {
        this.currentColumnRecord().setHeaderHorizAlignTextMode(horizAlignTextMode);
        return this;
    }

    public TableBuilder withHeaderMoreTextMode(MoreTextMode moreTextMode) {
        this.currentColumnRecord().setHeaderMoreTextMode(moreTextMode);
        return this;
    }

    public TableBuilder withHeaderSplitTextMode(SplitTextMode splitTextMode) {
        this.currentColumnRecord().setHeaderSplitTextMode(splitTextMode);
        return this;
    }

    public TableBuilder withHeaderTextFormatMode(TextFormatMode textFormatMode) {
        this.currentColumnRecord().setHeaderTextFormatMode(textFormatMode);
        return this;
    }

    public TableBuilder withHorizAlignTextMode(HorizAlignTextMode horizAlignTextMode) {
        this._headerAlignMode = horizAlignTextMode;
        this._rowAlignMode = horizAlignTextMode;
        for (ColumnRecord columnRecord : this._columnRecords) {
            columnRecord.setHeaderHorizAlignTextMode(horizAlignTextMode);
            columnRecord.setRowHorizAlignTextMode(horizAlignTextMode);
        }
        return this;
    }

    public TableBuilder withLeftBorder(boolean bl) {
        this._hasLeftBorder = bl;
        return this;
    }

    public TableBuilder withLineBreak(String string) {
        this._lineBreak = string;
        return this;
    }

    public TableBuilder withMoreTextMode(MoreTextMode moreTextMode) {
        this._headerMoreMode = moreTextMode;
        this._rowMoreMode = moreTextMode;
        for (ColumnRecord columnRecord : this._columnRecords) {
            columnRecord.setHeaderMoreTextMode(moreTextMode);
            columnRecord.setRowMoreTextMode(moreTextMode);
        }
        return this;
    }

    public TableBuilder withResetEscapeCode(String string) {
        this._resetEscCode = string;
        return this;
    }

    public TableBuilder withRightBorder(boolean bl) {
        this._hasRightBorder = bl;
        return this;
    }

    public TableBuilder withDividerLine(boolean bl) {
        this._hasDividerLine = bl;
        return this;
    }

    public TableBuilder withRowColumnEscapeCode(String string) {
        this.currentColumnRecord().setRowEscapeCode(string);
        return this;
    }

    public TableBuilder withRowColumnHorizAlignTextMode(HorizAlignTextMode horizAlignTextMode) {
        this.currentColumnRecord().setRowHorizAlignTextMode(horizAlignTextMode);
        return this;
    }

    public TableBuilder withRowColumnMoreTextMode(MoreTextMode moreTextMode) {
        this.currentColumnRecord().setRowMoreTextMode(moreTextMode);
        return this;
    }

    public TableBuilder withRowColumnSplitTextMode(SplitTextMode splitTextMode) {
        this.currentColumnRecord().setRowSplitTextMode(splitTextMode);
        return this;
    }

    public TableBuilder withRowColumnTextFormatMode(TextFormatMode textFormatMode) {
        this.currentColumnRecord().setRowTextFormatMode(textFormatMode);
        return this;
    }

    public TableBuilder withRowEscapeCode(String string) {
        if (string != null) {
            if (string.length() > 0 && !string.startsWith("" + AnsiEscapeCode.ESCAPE)) {
                throw new IllegalArgumentException("The provided ANSI Escape-Code does not start with \"" + AnsiEscapeCode.toEscapedSequence((String)("" + AnsiEscapeCode.ESCAPE)) + "\".");
            }
            if (string.length() == 0) {
                throw new IllegalArgumentException("Either use null to reset the ANSI Escape-Code or provide a valid ANSI Escape-Code with a length > 0.");
            }
        }
        this._rowEscCode = string;
        for (ColumnRecord columnRecord : this._columnRecords) {
            columnRecord.setRowEscapeCode(string);
        }
        return this;
    }

    public TableBuilder withRowHorizAlignTextMode(HorizAlignTextMode horizAlignTextMode) {
        this.currentColumnRecord().setRowHorizAlignTextMode(horizAlignTextMode);
        return this;
    }

    public TableBuilder withRowMoreTextMode(MoreTextMode moreTextMode) {
        this.currentColumnRecord().setRowMoreTextMode(moreTextMode);
        return this;
    }

    public TableBuilder withRowSplitTextMode(SplitTextMode splitTextMode) {
        this.currentColumnRecord().setRowSplitTextMode(splitTextMode);
        return this;
    }

    public TableBuilder withRowTextFormatMode(TextFormatMode textFormatMode) {
        this.currentColumnRecord().setRowTextFormatMode(textFormatMode);
        return this;
    }

    public TableBuilder withRowWidth(int n) {
        this.setRowWidth(n);
        return this;
    }

    public TableBuilder withSplitTextMode(SplitTextMode splitTextMode) {
        this._headerSplitMode = splitTextMode;
        this._rowSplitMode = splitTextMode;
        for (ColumnRecord columnRecord : this._columnRecords) {
            columnRecord.setHeaderSplitTextMode(splitTextMode);
            columnRecord.setRowSplitTextMode(splitTextMode);
        }
        return this;
    }

    public TableBuilder withTableStyle(TableStyle tableStyle) {
        this._tableStyle = tableStyle;
        return this;
    }

    public TableBuilder withTextColumnEscapeCode(String string) {
        ColumnRecord columnRecord = this.currentColumnRecord();
        columnRecord.setHeaderEscapeCode(string);
        columnRecord.setRowEscapeCode(string);
        return this;
    }

    public TableBuilder withTextEscapeCode(String string) {
        if (string != null) {
            if (string.length() > 0 && !string.startsWith("" + AnsiEscapeCode.ESCAPE)) {
                throw new IllegalArgumentException("The provided ANSI Escape-Code does not start with \"" + AnsiEscapeCode.toEscapedSequence((String)("" + AnsiEscapeCode.ESCAPE)) + "\".");
            }
            if (string.length() == 0) {
                throw new IllegalArgumentException("Either use null to reset the ANSI Escape-Code or provide a valid ANSI Escape-Code with a length > 0.");
            }
        }
        this._headerEscCode = string;
        this._rowEscCode = string;
        for (ColumnRecord columnRecord : this._columnRecords) {
            columnRecord.setHeaderEscapeCode(string);
            columnRecord.setRowEscapeCode(string);
        }
        return this;
    }

    public TableBuilder withTextFormatMode(TextFormatMode textFormatMode) {
        this._headerFormatMode = textFormatMode;
        this._rowFormatMode = textFormatMode;
        for (ColumnRecord columnRecord : this._columnRecords) {
            columnRecord.setHeaderTextFormatMode(textFormatMode);
            columnRecord.setRowTextFormatMode(textFormatMode);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printHeader(String ... stringArray) {
        PrintStream printStream = this.getPrintStream();
        synchronized (printStream) {
            this.getPrintStream().print(this.toHeader(stringArray));
            this.getPrintStream().flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printHeaderBegin() {
        PrintStream printStream = this.getPrintStream();
        synchronized (printStream) {
            this.getPrintStream().print(this.toHeaderBegin());
            this.getPrintStream().flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printHeaderContinue(String ... stringArray) {
        PrintStream printStream = this.getPrintStream();
        synchronized (printStream) {
            this.getPrintStream().print(this.toHeaderContinue(stringArray));
            this.getPrintStream().flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printHeaderEnd() {
        PrintStream printStream = this.getPrintStream();
        synchronized (printStream) {
            this.getPrintStream().print(this.toHeaderEnd());
            this.getPrintStream().flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printHeaderEnd(TableBuilder tableBuilder) {
        PrintStream printStream = this.getPrintStream();
        synchronized (printStream) {
            this.getPrintStream().print(this.toHeaderEnd(tableBuilder));
            this.getPrintStream().flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printRow(String ... stringArray) {
        PrintStream printStream = this.getPrintStream();
        synchronized (printStream) {
            this.getPrintStream().print(this.toRow(stringArray));
            this.getPrintStream().flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printRowBegin() {
        PrintStream printStream = this.getPrintStream();
        synchronized (printStream) {
            this.getPrintStream().print(this.toRowBegin());
            this.getPrintStream().flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printRowContinue(String ... stringArray) {
        PrintStream printStream = this.getPrintStream();
        synchronized (printStream) {
            this.getPrintStream().print(this.toRowContinue(stringArray));
            this.getPrintStream().flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printRowEnd(TableBuilder tableBuilder) {
        PrintStream printStream = this.getPrintStream();
        synchronized (printStream) {
            this.getPrintStream().print(this.toRowEnd(tableBuilder));
            this.getPrintStream().flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printTail() {
        PrintStream printStream = this.getPrintStream();
        synchronized (printStream) {
            this.getPrintStream().print(this.toTail());
            this.getPrintStream().flush();
        }
    }

    public TableBuilder withEscapeCodesEnabled(boolean bl) {
        this.setEscapeCodesEnabled(bl);
        return this;
    }

    public TableBuilder withPrintStream(PrintStream printStream) {
        this.setPrintStream(printStream);
        return this;
    }

    static TableBuilder build() {
        return new TableBuilder();
    }

    private void appendEscapeBorder(StringBuilder stringBuilder) {
        if (this._isEscCodesEnabled && this._borderEscCode != null) {
            stringBuilder.append(this._borderEscCode);
        }
    }

    private void appendEscapeReset(StringBuilder stringBuilder) {
        if (this._isEscCodesEnabled && this._borderEscCode != null) {
            stringBuilder.append(this._resetEscCode);
        }
    }

    private void buildBottomBorder(int[] nArray, TableSection tableSection, StringBuilder stringBuilder) {
        TextBoxGrid textBoxGrid;
        TextBoxGrid textBoxGrid2 = textBoxGrid = tableSection == TableSection.HEADER ? this._tableStyle.getHeader() : this._tableStyle.getTail();
        if (this._hasLeftBorder) {
            stringBuilder.append(textBoxGrid.getBottomLeftEdge());
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(textBoxGrid.getBottomDividerEdge());
            }
            stringBuilder.append(new TextLineBuilder().withColumnWidth(nArray[i]).withLineChar(((Character)textBoxGrid.getBottomLine()).charValue()).toString());
        }
        if (this._hasRightBorder) {
            stringBuilder.append(textBoxGrid.getBottomRightEdge());
        }
    }

    private void buildTopBorder(int[] nArray, TableSection tableSection, StringBuilder stringBuilder) {
        TextBoxGrid textBoxGrid;
        TextBoxGrid textBoxGrid2 = textBoxGrid = tableSection == TableSection.HEADER ? this._tableStyle.getHeader() : this._tableStyle.getBody();
        if (this._hasLeftBorder) {
            if (this._tableStatus == TableStatus.NONE || this._tableStatus == TableStatus.ROW_END) {
                stringBuilder.append(textBoxGrid.getTopLeftEdge());
            } else {
                stringBuilder.append(textBoxGrid.getLeftEdge());
            }
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (i > 0) {
                if (this._tableStatus == TableStatus.NONE || this._tableStatus == TableStatus.ROW_END) {
                    stringBuilder.append(textBoxGrid.getTopDividerEdge());
                } else {
                    stringBuilder.append(textBoxGrid.getDividerEdge());
                }
            }
            stringBuilder.append(new TextLineBuilder().withColumnWidth(nArray[i]).withLineChar(((Character)textBoxGrid.getTopLine()).charValue()).toString());
        }
        if (this._hasRightBorder) {
            if (this._tableStatus == TableStatus.NONE || this._tableStatus == TableStatus.ROW_END) {
                stringBuilder.append(textBoxGrid.getTopRightEdge());
            } else {
                stringBuilder.append(textBoxGrid.getRightEdge());
            }
        }
    }

    private ColumnRecord currentColumnRecord() {
        int n = this._columnRecords.size();
        if (n == 0) {
            this.addColumn();
            ++n;
        }
        ColumnRecord columnRecord = this._columnRecords.get(n - 1);
        return columnRecord;
    }

    private void joinRow(TableBuilder tableBuilder, TableSection tableSection, StringBuilder stringBuilder) {
        int n;
        StringBuilder stringBuilder2;
        StringBuilder stringBuilder3;
        this._tableStatus = TableStatus.ROW_END;
        TextBoxGrid textBoxGrid = tableSection == TableSection.HEADER ? this._tableStyle.getHeader() : this._tableStyle.getBody();
        StringBuilder stringBuilder4 = new StringBuilder();
        this.buildTopBorder(this.toColumnWidths(), tableSection, stringBuilder4);
        StringBuilder stringBuilder5 = new StringBuilder();
        this.buildTopBorder(tableBuilder.toColumnWidths(), tableSection, stringBuilder5);
        if (stringBuilder5.length() < stringBuilder4.length()) {
            stringBuilder3 = stringBuilder4;
            stringBuilder2 = stringBuilder5;
        } else {
            stringBuilder2 = stringBuilder4;
            stringBuilder3 = stringBuilder5;
        }
        if (this._hasLeftBorder) {
            stringBuilder3.replace(0, 1, "" + textBoxGrid.getLeftEdge());
        }
        for (n = 1; n < stringBuilder2.length() - 1; ++n) {
            if (stringBuilder2.charAt(n) != stringBuilder3.charAt(n)) {
                if (stringBuilder5.charAt(n) == ((Character)textBoxGrid.getTopLine()).charValue()) {
                    stringBuilder3.replace(n, n + 1, "" + stringBuilder4.charAt(n));
                    continue;
                }
                if (stringBuilder4.charAt(n) != ((Character)textBoxGrid.getTopLine()).charValue()) continue;
                stringBuilder3.replace(n, n + 1, "" + textBoxGrid.getBottomDividerEdge());
                continue;
            }
            if (stringBuilder4.charAt(n) == ((Character)textBoxGrid.getTopLine()).charValue()) continue;
            stringBuilder3.replace(n, n + 1, "" + textBoxGrid.getDividerEdge());
        }
        if (stringBuilder2.length() != stringBuilder3.length()) {
            if (stringBuilder2.charAt(stringBuilder2.length() - 1) != stringBuilder3.charAt(stringBuilder2.length() - 1)) {
                if (stringBuilder2 == stringBuilder4) {
                    if (stringBuilder3.charAt(stringBuilder2.length() - 1) == ((Character)textBoxGrid.getTopDividerEdge()).charValue()) {
                        stringBuilder3.replace(stringBuilder2.length() - 1, stringBuilder2.length(), "" + textBoxGrid.getDividerEdge());
                    } else {
                        stringBuilder3.replace(stringBuilder2.length() - 1, stringBuilder2.length(), "" + textBoxGrid.getTopDividerEdge());
                    }
                    if (this._hasRightBorder) {
                        stringBuilder3.replace(stringBuilder3.length() - 1, stringBuilder3.length(), "" + textBoxGrid.getBottomRightEdge());
                    }
                } else if (stringBuilder3.charAt(stringBuilder2.length() - 1) == ((Character)textBoxGrid.getTopDividerEdge()).charValue()) {
                    stringBuilder3.replace(stringBuilder2.length() - 1, stringBuilder2.length(), "" + textBoxGrid.getDividerEdge());
                } else {
                    stringBuilder3.replace(stringBuilder2.length() - 1, stringBuilder2.length(), "" + textBoxGrid.getBottomDividerEdge());
                }
            }
            if (stringBuilder3 == stringBuilder5) {
                for (n = stringBuilder2.length(); n < stringBuilder3.length() - 1; ++n) {
                    if (stringBuilder3.charAt(n) != ((Character)textBoxGrid.getTopDividerEdge()).charValue()) continue;
                    stringBuilder3.replace(n, n + 1, "" + textBoxGrid.getBottomDividerEdge());
                }
            }
        } else if (this._hasRightBorder) {
            stringBuilder3.replace(stringBuilder3.length() - 1, stringBuilder3.length(), "" + textBoxGrid.getRightEdge());
        }
        this.appendEscapeBorder(stringBuilder);
        stringBuilder.append(stringBuilder3.toString());
        this.appendEscapeReset(stringBuilder);
        stringBuilder.append(this._lineBreak);
    }

    private void printBottomBorder(int[] nArray, TableSection tableSection, StringBuilder stringBuilder) {
        this.appendEscapeBorder(stringBuilder);
        this.buildBottomBorder(nArray, tableSection, stringBuilder);
        this.appendEscapeReset(stringBuilder);
    }

    private void printlnBottomBorder(int[] nArray, TableSection tableSection, StringBuilder stringBuilder) {
        this.printBottomBorder(nArray, tableSection, stringBuilder);
        stringBuilder.append(this._lineBreak);
    }

    private void printlnLine(int[] nArray, TableSection tableSection, StringBuilder stringBuilder, String ... stringArray) {
        int n;
        int n2;
        if (this._columnRecords.size() != stringArray.length) {
            throw new IllegalStateException("You have passed <" + stringArray.length + "> column text arguments, you have added <" + this._columnRecords.size() + "> columns, though you must pass as many column text arguments as you have added columns. Hint: Maybe you modified a column's layout without adding a column beforehand; in such a case a column is added automatically which results in an unintended number of columns.");
        }
        TextBoxGrid textBoxGrid = tableSection == TableSection.HEADER ? this._tableStyle.getHeader() : this._tableStyle.getBody();
        String[][] stringArray2 = new String[stringArray.length][];
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            stringArray[n2] = MoreTextBuilder.asMoreText(stringArray[n2], nArray[n2], "" + MoreText.MORE_TEXT_BEFORE.getChar(), this._columnRecords.get(n2).getMoreTextMode(tableSection), this._isEscCodesEnabled);
            stringArray2[n2] = TextBlockBuilder.asTextBlock(stringArray[n2], nArray[n2], this._columnRecords.get(n2).getHorizAlignTextMode(tableSection), this._columnRecords.get(n2).getSplitTextMode(tableSection), ' ', this._isEscCodesEnabled);
            if (stringArray2[n2] == null) {
                stringArray2[n2] = new String[]{""};
            }
            for (n = 0; n < stringArray2[n2].length; ++n) {
                stringArray2[n2][n] = HorizAlignTextBuilder.asAligned(stringArray2[n2][n], nArray[n2], ' ', this._columnRecords.get(n2).getHorizAlignTextMode(tableSection), this._isEscCodesEnabled);
            }
        }
        stringArray2 = this.toColumns(stringArray2, VertAlignTextMode.TOP);
        for (n2 = 0; n2 < stringArray2.length; ++n2) {
            stringArray2[n2] = this.toEscapeColumn(this._columnRecords.get(n2), tableSection, stringArray2[n2], stringArray[n2]);
        }
        for (n2 = 0; n2 < stringArray2[0].length; ++n2) {
            if (this._hasLeftBorder) {
                this.appendEscapeBorder(stringBuilder);
                stringBuilder.append(textBoxGrid.getLeftLine());
            }
            this.appendEscapeReset(stringBuilder);
            for (n = 0; n < stringArray2.length; ++n) {
                if (n > 0) {
                    if (this._hasDividerLine) {
                        this.appendEscapeBorder(stringBuilder);
                        stringBuilder.append(textBoxGrid.getDividerLine());
                    }
                    this.appendEscapeReset(stringBuilder);
                }
                stringBuilder.append(stringArray2[n][n2]);
            }
            if (this._hasRightBorder) {
                this.appendEscapeBorder(stringBuilder);
                stringBuilder.append(textBoxGrid.getRightLine());
            }
            this.appendEscapeReset(stringBuilder);
            stringBuilder.append(this._lineBreak);
        }
    }

    private void printlnTopBorder(int[] nArray, TableSection tableSection, StringBuilder stringBuilder) {
        this.printTopBorder(nArray, tableSection, stringBuilder);
        stringBuilder.append(this._lineBreak);
    }

    private void printTopBorder(int[] nArray, TableSection tableSection, StringBuilder stringBuilder) {
        this.appendEscapeBorder(stringBuilder);
        this.buildTopBorder(nArray, tableSection, stringBuilder);
        this.appendEscapeReset(stringBuilder);
    }

    private String[] toEscapeColumn(ColumnRecord columnRecord, TableSection tableSection, String[] stringArray, String string) {
        String string2;
        if (this._isEscCodesEnabled && (string2 = columnRecord.toEscapeCode(tableSection, string)) != null) {
            block0: for (int i = 0; i < stringArray.length; ++i) {
                if (columnRecord.getTextFormatMode(tableSection) == TextFormatMode.TEXT) {
                    int n;
                    if (stringArray[i].length() > 0) {
                        if (stringArray[i].charAt(0) != ' ') {
                            stringArray[i] = string2 + stringArray[i];
                        } else {
                            for (n = 0; n < stringArray[i].length(); ++n) {
                                if (stringArray[i].charAt(n) == ' ') continue;
                                stringArray[i] = stringArray[i].substring(0, n) + string2 + stringArray[i].substring(n);
                                break;
                            }
                        }
                    }
                    if (stringArray[i].charAt(stringArray[i].length() - 1) != ' ') {
                        stringArray[i] = stringArray[i] + this._resetEscCode;
                        continue;
                    }
                    for (n = stringArray[i].length() - 1; n >= 0; --n) {
                        if (stringArray[i].charAt(n) == ' ') continue;
                        stringArray[i] = stringArray[i].substring(0, n + 1) + this._resetEscCode + stringArray[i].substring(n + 1);
                        continue block0;
                    }
                    continue;
                }
                if (columnRecord.getTextFormatMode(tableSection) != TextFormatMode.CELL) continue;
                stringArray[i] = string2 + stringArray[i] + this._resetEscCode;
            }
        }
        return stringArray;
    }

    @SafeVarargs
    private static <T> int toMaxLength(T[] ... TArray) {
        int n = -1;
        for (T[] TArray2 : TArray) {
            if (TArray2 == null || TArray2.length <= n) continue;
            n = TArray2.length;
        }
        return n;
    }

    private void updateColumnWidths() {
        int n;
        if (this._columnRecords.isEmpty()) {
            return;
        }
        if (this._rowWidth <= 0) {
            n = -1;
        } else {
            n = this._rowWidth - (this._columnRecords.size() + 1);
            if (!this._hasLeftBorder) {
                ++n;
            }
            if (!this._hasRightBorder) {
                ++n;
            }
            if (!this._hasDividerLine) {
                n += this._columnRecords.size() - 1;
            }
        }
        this._columnWidths = TableBuilder.toColumnWidths(n, this._columnRecords.toArray(new ColumnRecord[this._columnRecords.size()]));
    }

    private class ColumnRecord
    extends ColumnFormatMetricsImpl {
        public ColumnRecord() {
            super(1, ColumnWidthType.RELATIVE);
            this.setHeaderHorizAlignTextMode(TableBuilder.this._headerAlignMode);
            this.setRowHorizAlignTextMode(TableBuilder.this._rowAlignMode);
            this.setHeaderSplitTextMode(TableBuilder.this._headerSplitMode);
            this.setRowSplitTextMode(TableBuilder.this._rowSplitMode);
            this.setHeaderEscapeCode(TableBuilder.this._headerEscCode);
            this.setRowEscapeCode(TableBuilder.this._rowEscCode);
            this.setHeaderTextFormatMode(TableBuilder.this._headerFormatMode);
            this.setRowTextFormatMode(TableBuilder.this._rowFormatMode);
            this.setHeaderMoreTextMode(TableBuilder.this._headerMoreMode);
            this.setRowMoreTextMode(TableBuilder.this._rowMoreMode);
        }

        private HorizAlignTextMode getHorizAlignTextMode(TableSection tableSection) {
            if (tableSection == TableSection.HEADER) {
                return this.getHeaderHorizAlignTextMode();
            }
            if (tableSection == TableSection.BODY) {
                return this.getRowHorizAlignTextMode();
            }
            throw new RuntimeException("Unknown table section <" + tableSection + ">, allowed values are <" + TableSection.HEADER + "> and <" + TableSection.BODY + ">.");
        }

        private MoreTextMode getMoreTextMode(TableSection tableSection) {
            if (tableSection == TableSection.HEADER) {
                return this.getHeaderMoreTextMode();
            }
            if (tableSection == TableSection.BODY) {
                return this.getRowMoreTextMode();
            }
            throw new RuntimeException("Unknown table section <" + tableSection + ">, allowed values are <" + TableSection.HEADER + "> and <" + TableSection.BODY + ">.");
        }

        private SplitTextMode getSplitTextMode(TableSection tableSection) {
            if (tableSection == TableSection.HEADER) {
                return this.getHeaderSplitTextMode();
            }
            if (tableSection == TableSection.BODY) {
                return this.getRowSplitTextMode();
            }
            throw new RuntimeException("Unknown table section <" + tableSection + ">, allowed values are <" + TableSection.HEADER + "> and <" + TableSection.BODY + ">.");
        }

        private TextFormatMode getTextFormatMode(TableSection tableSection) {
            if (tableSection == TableSection.HEADER) {
                return this.getHeaderTextFormatMode();
            }
            if (tableSection == TableSection.BODY) {
                return this.getRowTextFormatMode();
            }
            throw new RuntimeException("Unknown table section <" + tableSection + ">, allowed values are <" + TableSection.HEADER + "> and <" + TableSection.BODY + ">.");
        }

        private String toEscapeCode(TableSection tableSection, String string) {
            if (tableSection == TableSection.HEADER) {
                return this.toHeaderEscapeCode(string);
            }
            if (tableSection == TableSection.BODY) {
                return this.toRowEscapeCode(string);
            }
            throw new RuntimeException("Unknown table section <" + tableSection + ">, allowed values are <" + TableSection.HEADER + "> and <" + TableSection.BODY + ">.");
        }
    }

    private static enum TableSection {
        HEADER,
        BODY,
        TAIL;

    }
}

