/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.textual;

import org.refcodes.mixin.FamilyAccessor;
import org.refcodes.mixin.NameAccessor;
import org.refcodes.mixin.SizeAccessor;
import org.refcodes.mixin.StyleAccessor;
import org.refcodes.textual.FontFamily;
import org.refcodes.textual.FontStyle;

public class Font
implements FamilyAccessor.FamilyProperty<FontFamily>,
FamilyAccessor.FamilyBuilder<FontFamily, Font>,
StyleAccessor.StyleProperty<FontStyle>,
StyleAccessor.StyleBuilder<FontStyle, Font>,
SizeAccessor.SizeProperty,
SizeAccessor.SizeBuilder<Font>,
NameAccessor.NameProperty,
NameAccessor.NameBuilder<Font> {
    private FontFamily _family = FontFamily.SANS_SERIF;
    private int _size = 16;
    private FontStyle _style = FontStyle.PLAIN;
    private String _name = this._family.getName();

    public Font() {
    }

    public Font(java.awt.Font font) {
        this.setSize(font.getSize());
        this.setStyle(FontStyle.fromFontStyleCode(font.getStyle()));
        this.setFamily(FontFamily.fromName(font.getFamily()));
    }

    public Font(FontFamily fontFamily, FontStyle fontStyle, int n) {
        this.setFamily(fontFamily);
        this._style = fontStyle;
        this._size = n;
    }

    public Font(FontFamily fontFamily, FontStyle fontStyle) {
        this(fontFamily, fontStyle, -1);
    }

    public Font(String string, FontStyle fontStyle, int n) {
        this.setName(string);
        this._style = fontStyle;
        this._size = n;
    }

    public Font(String string, FontStyle fontStyle) {
        this(string, fontStyle, -1);
    }

    public java.awt.Font toAwtFont() {
        return new java.awt.Font(this.getName(), (int)this.getStyle().getCode(), this.getSize());
    }

    public FontFamily getFamily() {
        return this._family;
    }

    public void setFamily(FontFamily fontFamily) {
        this._family = fontFamily;
        this._name = fontFamily.getName();
    }

    public Font withFamily(FontFamily fontFamily) {
        this.setFamily(fontFamily);
        return this;
    }

    public FontStyle getStyle() {
        return this._style;
    }

    public void setStyle(FontStyle fontStyle) {
        this._style = fontStyle;
    }

    public Font withStyle(FontStyle fontStyle) {
        this.setStyle(fontStyle);
        return this;
    }

    public int getSize() {
        return this._size;
    }

    public void setSize(int n) {
        this._size = n;
    }

    public Font withSize(int n) {
        this.setSize(n);
        return this;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this._family.getName() + ", " + this._style + ", " + this._size + ")@" + this.hashCode();
    }

    public String getName() {
        return this._name;
    }

    public void setName(String string) {
        this._name = string;
        this._family = FontFamily.fromName(string);
    }

    public Font withName(String string) {
        this.setName(string);
        return this;
    }
}

