/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.textual;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.refcodes.struct.Property;
import org.refcodes.struct.PropertyImpl;
import org.refcodes.textual.AbstractText;
import org.refcodes.textual.EscapeTextMode;

public class EscapeTextBuilder
extends AbstractText<EscapeTextBuilder> {
    private List<Property> _properties;
    private EscapeTextMode _escapeTextMode = EscapeTextMode.ESCAPE;

    public EscapeTextMode getEscapeTextMode() {
        return this._escapeTextMode;
    }

    public void setEscapeTextMode(EscapeTextMode escapeTextMode) {
        this._escapeTextMode = escapeTextMode;
    }

    public Property[] getEscapeProperties() {
        return this._properties.toArray(new Property[this._properties.size()]);
    }

    public void setEscapeProperties(Property ... propertyArray) {
        this._properties = new ArrayList<Property>();
        Collections.addAll(this._properties, propertyArray);
    }

    public EscapeTextBuilder addEscapeProperty(Property property) {
        if (this._properties == null) {
            this._properties = new ArrayList<Property>();
        }
        this._properties.add(property);
        return this;
    }

    public EscapeTextBuilder addEscapeProperty(String string, String string2) {
        return this.addEscapeProperty((Property)new PropertyImpl(string, string2));
    }

    @Override
    public String[] toStrings() throws IllegalStateException {
        return this.toEscaped(this.getText(), this._properties, this._escapeTextMode);
    }

    @Override
    public String[] toStrings(String ... stringArray) {
        return this.toEscaped(stringArray, this._properties, this._escapeTextMode);
    }

    public EscapeTextBuilder withEscapeTextMode(EscapeTextMode escapeTextMode) {
        this.setEscapeTextMode(escapeTextMode);
        return this;
    }

    public EscapeTextBuilder withEscapeProperties(Property ... propertyArray) {
        this.setEscapeProperties(propertyArray);
        return this;
    }

    protected String[] toEscaped(String[] stringArray, List<Property> list, EscapeTextMode escapeTextMode) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = this.toEscaped(stringArray[i], list, escapeTextMode);
        }
        return stringArray2;
    }

    protected String toEscaped(String string, List<Property> list, EscapeTextMode escapeTextMode) {
        switch (escapeTextMode) {
            case ESCAPE: {
                return EscapeTextBuilder.toEscaped(string, EscapeTextBuilder.toEscapeMatrix(list));
            }
            case UNESCAPE: {
                return EscapeTextBuilder.toUnEscaped(string, EscapeTextBuilder.toEscapeMatrix(list));
            }
        }
        throw new IllegalArgumentException("You must pass a valid escape text mode, though you actually passed <" + escapeTextMode + ">!");
    }

    public static String toEscaped(String string, String[][] stringArray) {
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                string = string.replaceAll(EscapeTextBuilder.toRegExEscaped(stringArray[i][0]), stringArray[i][1]);
            }
            return string;
        }
        return EscapeTextBuilder.asEscaped(string);
    }

    public static String toUnEscaped(String string, String[][] stringArray) {
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                string = string.replaceAll(EscapeTextBuilder.toRegExEscaped(stringArray[i][1]), stringArray[i][0]);
            }
            return string;
        }
        return EscapeTextBuilder.asUnEscaped(string);
    }

    public static String asEscaped(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        block13: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c > '\u0fff') {
                stringBuffer.append("\\u" + Integer.toHexString(c).toUpperCase());
                continue;
            }
            if (c > '\u00ff') {
                stringBuffer.append("\\u0" + Integer.toHexString(c).toUpperCase());
                continue;
            }
            if (c > '\u007f') {
                stringBuffer.append("\\u00" + Integer.toHexString(c).toUpperCase());
                continue;
            }
            if (c < ' ') {
                switch (c) {
                    case '\b': {
                        stringBuffer.append('\\');
                        stringBuffer.append('b');
                        break;
                    }
                    case '\n': {
                        stringBuffer.append('\\');
                        stringBuffer.append('n');
                        break;
                    }
                    case '\t': {
                        stringBuffer.append('\\');
                        stringBuffer.append('t');
                        break;
                    }
                    case '\f': {
                        stringBuffer.append('\\');
                        stringBuffer.append('f');
                        break;
                    }
                    case '\r': {
                        stringBuffer.append('\\');
                        stringBuffer.append('r');
                        break;
                    }
                    default: {
                        if (c > '\u000f') {
                            stringBuffer.append("\\u00" + Integer.toHexString(c).toUpperCase());
                            break;
                        }
                        stringBuffer.append("\\u000" + Integer.toHexString(c).toUpperCase());
                        break;
                    }
                }
                continue;
            }
            switch (c) {
                case '\'': {
                    stringBuffer.append('\'');
                    continue block13;
                }
                case '\"': {
                    stringBuffer.append('\\');
                    stringBuffer.append('\"');
                    continue block13;
                }
                case '\\': {
                    stringBuffer.append('\\');
                    stringBuffer.append('\\');
                    continue block13;
                }
                case '/': {
                    stringBuffer.append('/');
                    continue block13;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static String asUnEscaped(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        StringBuffer stringBuffer2 = new StringBuffer();
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (bl2) {
                stringBuffer2.append(c);
                if (stringBuffer2.length() != 4) continue;
                try {
                    int n2 = Integer.parseInt(stringBuffer2.toString(), 16);
                    stringBuffer.append((char)n2);
                    stringBuffer2.setLength(0);
                    bl2 = false;
                    bl = false;
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("Unable to parse unicode: " + stringBuffer2, numberFormatException);
                }
            }
            if (bl) {
                bl = false;
                switch (c) {
                    case '\\': {
                        stringBuffer.append('\\');
                        break;
                    }
                    case '\'': {
                        stringBuffer.append('\'');
                        break;
                    }
                    case '\"': {
                        stringBuffer.append('\"');
                        break;
                    }
                    case 'r': {
                        stringBuffer.append('\r');
                        break;
                    }
                    case 'f': {
                        stringBuffer.append('\f');
                        break;
                    }
                    case 't': {
                        stringBuffer.append('\t');
                        break;
                    }
                    case 'n': {
                        stringBuffer.append('\n');
                        break;
                    }
                    case 'b': {
                        stringBuffer.append('\b');
                        break;
                    }
                    case 'u': {
                        bl2 = true;
                        break;
                    }
                    default: {
                        stringBuffer.append(c);
                        break;
                    }
                }
                continue;
            }
            if (c == '\\') {
                bl = true;
                continue;
            }
            stringBuffer.append(c);
        }
        if (bl) {
            stringBuffer.append('\\');
        }
        return stringBuffer.toString();
    }

    protected static String toEscapedRegexp(char c) {
        return ("" + c).replaceAll("\\.", "\\\\.").replaceAll("\\|", "\\\\|");
    }

    protected static String toRegExEscaped(String string) {
        string = string.replaceAll("\\+", "\\\\+").replaceAll("\\*", "\\\\*").replaceAll("\\.", "\\\\.");
        return string;
    }

    private static String[][] toEscapeMatrix(List<Property> list) {
        if (list != null) {
            String[][] stringArray = new String[list.size()][2];
            for (int i = 0; i < list.size(); ++i) {
                stringArray[i][0] = (String)list.get(i).getKey();
                stringArray[i][1] = (String)list.get(i).getValue();
            }
            return stringArray;
        }
        return null;
    }
}

