/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.security;

import java.io.IOException;
import java.io.InputStream;
import org.refcodes.mixin.Disposable;
import org.refcodes.security.Decrypter;
import org.refcodes.security.DecryptionException;

public class DecryptionInputStream
extends InputStream
implements Disposable {
    private InputStream _inputStream;
    private Decrypter<byte[], byte[], DecryptionException> _decrypter;

    public DecryptionInputStream(InputStream inputStream, Decrypter<byte[], byte[], DecryptionException> decrypter) {
        this._inputStream = inputStream;
        this._decrypter = decrypter;
    }

    @Override
    public int available() throws IOException {
        return this._inputStream.available();
    }

    public boolean equals(Object object) {
        return this._inputStream.equals(object);
    }

    public int hashCode() {
        return this._inputStream.hashCode();
    }

    @Override
    public void mark(int n) {
        this._inputStream.mark(n);
    }

    @Override
    public boolean markSupported() {
        return this._inputStream.markSupported();
    }

    @Override
    public int read() throws IOException {
        try {
            int n = this._inputStream.read();
            if (n == -1) {
                return -1;
            }
            return Byte.toUnsignedInt(this._decrypter.toDecrypted(new byte[]{(byte)n})[0]);
        }
        catch (DecryptionException decryptionException) {
            throw new IllegalStateException(decryptionException.getMessage(), (Throwable)((Object)decryptionException));
        }
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        try {
            int n = this._inputStream.read(byArray);
            if (n == -1) {
                return -1;
            }
            this._decrypter.decrypt(byArray);
            return n;
        }
        catch (DecryptionException decryptionException) {
            throw new IllegalStateException(decryptionException.getMessage(), (Throwable)((Object)decryptionException));
        }
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        try {
            int n3 = this._inputStream.read(byArray, n, n2);
            this._decrypter.decrypt(byArray, n, n2);
            return n3;
        }
        catch (DecryptionException decryptionException) {
            throw new IllegalStateException(decryptionException.getMessage(), (Throwable)((Object)decryptionException));
        }
    }

    @Override
    public void reset() throws IOException {
        this._inputStream.reset();
    }

    @Override
    public long skip(long l) throws IOException {
        return this._inputStream.skip(l);
    }

    @Override
    public void close() throws IOException {
        InputStream inputStream;
        Decrypter<byte[], byte[], DecryptionException> decrypter = this._decrypter;
        if (decrypter != null) {
            try {
                decrypter.dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._decrypter = null;
        }
        if ((inputStream = this._inputStream) != null) {
            inputStream.close();
            this._inputStream = null;
        }
    }

    public void dispose() {
        InputStream inputStream;
        Decrypter<byte[], byte[], DecryptionException> decrypter = this._decrypter;
        if (decrypter != null) {
            try {
                decrypter.dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._decrypter = null;
        }
        if ((inputStream = this._inputStream) != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this._inputStream = null;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [inputStream=" + this._inputStream + ", decrypter=" + this._decrypter + "]";
    }
}

