/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.runtime;

import org.refcodes.data.CharSet;
import org.refcodes.data.Delimiter;
import org.refcodes.mixin.KeyAccessor;

public class Configuration
implements KeyAccessor.KeyProperty<String>,
KeyAccessor.KeyBuilder<String, Configuration> {
    private String _key = null;

    public String getKey() {
        return this._key;
    }

    public void setKey(String aKey) {
        this._key = aKey;
    }

    public Configuration withKey(String aKey) {
        this.setKey(aKey);
        return this;
    }

    public String toPath() {
        return this.toPath(this.getKey());
    }

    public String toPath(String aKey) {
        if (aKey == null || aKey.isEmpty()) {
            return aKey;
        }
        String theKey = Configuration.asNormalized(aKey, Delimiter.PATH.getChar());
        return theKey != null ? Delimiter.PATH.getChar() + theKey.toLowerCase() : theKey;
    }

    public String toSystemProperty() {
        return this.toSystemProperty(this.getKey());
    }

    public String toEnvironmentVariable() {
        return this.toEnvironmentVariable(this.getKey());
    }

    public String toSystemProperty(String aKey) {
        if (aKey == null || aKey.isEmpty()) {
            return aKey;
        }
        String theKey = Configuration.asNormalized(aKey, Delimiter.NAMESPACE.getChar());
        return theKey != null ? theKey.toLowerCase() : theKey;
    }

    public String toEnvironmentVariable(String aKey) {
        if (aKey == null || aKey.isEmpty()) {
            return aKey;
        }
        String theKey = Configuration.asNormalized(aKey, Delimiter.SNAKE_CASE.getChar());
        return theKey != null ? theKey.toUpperCase() : theKey;
    }

    public String getSystemProperty(String aKey) {
        String theKey = this.toSystemProperty(aKey);
        return System.getProperty(theKey != null ? theKey : aKey);
    }

    public String getEnvironmentVariable(String aKey) {
        String theKey = this.toEnvironmentVariable(aKey);
        return System.getenv(theKey != null ? theKey : aKey);
    }

    protected static String asNormalized(String aText, char aSeparator) {
        if (aText == null || aText.isEmpty()) {
            return null;
        }
        String theRegexSeparator = CharSet.REGEX_SPECIAL_CHARS.hasChar(aSeparator) ? "\\" + aSeparator : "" + aSeparator;
        String theRegexDoubleSeparator = theRegexSeparator + theRegexSeparator;
        String theDoubleSeparator = "" + aSeparator + aSeparator;
        String theSeparator = "" + aSeparator;
        if (aText == null || aText.isEmpty()) {
            return aText;
        }
        StringBuilder theBuffer = new StringBuilder();
        while (aText.length() > 0 && !Character.isAlphabetic(aText.charAt(0)) && !Character.isDigit(aText.charAt(0))) {
            aText = aText.substring(1);
        }
        while (aText.length() > 0 && !Character.isAlphabetic(aText.charAt(aText.length() - 1)) && !Character.isDigit(aText.charAt(aText.length() - 1))) {
            aText = aText.substring(0, aText.length() - 1);
        }
        if (aText == null || aText.isEmpty()) {
            return null;
        }
        theBuffer.append(aText.charAt(0));
        for (int i = 1; i < aText.length(); ++i) {
            if (Character.isLowerCase(aText.charAt(i - 1)) && Character.isUpperCase(aText.charAt(i))) {
                theBuffer.append(aSeparator);
            }
            if (!Character.isAlphabetic(aText.charAt(i)) && !Character.isDigit(aText.charAt(i))) {
                theBuffer.append(aSeparator);
                continue;
            }
            if (Character.isDigit(aText.charAt(i)) && theBuffer.length() != 0 && Character.isAlphabetic(theBuffer.charAt(theBuffer.length() - 1))) {
                theBuffer.append(aSeparator);
            } else if (Character.isAlphabetic(aText.charAt(i)) && theBuffer.length() != 0 && Character.isDigit(theBuffer.charAt(theBuffer.length() - 1))) {
                theBuffer.append(aSeparator);
            }
            theBuffer.append(aText.charAt(i));
        }
        String theNormalited = theBuffer.toString();
        while (theNormalited.contains(theDoubleSeparator)) {
            theNormalited = theNormalited.replaceAll(theRegexDoubleSeparator, theSeparator);
        }
        return theNormalited.toLowerCase();
    }
}

