/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.runtime;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.refcodes.data.ArgsPrefix;
import org.refcodes.data.Delimiter;
import org.refcodes.data.Literal;

public final class Arguments {
    private Arguments() {
    }

    public static Map<String, String> toProperties(String[] aArgs) {
        return Arguments.toProperties(aArgs, ArgsPrefix.toPrefixes(), Delimiter.INDEX.getChar());
    }

    public static Map<String, String> toProperties(String[] aArgs, Collection<String> aPrefixes, char aDelimiter) {
        return Arguments.toProperties(aArgs, aPrefixes.toArray(new String[aPrefixes.size()]), aDelimiter);
    }

    public static Map<String, String> toProperties(String[] aArgs, String[] aPrefixes, char aDelimiter) {
        HashMap<String, String> theProperties = new HashMap<String, String>();
        String eOption = null;
        for (int i = 0; i < aArgs.length; ++i) {
            String eArg = aArgs[i];
            boolean isLast = i == aArgs.length - 1;
            String eNextOption = Arguments.toOption(eArg, aPrefixes);
            if (eOption != null) {
                if (eNextOption == null) {
                    Arguments.putProperty(theProperties, eOption, eArg, aDelimiter);
                    eOption = null;
                    continue;
                }
                Arguments.putProperty(theProperties, eOption, Literal.TRUE.getValue(), aDelimiter);
                eOption = eNextOption;
                if (!isLast) continue;
                Arguments.putProperty(theProperties, eOption, Literal.TRUE.getValue(), aDelimiter);
                continue;
            }
            if (eNextOption != null) {
                eOption = eNextOption;
                if (!isLast) continue;
                Arguments.putProperty(theProperties, eOption, Literal.TRUE.getValue(), aDelimiter);
                continue;
            }
            Arguments.putProperty(theProperties, null, eArg, aDelimiter);
        }
        return theProperties;
    }

    private static String toNextKey(Map<String, String> aProperties, String aKey, char aDelimiter) {
        if (aProperties.containsKey(aKey) || aProperties.containsKey(aKey + aDelimiter + "0")) {
            int index = 0;
            String eNextKey = aKey + aDelimiter + index;
            while (aProperties.containsKey(eNextKey)) {
                eNextKey = aKey + aDelimiter + ++index;
            }
            return eNextKey;
        }
        return null;
    }

    private static String toOption(String aArg, String ... aPrefixes) {
        Arrays.sort(aPrefixes, Collections.reverseOrder());
        for (String ePrefix : aPrefixes) {
            if (!aArg.startsWith(ePrefix)) continue;
            return aArg.substring(ePrefix.length());
        }
        return null;
    }

    private static void putProperty(Map<String, String> aProperties, String aKey, String aValue, char aDelimiter) {
        if (aProperties.containsKey(aKey)) {
            String eNextKey = Arguments.toNextKey(aProperties, aKey, aDelimiter);
            aProperties.put(eNextKey, aProperties.remove(aKey));
            eNextKey = Arguments.toNextKey(aProperties, aKey, aDelimiter);
            aProperties.put(eNextKey, aValue);
        } else if (aProperties.containsKey(aKey + aDelimiter + "0")) {
            String eNextKey = Arguments.toNextKey(aProperties, aKey, aDelimiter);
            aProperties.put(eNextKey, aValue);
        } else {
            aProperties.put(aKey, aValue);
        }
    }
}

