/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.rest;

import java.util.regex.Pattern;
import org.refcodes.exception.BugException;
import org.refcodes.observer.Observable;
import org.refcodes.observer.Observers;
import org.refcodes.rest.HttpExceptionHandlerAccessor;
import org.refcodes.rest.HttpExceptionHandlingAccessor;
import org.refcodes.rest.RestEndpoint;
import org.refcodes.rest.RestEndpointBuilder;
import org.refcodes.rest.RestRequestConsumer;
import org.refcodes.runtime.RequestCorrelation;
import org.refcodes.runtime.SessionCorrelation;
import org.refcodes.web.BaseLocatorAccessor;
import org.refcodes.web.HttpMethod;
import org.refcodes.web.MediaTypeFactoryLookup;
import org.refcodes.web.RealmAccessor;

public interface RestServer
extends HttpExceptionHandlerAccessor.HttpExceptionHandlerProperty,
HttpExceptionHandlerAccessor.HttpExceptionHandlerBuilder<RestServer>,
HttpExceptionHandlingAccessor.HttpExceptionHandlingProperty,
HttpExceptionHandlingAccessor.HttpExceptionHandlingBuilder<RestServer>,
Observable<RestEndpoint>,
Observers<RestEndpoint, RestServer>,
MediaTypeFactoryLookup.MutableMediaTypeFactoryLookup,
RealmAccessor.RealmProperty,
RealmAccessor.RealmBuilder<RestServer>,
BaseLocatorAccessor.BaseLocatorProperty,
BaseLocatorAccessor.BaseLocatorBuilder<RestServer>,
RequestCorrelation<RestServer>,
SessionCorrelation<RestServer> {
    default public RestServer withObserversActive(boolean bl) {
        this.setObserversActive(bl);
        return this;
    }

    default public RestServer withEnableObservers() {
        this.setObserversActive(true);
        return this;
    }

    default public RestServer withDisableObservers() {
        this.setObserversActive(false);
        return this;
    }

    default public RestServer withSessionCorrelation(boolean bl) {
        this.setSessionCorrelation(bl);
        return this;
    }

    default public RestServer withEnableSessionCorrelation() {
        this.enableSessionCorrelation();
        return this;
    }

    default public RestServer withDisableSessionCorrelation() {
        this.disableSessionCorrelation();
        return this;
    }

    default public RestServer withRequestCorrelation(boolean bl) {
        this.setRequestCorrelation(bl);
        return this;
    }

    default public RestServer withEnableRequestCorrelation() {
        this.enableRequestCorrelation();
        return this;
    }

    default public RestServer withDisableRequestCorrelation() {
        this.disableRequestCorrelation();
        return this;
    }

    default public boolean onRequest(RestEndpoint restEndpoint) {
        return this.subscribeObserver(restEndpoint);
    }

    default public RestServer withBaseLocator(String string) {
        this.setBaseLocator(string);
        return this;
    }

    default public RestServer withRealm(String string) {
        this.setRealm(string);
        return this;
    }

    default public RestEndpointBuilder onRequest(String string, RestRequestConsumer restRequestConsumer) {
        return this.onRequest(null, string, restRequestConsumer);
    }

    default public RestEndpointBuilder onRequest(Pattern pattern, RestRequestConsumer restRequestConsumer) {
        return this.onRequest(null, pattern, restRequestConsumer);
    }

    default public RestEndpointBuilder onRequest(HttpMethod httpMethod, String string, RestRequestConsumer restRequestConsumer) {
        RestEndpointBuilder restEndpointBuilder = new RestEndpointBuilder(httpMethod, string, restRequestConsumer);
        if (!this.subscribeObserver(restEndpointBuilder)) {
            throw new BugException("We encountered a bug! As we created the endpoint within this method, it cannot have been added already!");
        }
        return restEndpointBuilder;
    }

    default public RestEndpointBuilder onRequest(HttpMethod httpMethod, Pattern pattern, RestRequestConsumer restRequestConsumer) {
        RestEndpointBuilder restEndpointBuilder = new RestEndpointBuilder(httpMethod, pattern, restRequestConsumer);
        if (!this.subscribeObserver(restEndpointBuilder)) {
            throw new BugException("We encountered a bug! As we created the endpoint within this method, it cannot have been added already!");
        }
        return restEndpointBuilder;
    }

    default public RestEndpointBuilder onGet(String string, RestRequestConsumer restRequestConsumer) {
        return this.onRequest(HttpMethod.GET, string, restRequestConsumer);
    }

    default public RestEndpointBuilder onGet(Pattern pattern, RestRequestConsumer restRequestConsumer) {
        return this.onRequest(HttpMethod.GET, pattern, restRequestConsumer);
    }

    default public RestEndpointBuilder onPut(String string, RestRequestConsumer restRequestConsumer) {
        return this.onRequest(HttpMethod.PUT, string, restRequestConsumer);
    }

    default public RestEndpointBuilder onPut(Pattern pattern, RestRequestConsumer restRequestConsumer) {
        return this.onRequest(HttpMethod.PUT, pattern, restRequestConsumer);
    }

    default public RestEndpointBuilder onPost(String string, RestRequestConsumer restRequestConsumer) {
        return this.onRequest(HttpMethod.POST, string, restRequestConsumer);
    }

    default public RestEndpointBuilder onPost(Pattern pattern, RestRequestConsumer restRequestConsumer) {
        return this.onRequest(HttpMethod.POST, pattern, restRequestConsumer);
    }

    default public RestEndpointBuilder onDelete(String string, RestRequestConsumer restRequestConsumer) {
        return this.onRequest(HttpMethod.DELETE, string, restRequestConsumer);
    }

    default public RestEndpointBuilder onDelete(Pattern pattern, RestRequestConsumer restRequestConsumer) {
        return this.onRequest(HttpMethod.DELETE, pattern, restRequestConsumer);
    }
}

