/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.rest;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.refcodes.component.ConnectionStatus;
import org.refcodes.component.ConnectionStatusAccessor;
import org.refcodes.component.LinkComponent;
import org.refcodes.data.DaemonLoopSleepTime;
import org.refcodes.exception.ExceptionUtility;
import org.refcodes.io.IOResultAccessor;
import org.refcodes.mixin.ResponseAccessor;
import org.refcodes.rest.RestClient;
import org.refcodes.rest.RestRequestHandler;
import org.refcodes.rest.RestResponse;
import org.refcodes.rest.RestResponseConsumer;
import org.refcodes.rest.RestResponseEvent;
import org.refcodes.textual.VerboseTextBuilder;
import org.refcodes.web.FormFields;
import org.refcodes.web.HeaderFieldsAccessor;
import org.refcodes.web.HttpClientRequest;
import org.refcodes.web.HttpMethod;
import org.refcodes.web.HttpMethodAccessor;
import org.refcodes.web.HttpRequestBuilder;
import org.refcodes.web.HttpResponseException;
import org.refcodes.web.MediaTypeFactoryLookup;
import org.refcodes.web.QueryFieldsAccessor;
import org.refcodes.web.RedirectDepthAccessor;
import org.refcodes.web.RequestHeaderFields;
import org.refcodes.web.Url;
import org.refcodes.web.UrlAccessor;
import org.refcodes.web.UrlBuilder;

public class RestResponseResult
extends HttpClientRequest
implements RestResponseConsumer,
QueryFieldsAccessor.QueryFieldsProperty,
HeaderFieldsAccessor.HeaderFieldsProperty<RequestHeaderFields>,
RedirectDepthAccessor.RedirectDepthBuilder<RestResponseResult>,
HttpRequestBuilder<RestResponseResult>,
HttpMethodAccessor.HttpMethodProperty,
HttpMethodAccessor.HttpMethodBuilder<RestResponseResult>,
LinkComponent.LinkComponentBuilder<RestResponseResult>,
ConnectionStatusAccessor,
HeaderFieldsAccessor.HeaderFieldsBuilder<RequestHeaderFields, RestResponseResult>,
IOResultAccessor<RestResponse, InterruptedException>,
ResponseAccessor<RestResponse> {
    private static Logger LOGGER = Logger.getLogger(RestResponseResult.class.getName());
    private RestResponse _response = null;
    private ConnectionStatus _connectionStatus = ConnectionStatus.NONE;

    public RestResponseResult(HttpMethod httpMethod, Url url, Object object, int n, MediaTypeFactoryLookup mediaTypeFactoryLookup) {
        super(httpMethod, url, object, n, mediaTypeFactoryLookup);
    }

    public RestResponseResult(HttpMethod httpMethod, Url url, Object object, MediaTypeFactoryLookup mediaTypeFactoryLookup) {
        super(httpMethod, url, object, mediaTypeFactoryLookup);
    }

    public RestResponseResult(HttpMethod httpMethod, Url url, RequestHeaderFields requestHeaderFields, Object object, int n, MediaTypeFactoryLookup mediaTypeFactoryLookup) {
        super(httpMethod, url, requestHeaderFields, object, n, mediaTypeFactoryLookup);
    }

    public RestResponseResult(HttpMethod httpMethod, Url url, RequestHeaderFields requestHeaderFields, Object object, MediaTypeFactoryLookup mediaTypeFactoryLookup) {
        super(httpMethod, url, requestHeaderFields, object, mediaTypeFactoryLookup);
    }

    public RestResponseResult(HttpMethod httpMethod, Url url, int n, MediaTypeFactoryLookup mediaTypeFactoryLookup) {
        super(httpMethod, url, n, mediaTypeFactoryLookup);
    }

    public RestResponseResult(HttpMethod httpMethod, Url url, MediaTypeFactoryLookup mediaTypeFactoryLookup) {
        super(httpMethod, url, mediaTypeFactoryLookup);
    }

    public RestResponseResult(MediaTypeFactoryLookup mediaTypeFactoryLookup) {
        super(null, null, null, null, mediaTypeFactoryLookup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RestResponse getResult() throws InterruptedException {
        if (!this.hasResult()) {
            RestResponseResult restResponseResult = this;
            synchronized (restResponseResult) {
                block7: {
                    if (!this.hasResult()) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            if (this.hasResult()) break block7;
                            throw interruptedException;
                        }
                    }
                }
            }
        }
        return this.getResponse();
    }

    public RestResponse getResponse() {
        return this._response;
    }

    public HttpMethod getHttpMethod() {
        return this._httpMethod;
    }

    public void setHttpMethod(HttpMethod httpMethod) {
        this._httpMethod = httpMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws IOException {
        this._connectionStatus = ConnectionStatus.OPENED;
        RestResponseResult restResponseResult = this;
        synchronized (restResponseResult) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        this._connectionStatus = ConnectionStatus.CLOSED;
        RestResponseResult restResponseResult = this;
        synchronized (restResponseResult) {
            this.notifyAll();
        }
    }

    public ConnectionStatus getConnectionStatus() {
        return this._connectionStatus;
    }

    public void setHeaderFields(RequestHeaderFields requestHeaderFields) {
        this._headerFields = requestHeaderFields;
    }

    public Url getUrl() {
        return this._url;
    }

    public void setUrl(Url url) {
        this._url = url;
    }

    public boolean hasResult() {
        return this.getResponse() != null;
    }

    public void setQueryFields(FormFields formFields) {
        Url url = this.getUrl();
        UrlBuilder urlBuilder = url instanceof UrlAccessor.UrlBuilder ? (UrlBuilder)url : new UrlBuilder(url);
        urlBuilder.setQueryFields(formFields);
        this.setUrl((Url)urlBuilder);
    }

    public FormFields getQueryFields() {
        return this.getUrl().getQueryFields();
    }

    public RestResponseResult withUrl(Url url) {
        this.setUrl(url);
        return this;
    }

    public RestResponseResult withHttpMethod(HttpMethod httpMethod) {
        this.setHttpMethod(httpMethod);
        return this;
    }

    public <REQ> RestResponseResult withRequest(REQ REQ) {
        this.setRequest(REQ);
        return this;
    }

    public RestResponseResult withHeaderFields(RequestHeaderFields requestHeaderFields) {
        this.setHeaderFields(requestHeaderFields);
        return this;
    }

    public RestResponseResult withRedirectDepth(int n) {
        this.setRedirectDepth(n);
        return this;
    }

    public RestResponseResult withOpen() throws IOException {
        this.open();
        return this;
    }

    public RestResponseResult withClose() throws IOException {
        this.close();
        return this;
    }

    public RestResponseResult withCloseQuietly() {
        this.closeQuietly();
        return this;
    }

    public RestResponseResult withCloseIn(int n) {
        this.closeIn(n);
        return this;
    }

    public RestResponseResult build(RestClient restClient) {
        return new RestResponseResult((MediaTypeFactoryLookup)restClient);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this._httpMethod + ": " + this._url.toHttpUrl() + "?" + new VerboseTextBuilder().withElements((Map)this._url.getQueryFields()).toString() + ")@" + this.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onResponse(RestResponseEvent restResponseEvent) throws HttpResponseException {
        if (this.getConnectionStatus() != ConnectionStatus.CLOSED) {
            this._response = restResponseEvent;
            RestResponseResult restResponseResult = this;
            synchronized (restResponseResult) {
                this.notifyAll();
            }
        } else {
            LOGGER.log(Level.WARNING, "Ignoring response <" + restResponseEvent + "> as this rest endpoint is in status <" + this._connectionStatus + ">, you may have closed it already?");
        }
    }

    static class RestResponseResultDaemon
    implements Runnable {
        private RestResponseResult _responseResult;
        private RestRequestHandler _requestHandler;
        private RestClient _source;

        protected RestResponseResultDaemon(RestResponseResult restResponseResult, RestRequestHandler restRequestHandler, RestClient restClient) {
            if (restRequestHandler == null) {
                throw new IllegalArgumentException("Unable to process your request <" + this._responseResult.toString() + "> as no <" + RestRequestHandler.class.getSimpleName() + "> has been implemented, aborting!");
            }
            this._responseResult = restResponseResult;
            this._requestHandler = restRequestHandler;
            this._source = restClient;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Object object = this._responseResult;
                synchronized (object) {
                    while (this._responseResult.getConnectionStatus() == ConnectionStatus.NONE) {
                        try {
                            this._responseResult.wait(DaemonLoopSleepTime.MAX.getTimeInMs());
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (this._responseResult.getConnectionStatus() != ConnectionStatus.NONE) continue;
                        LOGGER.log(Level.WARNING, "Your result's <" + this._responseResult + "> connection status is still <" + this._responseResult.getConnectionStatus() + "> after <" + DaemonLoopSleepTime.MAX.getTimeInMs() + "> ms, execution of your request starts not earlier than you calling the #open() method.");
                    }
                }
                if (this._responseResult.getConnectionStatus() != ConnectionStatus.OPENED) {
                    throw new IllegalStateException("Aborting your request as of your result <" + this._responseResult + "> connection status is <" + this._responseResult.getConnectionStatus() + "> although it is expected to e <" + ConnectionStatus.OPENED + ">.");
                }
                object = this._requestHandler.doRequest(this._responseResult);
                this._responseResult.onResponse(new RestResponseEvent((RestResponse)((Object)object), this._source));
            }
            catch (HttpResponseException httpResponseException) {
                LOGGER.log(Level.SEVERE, ExceptionUtility.toMessage((Throwable)httpResponseException), httpResponseException);
            }
        }
    }
}

