/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.rest;

import java.net.MalformedURLException;
import java.util.Timer;
import java.util.TimerTask;
import org.refcodes.data.IoRetryCount;
import org.refcodes.data.IoTimeout;
import org.refcodes.rest.HttpRestClient;
import org.refcodes.rest.HttpRestClientImpl;
import org.refcodes.rest.RestRequestBuilder;
import org.refcodes.rest.RestResponse;
import org.refcodes.web.BasicAuthCredentials;
import org.refcodes.web.FormFields;
import org.refcodes.web.GrantType;
import org.refcodes.web.HttpBodyMap;
import org.refcodes.web.HttpMediaType;
import org.refcodes.web.HttpResponseException;
import org.refcodes.web.HttpStatusException;
import org.refcodes.web.MediaType;
import org.refcodes.web.OauthField;
import org.refcodes.web.OauthToken;
import org.refcodes.web.Url;

public class OauthTokenHandler
extends OauthToken {
    private static final int DEFAULT_EXPIRES_IN = 180;
    private static final int MAX_REFRESH_TRIES = IoRetryCount.MIN.getValue();
    private static final long MAX_RETRY_SLEEP_TIME = IoTimeout.MIN.getTimeInMs();
    private String _url;
    private HttpRestClient _restClient;
    private Timer _timer;
    private TimerTask _timerTask;

    public OauthTokenHandler(Url url, String string, String string2, String string3, String string4) throws HttpStatusException, MalformedURLException {
        this(url.toHttpUrl(), (HttpRestClient)new HttpRestClientImpl(), string, string2, string3, string4, (GrantType)null);
    }

    public OauthTokenHandler(Url url, HttpRestClient httpRestClient, String string, String string2, String string3, String string4) throws HttpStatusException, MalformedURLException {
        this(url.toHttpUrl(), httpRestClient, string, string2, string3, string4, (GrantType)null);
    }

    public OauthTokenHandler(Url url, HttpRestClient httpRestClient, String string, String string2, String string3, String string4, String string5) throws HttpStatusException, MalformedURLException {
        this(url.toHttpUrl(), httpRestClient, string, string2, string3, string4, GrantType.fromName((String)string5));
    }

    public OauthTokenHandler(Url url, HttpRestClient httpRestClient, String string, String string2, String string3, String string4, GrantType grantType) throws HttpStatusException, MalformedURLException {
        this(url.toHttpUrl(), httpRestClient, string, string2, string3, string4, grantType);
    }

    public OauthTokenHandler(String string, String string2, String string3, String string4, String string5) throws HttpStatusException, MalformedURLException {
        this(string, (HttpRestClient)new HttpRestClientImpl(), string2, string3, string4, string5, (GrantType)null);
    }

    public OauthTokenHandler(String string, String string2, String string3, String string4, String string5, String string6) throws HttpStatusException, MalformedURLException {
        this(string, (HttpRestClient)new HttpRestClientImpl(), string2, string3, string4, string5, GrantType.fromName((String)string6));
    }

    public OauthTokenHandler(String string, String string2, String string3, String string4, String string5, GrantType grantType) throws HttpStatusException, MalformedURLException {
        this(string, (HttpRestClient)new HttpRestClientImpl(), string2, string3, string4, string5, grantType);
    }

    public OauthTokenHandler(String string, HttpRestClient httpRestClient, String string2, String string3, String string4, String string5) throws HttpStatusException, MalformedURLException {
        this(string, httpRestClient, string2, string3, string4, string5, (GrantType)null);
    }

    public OauthTokenHandler(String string, HttpRestClient httpRestClient, String string2, String string3, String string4, String string5, String string6) throws HttpStatusException, MalformedURLException {
        this(string, httpRestClient, string2, string3, string4, string5, GrantType.fromName((String)string6));
    }

    public OauthTokenHandler(String string, HttpRestClient httpRestClient, String string2, String string3, String string4, String string5, GrantType grantType) throws HttpStatusException, MalformedURLException {
        this(string, httpRestClient, OauthTokenHandler.toOauthToken(string, httpRestClient, string2, string3, string4, string5, grantType));
    }

    public OauthTokenHandler(String string, String string2, String string3, String string4, Integer n, String string5) {
        super(string2, string3, string4, n, string5);
        this.initialize(string, new HttpRestClientImpl());
    }

    public OauthTokenHandler(Url url, String string, String string2, String string3, Integer n, String string4) {
        super(string, string2, string3, n, string4);
        this.initialize(url.toHttpUrl(), new HttpRestClientImpl());
    }

    public OauthTokenHandler(Url url, HttpBodyMap httpBodyMap) {
        super(httpBodyMap);
        this.initialize(url.toHttpUrl(), new HttpRestClientImpl());
    }

    public OauthTokenHandler(Url url, OauthToken oauthToken) {
        super(oauthToken);
        this.initialize(url.toHttpUrl(), new HttpRestClientImpl());
    }

    public OauthTokenHandler(String string, OauthToken oauthToken) {
        super(oauthToken);
        this.initialize(string, new HttpRestClientImpl());
    }

    public OauthTokenHandler(Url url, HttpRestClient httpRestClient, String string, String string2, String string3, Integer n, String string4) {
        super(string, string2, string3, n, string4);
        this.initialize(url.toHttpUrl(), httpRestClient);
    }

    public OauthTokenHandler(Url url, HttpRestClient httpRestClient, HttpBodyMap httpBodyMap) {
        super(httpBodyMap);
        this.initialize(url.toHttpUrl(), httpRestClient);
    }

    public OauthTokenHandler(String string, HttpRestClient httpRestClient, OauthToken oauthToken) {
        super(oauthToken);
        this.initialize(string, httpRestClient);
    }

    public OauthTokenHandler(Url url, HttpRestClient httpRestClient, OauthToken oauthToken) {
        super(oauthToken);
        this.initialize(url.toHttpUrl(), httpRestClient);
    }

    public OauthTokenHandler(String string, HttpRestClient httpRestClient, String string2, String string3, String string4, Integer n, String string5) {
        super(string2, string3, string4, n, string5);
        this.initialize(string, httpRestClient);
    }

    private void initialize(String string, HttpRestClient httpRestClient) {
        if (this._refreshToken != null) {
            Integer n = this._expiresIn;
            if (n == null || n == -1) {
                n = 180;
            }
            this._url = string;
            this._restClient = httpRestClient;
            this._timer = new Timer(true);
            this._timerTask = new RefreshTask();
            this._timer.schedule(this._timerTask, this.toDelayInMillis(n));
        }
    }

    public synchronized void dispose() {
        this._timer.cancel();
        super.dispose();
    }

    private long toDelayInMillis(Integer n) {
        Double d = (double)n.intValue() * 1000.0 * 0.85;
        long l = d.longValue();
        return l;
    }

    private static OauthToken toOauthToken(String string, HttpRestClient httpRestClient, String string2, String string3, String string4, String string5, GrantType grantType) throws MalformedURLException, HttpStatusException {
        Object object;
        RestRequestBuilder restRequestBuilder = httpRestClient.buildPost(string);
        restRequestBuilder.getHeaderFields().putAcceptTypes(new HttpMediaType[]{MediaType.APPLICATION_JSON});
        if (string2 != null && string2.length() != 0) {
            object = new FormFields();
            object.put(OauthField.CLIENT_ID.getName(), string2);
            if (string3 != null && string3.length() != 0) {
                object.put(OauthField.CLIENT_SECRET.getName(), string3);
            }
            if (string4 != null && string4.length() != 0) {
                object.put(OauthField.USERNAME.getName(), string4);
            }
            if (string5 != null && string5.length() != 0) {
                object.put(OauthField.PASSWORD.getName(), string5);
            }
            object.put(OauthField.GRANT_TYPE.getName(), grantType != null ? grantType.getValue() : GrantType.PASSWORD.getValue());
            restRequestBuilder.setRequest(object);
        } else {
            if (grantType != null) {
                object = new FormFields();
                object.put(grantType.getValue(), new String[0]);
                restRequestBuilder.setRequest(object);
            }
            object = new BasicAuthCredentials(string4, string5);
            restRequestBuilder.getHeaderFields().putBasicAuthCredentials((BasicAuthCredentials)object);
        }
        object = restRequestBuilder.toRestResponse();
        if (object.getHttpStatusCode().isErrorStatus()) {
            throw object.getHttpStatusCode().toHttpStatusException(object.getHttpBody());
        }
        OauthToken oauthToken = new OauthToken(object.getResponse());
        return oauthToken;
    }

    private class RefreshTask
    extends TimerTask {
        private RefreshTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!OauthTokenHandler.this.isDisposed()) {
                OauthTokenHandler oauthTokenHandler = OauthTokenHandler.this;
                synchronized (oauthTokenHandler) {
                    if (!OauthTokenHandler.this._restClient.isOpened()) {
                        OauthTokenHandler.this.dispose();
                    } else {
                        Integer n = OauthTokenHandler.this._expiresIn;
                        for (int i = 0; i < MAX_REFRESH_TRIES; ++i) {
                            try {
                                RestResponse restResponse;
                                if (OauthTokenHandler.this.getRefreshToken() == null) {
                                    OauthTokenHandler.this._timer.cancel();
                                    return;
                                }
                                RestRequestBuilder restRequestBuilder = OauthTokenHandler.this._restClient.buildPost(OauthTokenHandler.this._url);
                                restRequestBuilder.getHeaderFields().putAcceptTypes(new HttpMediaType[]{MediaType.APPLICATION_JSON});
                                restRequestBuilder.getHeaderFields().putContentType((HttpMediaType)MediaType.APPLICATION_X_WWW_FORM_URLENCODED);
                                FormFields formFields = new FormFields();
                                formFields.put(OauthField.GRANT_TYPE.getName(), GrantType.REFRESH_TOKEN.getValue());
                                formFields.put(OauthField.REFRESH_TOKEN.getName(), OauthTokenHandler.this.getRefreshToken());
                                if (OauthTokenHandler.this.getScope() != null) {
                                    formFields.put(OauthField.SCOPE.getName(), OauthTokenHandler.this.getScope());
                                }
                                if (!(restResponse = restRequestBuilder.toRestResponse()).getHttpStatusCode().isSuccessStatus()) continue;
                                HttpBodyMap httpBodyMap = restResponse.getResponse();
                                if (!httpBodyMap.containsKey((Object)OauthField.ACCESS_TOKEN.getPath())) break;
                                if (!httpBodyMap.containsKey((Object)OauthField.TOKEN_TYPE.getPath())) {
                                    OauthTokenHandler.this._tokenType = (String)httpBodyMap.get((Object)OauthField.TOKEN_TYPE.getPath());
                                    break;
                                }
                                OauthTokenHandler.this.fromHttpBodyMap(httpBodyMap);
                                if (n != null && !n.equals(OauthTokenHandler.this._expiresIn)) {
                                    Integer n2 = OauthTokenHandler.this._expiresIn;
                                    if (n2 == null || n2 == -1) {
                                        n2 = 180;
                                    }
                                    OauthTokenHandler.this._timer.cancel();
                                    OauthTokenHandler.this._timer = new Timer(true);
                                    OauthTokenHandler.this._timer.schedule(OauthTokenHandler.this._timerTask, OauthTokenHandler.this.toDelayInMillis(n2));
                                }
                                return;
                            }
                            catch (MalformedURLException | HttpResponseException throwable) {
                                if (i >= MAX_REFRESH_TRIES) continue;
                                try {
                                    Thread.sleep(MAX_RETRY_SLEEP_TIME);
                                    continue;
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }
                        }
                        OauthTokenHandler.this.dispose();
                    }
                }
            }
        }
    }
}

