/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.rest;

import com.sun.net.httpserver.Authenticator;
import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpPrincipal;
import com.sun.net.httpserver.HttpServer;
import com.sun.net.httpserver.HttpsConfigurator;
import com.sun.net.httpserver.HttpsParameters;
import com.sun.net.httpserver.HttpsServer;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Base64;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManagerFactory;
import org.refcodes.component.ConnectionStatus;
import org.refcodes.controlflow.ControlFlowUtility;
import org.refcodes.controlflow.ThreadingModel;
import org.refcodes.data.Delimiter;
import org.refcodes.data.LatencySleepTime;
import org.refcodes.data.Literal;
import org.refcodes.data.Scheme;
import org.refcodes.exception.BugException;
import org.refcodes.exception.ExceptionUtility;
import org.refcodes.exception.MarshalException;
import org.refcodes.rest.AbstractRestServer;
import org.refcodes.rest.HttpExceptionHandler;
import org.refcodes.rest.HttpExceptionHandling;
import org.refcodes.rest.HttpRestClientImpl;
import org.refcodes.rest.HttpRestServer;
import org.refcodes.rest.RestRequestEvent;
import org.refcodes.security.KeyStoreDescriptor;
import org.refcodes.web.AuthType;
import org.refcodes.web.BadResponseException;
import org.refcodes.web.BasicAuthCredentials;
import org.refcodes.web.BasicAuthObserver;
import org.refcodes.web.BasicAuthRequiredException;
import org.refcodes.web.BasicAuthResponse;
import org.refcodes.web.ContentType;
import org.refcodes.web.HeaderField;
import org.refcodes.web.HttpBodyMap;
import org.refcodes.web.HttpMediaType;
import org.refcodes.web.HttpMethod;
import org.refcodes.web.HttpServerResponse;
import org.refcodes.web.HttpStatusCode;
import org.refcodes.web.HttpStatusException;
import org.refcodes.web.HttpsConnectionRequestObserver;
import org.refcodes.web.MediaType;
import org.refcodes.web.MediaTypeFactoryLookup;
import org.refcodes.web.RequestHeaderFields;
import org.refcodes.web.TransportLayerProtocol;
import org.refcodes.web.UnsupportedMediaTypeException;
import org.refcodes.web.Url;
import org.refcodes.web.UrlBuilder;

public class HttpRestServerImpl
extends AbstractRestServer
implements HttpRestServer {
    private static Logger LOGGER = Logger.getLogger(HttpRestServerImpl.class.getName());
    protected static final String CONTEXT_PATH = "" + Delimiter.PATH.getChar();
    private static final String ANONYMOUS = "anonymous";
    private static final int NO_RESPONSE_BODY = -1;
    private static final int CHUNCKED_ENCODING = 0;
    private HttpServer _httpServer = null;
    private int _port = -1;
    private HttpsConnectionRequestObserver _httpsConnectionRequestObserver = null;
    private ExecutorService _executorService;
    private ConnectionStatus _connectionStatus = ConnectionStatus.NONE;
    private HttpBasicAuthenticator _httpBasicAuthenticator = null;
    private HttpContext _httpContext;
    private Scheme _scheme = null;
    private String _protocol = null;
    private KeyStoreDescriptor _keyStoreDescriptor = null;
    private int _maxConnections = -1;

    public HttpRestServerImpl(ThreadingModel threadingModel) {
        this(threadingModel == ThreadingModel.SINGLE ? null : ControlFlowUtility.createCachedExecutorService((boolean)true));
    }

    public HttpRestServerImpl() {
        this(ControlFlowUtility.createCachedExecutorService((boolean)true));
    }

    public HttpRestServerImpl(ExecutorService executorService) {
        super(executorService);
        this._executorService = executorService;
        this._httpExceptionHandler = new DefaultErrorHandler();
    }

    public synchronized void close() throws IOException {
        if (this._connectionStatus != ConnectionStatus.OPENED) {
            throw new IOException("Connection is in status <" + this._connectionStatus + ">. Open the connection before closing!");
        }
        try {
            if (this._httpServer != null) {
                this._httpServer.stop(LatencySleepTime.MIN.getTimeInMs() / 1000);
                this._httpServer.removeContext(CONTEXT_PATH);
                this._httpServer = null;
            }
        }
        finally {
            this._connectionStatus = ConnectionStatus.CLOSED;
        }
    }

    @Override
    public void open(String string, KeyStoreDescriptor keyStoreDescriptor, int n, int n2) throws IOException {
        Scheme scheme;
        if (n < 0) {
            n = this.getPort();
        }
        if (n < 0) {
            throw new IOException("You must provide a valid port via 'setPort( aPort )' before you can invoke a port-less 'open' method!");
        }
        this._port = n;
        if (string == null) {
            string = this.toProtocol();
        }
        if ((scheme = Scheme.fromProtocol((String)string)) == Scheme.HTTPS) {
            string = TransportLayerProtocol.TLS.name();
        }
        if (string == null && keyStoreDescriptor != null) {
            string = TransportLayerProtocol.TLS.name();
        }
        if (keyStoreDescriptor == null) {
            keyStoreDescriptor = this.getKeyStoreDescriptor();
        }
        if (n2 < 0) {
            n2 = this.getMaxConnections();
        }
        if (scheme == null && string == null || scheme == Scheme.HTTP) {
            try {
                HttpServer httpServer = HttpServer.create();
                httpServer.bind(new InetSocketAddress(n), n2);
                this.open(httpServer);
            }
            catch (IOException iOException) {
                throw new IOException("Unable to bind to port <" + n + ">: " + ExceptionUtility.toMessage((Throwable)iOException), iOException);
            }
        }
        try {
            InetSocketAddress inetSocketAddress = new InetSocketAddress(n);
            SSLContext sSLContext = SSLContext.getInstance(string);
            KeyStore keyStore = KeyStore.getInstance(keyStoreDescriptor.getStoreType().name());
            FileInputStream fileInputStream = new FileInputStream(keyStoreDescriptor.getStoreFile());
            keyStore.load(fileInputStream, keyStoreDescriptor.getStorePassword().toCharArray());
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, keyStoreDescriptor.getKeyPassword().toCharArray());
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            sSLContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
            HttpsServer httpsServer = HttpsServer.create(inetSocketAddress, n2);
            httpsServer.setHttpsConfigurator(new HttpsRestConfigurator(sSLContext));
            httpsServer.setExecutor(null);
            this.open(httpsServer);
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException exception) {
            throw new IOException("Unable to bind to port <" + n + ">: " + ExceptionUtility.toMessage((Throwable)exception), exception);
        }
    }

    public ConnectionStatus getConnectionStatus() {
        return this._connectionStatus;
    }

    public HttpRestServer onConnectionRequest(HttpsConnectionRequestObserver httpsConnectionRequestObserver) {
        this._httpsConnectionRequestObserver = httpsConnectionRequestObserver;
        return this;
    }

    public HttpRestServer onBasicAuthRequest(BasicAuthObserver basicAuthObserver) {
        HttpContext httpContext = this._httpContext;
        HttpBasicAuthenticator httpBasicAuthenticator = null;
        if (basicAuthObserver != null) {
            httpBasicAuthenticator = new HttpBasicAuthenticator(basicAuthObserver);
            if (httpContext != null) {
                httpContext.setAuthenticator(httpBasicAuthenticator);
            }
        }
        this._httpBasicAuthenticator = httpBasicAuthenticator;
        return this;
    }

    @Override
    public HttpRestServer withRealm(String string) {
        this.setRealm(string);
        return this;
    }

    public void setPort(int n) {
        this._port = n;
    }

    public int getPort() {
        return this._port;
    }

    public void setScheme(Scheme scheme) {
        this._scheme = scheme;
        this._protocol = null;
    }

    public Scheme getScheme() {
        return this._scheme;
    }

    public String toProtocol() {
        if (this._scheme != null) {
            return this._scheme.toProtocol();
        }
        return this._protocol;
    }

    public void setProtocol(String string) {
        Scheme scheme = Scheme.fromProtocol((String)string);
        if (scheme != null) {
            this._scheme = scheme;
            this._protocol = null;
        } else {
            this._protocol = string;
            this._scheme = null;
        }
    }

    public KeyStoreDescriptor getKeyStoreDescriptor() {
        return this._keyStoreDescriptor;
    }

    public void setKeyStoreDescriptor(KeyStoreDescriptor keyStoreDescriptor) {
        this._keyStoreDescriptor = keyStoreDescriptor;
    }

    public int getMaxConnections() {
        return this._maxConnections;
    }

    public void setMaxConnections(int n) {
        this._maxConnections = n;
    }

    protected HttpServer getHttpServer() {
        return this._httpServer;
    }

    protected void open(HttpServer httpServer) throws IOException {
        if (this._connectionStatus == ConnectionStatus.OPENED) {
            throw new IOException("Connection is still in status <" + this._connectionStatus + ">. Close the connection before reopening!");
        }
        if (this._executorService != null) {
            httpServer.setExecutor(this._executorService);
        }
        HttpContext httpContext = httpServer.createContext(CONTEXT_PATH, new EndpointHttpHandler());
        HttpBasicAuthenticator httpBasicAuthenticator = this._httpBasicAuthenticator;
        if (httpBasicAuthenticator != null) {
            httpContext.setAuthenticator(httpBasicAuthenticator);
        }
        httpServer.start();
        this._httpServer = httpServer;
        this._httpContext = httpContext;
        this._connectionStatus = ConnectionStatus.OPENED;
    }

    private Authenticator.Result toBasicAuthFailure(HttpExchange httpExchange) {
        return new Authenticator.Failure(HttpStatusCode.UNAUTHORIZED.getStatusCode());
    }

    private Authenticator.Success toBasicOutSuccess(String string) {
        return new Authenticator.Success(new HttpPrincipal(string, this.getRealm()));
    }

    private Authenticator.Result toBasicAuthRequired(HttpExchange httpExchange) {
        Headers headers = httpExchange.getResponseHeaders();
        this.doBasicAuthRequired(headers);
        return new Authenticator.Retry(HttpStatusCode.UNAUTHORIZED.getStatusCode());
    }

    private void doBasicAuthRequired(Headers headers) {
        headers.set(HeaderField.WWW_AUTHENTICATE.getName(), "Basic realm=\"" + this.getRealm() + "\"");
    }

    private class HttpsRestConfigurator
    extends HttpsConfigurator {
        public HttpsRestConfigurator(SSLContext sSLContext) {
            super(sSLContext);
        }

        @Override
        public void configure(HttpsParameters httpsParameters) {
            HttpsConnectionRequestObserver httpsConnectionRequestObserver = HttpRestServerImpl.this._httpsConnectionRequestObserver;
            if (httpsConnectionRequestObserver != null) {
                InetSocketAddress inetSocketAddress = httpsParameters.getClientAddress();
                InetSocketAddress inetSocketAddress2 = null;
                HttpServer httpServer = HttpRestServerImpl.this.getHttpServer();
                if (httpServer != null) {
                    inetSocketAddress2 = httpServer.getAddress();
                } else {
                    LOGGER.log(Level.WARNING, "Unable to determine the local address for remote address <" + inetSocketAddress.toString() + ">, the server might have been closed in the meantimne.");
                }
                SSLContext sSLContext = this.getSSLContext();
                SSLParameters sSLParameters = sSLContext.getDefaultSSLParameters();
                httpsConnectionRequestObserver.onHttpsConnectionRequest(inetSocketAddress2, inetSocketAddress, sSLParameters);
                httpsParameters.setSSLParameters(sSLParameters);
            }
        }
    }

    private class DefaultErrorHandler
    implements HttpExceptionHandler {
        private DefaultErrorHandler() {
        }

        @Override
        public void onHttpError(RestRequestEvent restRequestEvent, HttpServerResponse httpServerResponse, Exception exception, HttpStatusCode httpStatusCode) {
            switch (HttpRestServerImpl.this.getHttpExceptionHandling()) {
                case EMPTY: {
                    httpServerResponse.setResponse(null);
                    httpServerResponse.getHeaderFields().clear();
                    break;
                }
                case KEEP: {
                    break;
                }
                case MERGE: {
                    HttpBodyMap httpBodyMap = this.toResponseBodyMap(httpServerResponse);
                    if (!httpBodyMap.hasStatusCode()) {
                        httpBodyMap.putStatusCode(httpStatusCode);
                    }
                    if (!httpBodyMap.hasStatusAlias()) {
                        httpBodyMap.putStatusAlias(httpStatusCode);
                    }
                    if (!httpBodyMap.hasStatusException()) {
                        httpBodyMap.putStatusException(exception);
                    }
                    if (!httpBodyMap.hasStatusMessage() && exception.getMessage() != null && exception.getMessage().length() > 0) {
                        httpBodyMap.putStatusMessage(exception.getMessage());
                    }
                    if (!httpBodyMap.hasStatusTimeStamp()) {
                        httpBodyMap.putStatusTimeStamp();
                    }
                    httpServerResponse.setResponse((Object)httpBodyMap);
                    break;
                }
                case UPDATE: {
                    HttpBodyMap httpBodyMap = this.toResponseBodyMap(httpServerResponse);
                    httpBodyMap.putStatusCode(httpStatusCode);
                    httpBodyMap.putStatusAlias(httpStatusCode);
                    httpBodyMap.putStatusException(exception);
                    httpBodyMap.putStatusMessage(exception.getMessage());
                    httpBodyMap.putStatusTimeStamp();
                    httpServerResponse.setResponse((Object)httpBodyMap);
                    break;
                }
                case REPLACE: {
                    HttpBodyMap httpBodyMap = new HttpBodyMap();
                    httpBodyMap.putStatusCode(httpStatusCode);
                    httpBodyMap.putStatusAlias(httpStatusCode);
                    httpBodyMap.putStatusException(exception);
                    httpBodyMap.putStatusMessage(exception.getMessage());
                    httpBodyMap.putStatusTimeStamp();
                    httpServerResponse.setResponse((Object)httpBodyMap);
                    break;
                }
                default: {
                    throw new BugException("Missing case statement for <" + HttpRestServerImpl.this.getHttpExceptionHandling() + "> in implementation!");
                }
            }
        }

        protected HttpBodyMap toResponseBodyMap(HttpServerResponse httpServerResponse) {
            HttpBodyMap httpBodyMap = null;
            Object object = httpServerResponse.getResponse();
            if (object != null) {
                if (object instanceof HttpBodyMap) {
                    httpBodyMap = (HttpBodyMap)object;
                } else if (!(object instanceof InputStream)) {
                    httpBodyMap = new HttpBodyMap(httpServerResponse.getResponse());
                }
            }
            if (httpBodyMap == null) {
                httpBodyMap = new HttpBodyMap();
            }
            return httpBodyMap;
        }
    }

    private class EndpointHttpHandler
    implements HttpHandler {
        private EndpointHttpHandler() {
        }

        @Override
        public void handle(HttpExchange httpExchange) throws IOException {
            HttpMethod httpMethod = HttpMethod.fromHttpMethod((String)httpExchange.getRequestMethod());
            if (httpMethod != null) {
                URI uRI = httpExchange.getRequestURI();
                HttpServerResponse httpServerResponse = new HttpServerResponse((MediaTypeFactoryLookup)HttpRestServerImpl.this);
                InetSocketAddress inetSocketAddress = httpExchange.getLocalAddress();
                InetSocketAddress inetSocketAddress2 = httpExchange.getRemoteAddress();
                Headers headers = httpExchange.getRequestHeaders();
                RequestHeaderFields requestHeaderFields = new RequestHeaderFields((Map)headers);
                UrlBuilder urlBuilder = new UrlBuilder(uRI.toString());
                if (urlBuilder.getScheme() == null) {
                    Scheme scheme = HttpRestServerImpl.this._scheme;
                    if (scheme == null) {
                        scheme = TransportLayerProtocol.toScheme((String)HttpRestServerImpl.this._protocol);
                    }
                    urlBuilder.setScheme(scheme);
                }
                if (urlBuilder.getHost() == null) {
                    urlBuilder.setHost(Literal.LOCALHOST.getValue());
                }
                if (urlBuilder.getPort() == -1) {
                    urlBuilder.setPort(HttpRestServerImpl.this._port);
                }
                try {
                    this.onHttpRequest(httpExchange, inetSocketAddress, inetSocketAddress2, httpMethod, urlBuilder, requestHeaderFields, httpExchange.getRequestBody(), httpServerResponse);
                }
                catch (BasicAuthRequiredException basicAuthRequiredException) {
                    HttpRestServerImpl.this.doBasicAuthRequired(httpExchange.getResponseHeaders());
                    LOGGER.log(Level.INFO, "Required HTTP Basic-Authentication with status <" + basicAuthRequiredException.getStatusCode() + "> with code <" + basicAuthRequiredException.getStatusCode().getStatusCode() + "> for request URL <" + uRI + "> with request method <" + httpExchange.getRequestMethod() + ">: " + ExceptionUtility.toMessage((Throwable)basicAuthRequiredException));
                    this.onHttpException(httpExchange, inetSocketAddress, inetSocketAddress2, httpMethod, urlBuilder, requestHeaderFields, httpServerResponse, (Exception)((Object)basicAuthRequiredException), basicAuthRequiredException.getStatusCode());
                }
                catch (HttpStatusException httpStatusException) {
                    LOGGER.log(Level.WARNING, "Responding status <" + httpStatusException.getStatusCode() + "> with code <" + httpStatusException.getStatusCode().getStatusCode() + "> for request URL <" + uRI + "> with request method <" + httpExchange.getRequestMethod() + ">: " + ExceptionUtility.toMessage((Throwable)httpStatusException));
                    this.onHttpException(httpExchange, inetSocketAddress, inetSocketAddress2, httpMethod, urlBuilder, requestHeaderFields, httpServerResponse, (Exception)((Object)httpStatusException), httpStatusException.getStatusCode());
                }
                catch (Exception exception) {
                    LOGGER.log(Level.WARNING, "Bad request <" + exception.getClass().getName() + "> for request URL <" + uRI + "> with request method <" + httpExchange.getRequestMethod() + ">: " + ExceptionUtility.toMessage((Throwable)exception), exception);
                    this.onHttpException(httpExchange, inetSocketAddress, inetSocketAddress2, httpMethod, urlBuilder, requestHeaderFields, httpServerResponse, exception, HttpStatusCode.BAD_REQUEST);
                }
            } else {
                LOGGER.log(Level.WARNING, "Unknown HTTP-Method <" + httpExchange.getRequestMethod() + "> when querying resource locator <" + httpExchange.getLocalAddress() + ">.");
                httpExchange.sendResponseHeaders(HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), -1L);
            }
        }

        private void onHttpRequest(HttpExchange httpExchange, InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2, HttpMethod httpMethod, UrlBuilder urlBuilder, RequestHeaderFields requestHeaderFields, InputStream inputStream, HttpServerResponse httpServerResponse) throws HttpStatusException, MarshalException, IOException {
            HttpRestServerImpl.super.onHttpRequest(inetSocketAddress, inetSocketAddress2, httpMethod, (Url)urlBuilder, requestHeaderFields, inputStream, httpServerResponse);
            HttpStatusCode httpStatusCode = httpServerResponse.getHttpStatusCode();
            if (httpStatusCode == null) {
                httpStatusCode = HttpStatusCode.OK;
            }
            this.doHttpResponse(httpExchange, requestHeaderFields, httpServerResponse, httpStatusCode);
        }

        protected void onHttpException(HttpExchange httpExchange, InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2, HttpMethod httpMethod, UrlBuilder urlBuilder, RequestHeaderFields requestHeaderFields, HttpServerResponse httpServerResponse, Exception exception, HttpStatusCode httpStatusCode) throws IOException {
            httpServerResponse.setHttpStatusCode(httpStatusCode);
            if (HttpRestServerImpl.this._httpExceptionHandler != null) {
                try {
                    RestRequestEvent restRequestEvent = new RestRequestEvent(inetSocketAddress, inetSocketAddress2, httpMethod, (Url)urlBuilder, null, requestHeaderFields, httpExchange.getRequestBody(), HttpRestServerImpl.this);
                    HttpRestServerImpl.this._httpExceptionHandler.onHttpError(restRequestEvent, httpServerResponse, exception, httpStatusCode);
                    this.finalizeMediaType(httpServerResponse);
                    this.doHttpResponse(httpExchange, requestHeaderFields, httpServerResponse, httpStatusCode);
                }
                catch (Exception exception2) {
                    this.finalizeHttpExceptionResponse(httpExchange, exception, httpStatusCode);
                }
            } else {
                this.finalizeHttpExceptionResponse(httpExchange, exception, httpStatusCode);
            }
        }

        protected void finalizeMediaType(HttpServerResponse httpServerResponse) {
            ContentType contentType;
            if (!(httpServerResponse.getResponse() == null || (contentType = httpServerResponse.getHeaderFields().getContentType()) != null && HttpRestServerImpl.this.hasMediaTypeFactory(contentType.getMediaType()))) {
                String string = contentType != null ? contentType.toHttpMediaType() : null;
                LOGGER.log(Level.WARNING, "Unsupported Content-Type <" + string + "> detected in HTTP-Server-Response, trying fallback ...");
                if (HttpRestServerImpl.this.getFactoryMediaTypes().length == 0) {
                    LOGGER.log(Level.WARNING, "No fallback Content-Type detected for HTTP-Server-Response as no Media-Type-Factories have been configured ...");
                } else if (HttpRestServerImpl.this.getFactoryMediaTypes().length != 0) {
                    MediaType mediaType = HttpRestServerImpl.this.getFactoryMediaTypes()[0];
                    LOGGER.log(Level.INFO, "Using fallback Content-Type <" + mediaType.toHttpMediaType() + "> for HTTP-Server-Response ...");
                    httpServerResponse.getHeaderFields().putContentType((HttpMediaType)mediaType);
                }
            }
        }

        protected void doHttpResponse(HttpExchange httpExchange, RequestHeaderFields requestHeaderFields, HttpServerResponse httpServerResponse, HttpStatusCode httpStatusCode) throws IOException, MarshalException, UnsupportedMediaTypeException {
            Object object2;
            Headers headers = httpExchange.getResponseHeaders();
            for (Object object2 : httpServerResponse.getHeaderFields().keySet()) {
                headers.put((String)object2, httpServerResponse.getHeaderFields().get(object2));
            }
            Object object3 = httpServerResponse.getResponse();
            if (object3 instanceof InputStream) {
                httpExchange.sendResponseHeaders(httpStatusCode.getStatusCode(), 0L);
                object2 = (InputStream)object3;
                HttpRestClientImpl.pipe((InputStream)object2, httpExchange.getResponseBody());
                httpExchange.getResponseBody().flush();
            } else {
                object2 = null;
                if (object3 != null) {
                    try {
                        object2 = httpServerResponse.toHttpBody().getBytes();
                    }
                    catch (BadResponseException badResponseException) {
                        LOGGER.log(Level.WARNING, badResponseException.getMessage() + ": Trying fallback procedure ...");
                        object2 = HttpRestServerImpl.this.toResponseBody(httpServerResponse.getResponse(), requestHeaderFields, httpServerResponse.getHeaderFields());
                    }
                }
                if (object2 != null && ((String)object2).length != 0) {
                    httpExchange.sendResponseHeaders(httpStatusCode.getStatusCode(), ((Object)object2).length);
                    httpExchange.getResponseBody().write((byte[])object2);
                    httpExchange.getResponseBody().flush();
                } else {
                    httpExchange.sendResponseHeaders(httpStatusCode.getStatusCode(), -1L);
                }
            }
            httpExchange.getResponseBody().close();
        }

        protected void finalizeHttpExceptionResponse(HttpExchange httpExchange, Exception exception, HttpStatusCode httpStatusCode) throws IOException {
            LOGGER.log(Level.WARNING, "Unable fully satisfy <" + HttpRestServerImpl.this.getHttpExceptionHandling() + "> mode, falling back to <" + HttpExceptionHandling.EMPTY + "> : " + exception.getMessage(), exception);
            httpExchange.sendResponseHeaders(httpStatusCode.getStatusCode(), -1L);
            httpExchange.getResponseBody().close();
        }
    }

    private class HttpBasicAuthenticator
    extends Authenticator {
        private BasicAuthObserver _basicAuthObserver;

        public HttpBasicAuthenticator(BasicAuthObserver basicAuthObserver) {
            this._basicAuthObserver = basicAuthObserver;
        }

        @Override
        public Authenticator.Result authenticate(HttpExchange httpExchange) {
            Headers headers = httpExchange.getRequestHeaders();
            String string = headers.getFirst(HeaderField.AUTHORIZATION.getName());
            BasicAuthCredentials basicAuthCredentials = null;
            if (string == null) {
                BasicAuthResponse basicAuthResponse = this._basicAuthObserver.onBasicAuthRequest(httpExchange.getLocalAddress(), httpExchange.getRemoteAddress(), HttpMethod.fromHttpMethod((String)httpExchange.getRequestMethod()), httpExchange.getRequestURI().getPath(), basicAuthCredentials, HttpRestServerImpl.this.getRealm());
                if (basicAuthResponse != BasicAuthResponse.BASIC_AUTH_SUCCESS) {
                    return HttpRestServerImpl.this.toBasicAuthRequired(httpExchange);
                }
                return new Authenticator.Success(new HttpPrincipal(HttpRestServerImpl.ANONYMOUS, HttpRestServerImpl.this.getRealm()));
            }
            int n = string.indexOf(32);
            if (n == -1 || !string.substring(0, n).equals(AuthType.BASIC.getName())) {
                return HttpRestServerImpl.this.toBasicAuthFailure(httpExchange);
            }
            byte[] byArray = Base64.getDecoder().decode(string.substring(n + 1));
            String string2 = new String(byArray);
            n = string2.indexOf(58);
            basicAuthCredentials = new BasicAuthCredentials(string2.substring(0, n), string2.substring(n + 1));
            BasicAuthResponse basicAuthResponse = this._basicAuthObserver.onBasicAuthRequest(httpExchange.getLocalAddress(), httpExchange.getRemoteAddress(), HttpMethod.fromHttpMethod((String)httpExchange.getRequestMethod()), httpExchange.getRequestURI().getPath(), basicAuthCredentials, HttpRestServerImpl.this.getRealm());
            if (basicAuthResponse == null) {
                throw new NullPointerException("Your <HttpBasicAuthenticator> instance must return an element of type <BasicAuthResponse> and not null.");
            }
            switch (basicAuthResponse) {
                case BASIC_AUTH_SUCCESS: {
                    return HttpRestServerImpl.this.toBasicOutSuccess(basicAuthCredentials.getIdentity());
                }
                case BASIC_AUTH_REQUIRED: {
                    return HttpRestServerImpl.this.toBasicAuthRequired(httpExchange);
                }
                case BASIC_AUTH_FAILURE: {
                    return HttpRestServerImpl.this.toBasicAuthFailure(httpExchange);
                }
            }
            throw new BugException("Missing case statement for <" + basicAuthResponse + "> in implementation!");
        }
    }
}

