/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.rest;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.refcodes.component.ConnectionComponent;
import org.refcodes.component.ConnectionStatusAccessor;
import org.refcodes.component.LinkComponent;
import org.refcodes.rest.RestClient;
import org.refcodes.security.StoreType;
import org.refcodes.security.TrustStoreDescriptor;
import org.refcodes.security.TrustStoreDescriptorAccessor;
import org.refcodes.web.BaseUrlAccessor;
import org.refcodes.web.BasicAuthCredentials;
import org.refcodes.web.HttpClientContext;
import org.refcodes.web.OauthToken;
import org.refcodes.web.Url;

public interface HttpRestClient
extends ConnectionStatusAccessor,
ConnectionComponent<HttpClientContext>,
RestClient,
LinkComponent,
BaseUrlAccessor.BaseUrlProperty,
BaseUrlAccessor.BaseUrlBuilder<HttpRestClient>,
TrustStoreDescriptorAccessor.TrustStoreDescriptorProperty,
TrustStoreDescriptorAccessor.TrustStoreDescriptorBuilder<HttpRestClient> {
    public static final String DEFAULT_KEYSTORE_TYPE = StoreType.JKS.name();
    public static final String DEFAULT_SSL_PROTOCOL = "TLS";

    default public void open() throws IOException {
        this.open(this.getBaseUrl(), this.getTrustStoreDescriptor());
    }

    default public void open(HttpClientContext httpClientContext) throws IOException {
        this.open(httpClientContext.getBaseUrl(), httpClientContext.getTrustStoreDescriptor());
    }

    default public void open(TrustStoreDescriptor trustStoreDescriptor) throws IOException {
        this.open(this.getBaseUrl(), trustStoreDescriptor);
    }

    default public void open(Url url) throws IOException {
        this.open(url, this.getTrustStoreDescriptor());
    }

    public void open(Url var1, TrustStoreDescriptor var2) throws IOException;

    default public HttpRestClient withBaseUrl(String string) throws MalformedURLException {
        this.setBaseUrl(string);
        return this;
    }

    default public HttpRestClient withBaseUrl(Url url) {
        this.setBaseUrl(url);
        return this;
    }

    default public HttpRestClient withBaseUrl(URL uRL) {
        this.setBaseUrl(uRL);
        return this;
    }

    default public HttpRestClient withBasicAuthCredentials(BasicAuthCredentials basicAuthCredentials) {
        this.setBasicAuthCredentials(basicAuthCredentials);
        return this;
    }

    default public HttpRestClient withBasicAuthCredentials(String string, String string2) {
        this.setBasicAuthCredentials(string, string2);
        return this;
    }

    default public HttpRestClient withDisableRequestCorrelation() {
        this.disableRequestCorrelation();
        return this;
    }

    default public HttpRestClient withDisableSessionCorrelation() {
        this.disableSessionCorrelation();
        return this;
    }

    default public HttpRestClient withEnableRequestCorrelation() {
        this.enableRequestCorrelation();
        return this;
    }

    default public HttpRestClient withEnableSessionCorrelation() {
        this.enableSessionCorrelation();
        return this;
    }

    default public HttpRestClient withOAuthToken(OauthToken oauthToken) {
        this.setOauthToken(oauthToken);
        return this;
    }

    default public HttpRestClient withRequestCorrelation(boolean bl) {
        this.setRequestCorrelation(bl);
        return this;
    }

    default public HttpRestClient withSessionCorrelation(boolean bl) {
        this.setSessionCorrelation(bl);
        return this;
    }

    default public HttpRestClient withTrustStoreDescriptor(TrustStoreDescriptor trustStoreDescriptor) {
        this.setTrustStoreDescriptor(trustStoreDescriptor);
        return this;
    }

    default public HttpRestClient withUserAgent(String string) {
        this.setUserAgent(string);
        return this;
    }
}

