/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.rest;

import java.net.InetSocketAddress;
import org.refcodes.matcher.WildcardSubstitutes;
import org.refcodes.observer.GenericActionEvent;
import org.refcodes.rest.RestServer;
import org.refcodes.web.BasicAuthCredentials;
import org.refcodes.web.BasicAuthRequest;
import org.refcodes.web.HttpMethod;
import org.refcodes.web.LocalAddressAccessor;
import org.refcodes.web.RealmAccessor;
import org.refcodes.web.RemoteAddressAccessor;
import org.refcodes.web.Url;

public class BasicAuthEvent
extends BasicAuthRequest
implements GenericActionEvent<HttpMethod, RestServer>,
WildcardSubstitutes,
RealmAccessor,
LocalAddressAccessor,
RemoteAddressAccessor {
    private InetSocketAddress _localAddress;
    private InetSocketAddress _remoteAddress;
    private RestServer _restServer;
    private WildcardSubstitutes _wildcardSubstitutes;
    private String _realm;

    public BasicAuthEvent(InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2, HttpMethod httpMethod, Url url, WildcardSubstitutes wildcardSubstitutes, BasicAuthCredentials basicAuthCredentials, String string, RestServer restServer) {
        super(httpMethod, url, basicAuthCredentials);
        this._restServer = restServer;
        this._localAddress = inetSocketAddress;
        this._remoteAddress = inetSocketAddress2;
        this._wildcardSubstitutes = wildcardSubstitutes;
        this._realm = string;
    }

    public HttpMethod getAction() {
        return this.getHttpMethod();
    }

    public String[] getWildcardReplacements() {
        return this._wildcardSubstitutes.getWildcardReplacements();
    }

    public String getWildcardReplacementAt(int n) {
        return this._wildcardSubstitutes.getWildcardReplacementAt(n);
    }

    public String getWildcardReplacement(String string) {
        return this._wildcardSubstitutes.getWildcardReplacement(string);
    }

    public String[] getWildcardReplacements(String ... stringArray) {
        return this._wildcardSubstitutes.getWildcardReplacements(stringArray);
    }

    public String[] getWildcardReplacementsAt(int ... nArray) {
        return this._wildcardSubstitutes.getWildcardReplacementsAt(nArray);
    }

    public InetSocketAddress getRemoteAddress() {
        return this._remoteAddress;
    }

    public InetSocketAddress getLocalAddress() {
        return this._localAddress;
    }

    public String getRealm() {
        return this._realm;
    }

    public RestServer getSource() {
        return this._restServer;
    }

    public String[] getWildcardNames() {
        return this._wildcardSubstitutes.getWildcardNames();
    }
}

