/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.rest;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.refcodes.component.ConnectionStatus;
import org.refcodes.component.ConnectionStatusAccessor;
import org.refcodes.component.LinkComponent;
import org.refcodes.rest.BasicAuthEndpoint;
import org.refcodes.web.BasicAuthCredentials;
import org.refcodes.web.BasicAuthObserver;
import org.refcodes.web.BasicAuthResponse;
import org.refcodes.web.HttpMethod;
import org.refcodes.web.HttpMethodAccessor;

public class BasicAuthEndpointBuilder
implements BasicAuthEndpoint,
HttpMethodAccessor.HttpMethodProperty,
HttpMethodAccessor.HttpMethodBuilder<BasicAuthEndpointBuilder>,
LinkComponent.LinkComponentBuilder<BasicAuthEndpointBuilder>,
ConnectionStatusAccessor {
    private static Logger LOGGER = Logger.getLogger(BasicAuthEndpointBuilder.class.getName());
    protected BasicAuthObserver _requestObserver = null;
    protected HttpMethod _httpMethod = HttpMethod.GET;
    protected String _locatorPattern = null;
    protected ConnectionStatus _connectionStatus = ConnectionStatus.NONE;

    public BasicAuthEndpointBuilder() {
    }

    public BasicAuthEndpointBuilder(HttpMethod httpMethod, String string, BasicAuthObserver basicAuthObserver) {
        this._httpMethod = httpMethod;
        this._locatorPattern = string;
        this._requestObserver = basicAuthObserver;
    }

    public BasicAuthEndpointBuilder withHttpMethod(HttpMethod httpMethod) {
        this.setHttpMethod(httpMethod);
        return this;
    }

    public BasicAuthEndpointBuilder withLocatorPathPattern(String string) {
        this.setLocatorPathPattern(string);
        return this;
    }

    public BasicAuthEndpointBuilder withRequestObserver(BasicAuthObserver basicAuthObserver) {
        this.setRequestObserver(basicAuthObserver);
        return this;
    }

    public BasicAuthEndpointBuilder withOpen() throws IOException {
        this.open();
        return this;
    }

    public BasicAuthEndpointBuilder withClose() throws IOException {
        this.close();
        return this;
    }

    public BasicAuthEndpointBuilder withCloseQuietly() {
        this.closeQuietly();
        return this;
    }

    public BasicAuthEndpointBuilder withCloseIn(int n) {
        this.closeIn(n);
        return this;
    }

    public void setLocatorPathPattern(String string) {
        this._locatorPattern = string;
    }

    public void setHttpMethod(HttpMethod httpMethod) {
        this._httpMethod = httpMethod;
    }

    public void setRequestObserver(BasicAuthObserver basicAuthObserver) {
        this._requestObserver = basicAuthObserver;
    }

    public BasicAuthObserver getRequestObserver() {
        return this._requestObserver;
    }

    public BasicAuthResponse onBasicAuthRequest(InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2, HttpMethod httpMethod, String string, BasicAuthCredentials basicAuthCredentials, String string2) {
        if (this._connectionStatus == ConnectionStatus.OPENED) {
            return this._requestObserver.onBasicAuthRequest(inetSocketAddress, inetSocketAddress2, httpMethod, string, basicAuthCredentials, string2);
        }
        LOGGER.log(Level.WARNING, "Ignoring Basic-Auth <" + httpMethod + "> request for locator <" + string + "> as this rest endpoint is in status <" + this._connectionStatus + ">, you may not have opened it?");
        return BasicAuthResponse.BASIC_AUTH_SKIP;
    }

    public HttpMethod getHttpMethod() {
        return this._httpMethod;
    }

    @Override
    public String getLocatorPathPattern() {
        return this._locatorPattern;
    }

    public void open() throws IOException {
        this._connectionStatus = ConnectionStatus.OPENED;
    }

    public void close() throws IOException {
        this._connectionStatus = ConnectionStatus.CLOSED;
    }

    public ConnectionStatus getConnectionStatus() {
        return this._connectionStatus;
    }
}

