/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.rest;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.refcodes.controlflow.ControlFlowUtility;
import org.refcodes.data.Text;
import org.refcodes.rest.RestClient;
import org.refcodes.rest.RestRequestBuilder;
import org.refcodes.rest.RestRequestHandler;
import org.refcodes.rest.RestResponse;
import org.refcodes.rest.RestResponseConsumer;
import org.refcodes.rest.RestResponseHandler;
import org.refcodes.rest.RestResponseResult;
import org.refcodes.runtime.Correlation;
import org.refcodes.textual.VerboseTextBuilder;
import org.refcodes.web.AuthType;
import org.refcodes.web.BasicAuthCredentials;
import org.refcodes.web.FormMediaTypeFactory;
import org.refcodes.web.HtmlMediaTypeFactory;
import org.refcodes.web.HttpClientRequest;
import org.refcodes.web.HttpMethod;
import org.refcodes.web.HttpResponseException;
import org.refcodes.web.JsonMediaTypeFactory;
import org.refcodes.web.MediaType;
import org.refcodes.web.MediaTypeFactory;
import org.refcodes.web.MediaTypeFactoryLookup;
import org.refcodes.web.OauthToken;
import org.refcodes.web.RequestHeaderFields;
import org.refcodes.web.ResponseHeaderFields;
import org.refcodes.web.TextMediaTypeFactory;
import org.refcodes.web.Url;
import org.refcodes.web.XmlMediaTypeFactory;

public abstract class AbstractRestClient
implements RestClient {
    private Map<MediaType, MediaTypeFactory> _mediaTypeFacotries = new LinkedHashMap<MediaType, MediaTypeFactory>();
    private ExecutorService _executorService;
    private String _userAgent = this.getClass().getSimpleName() + "@" + Text.REFCODES_ORG.getText();
    private RestRequestHandler _requestHandler = null;
    private BasicAuthCredentials _basicAuthCredentials;
    private OauthToken _oauthToken = null;
    protected boolean _hasRequestCorrelation = true;
    protected boolean _hasSessionCorrelation = true;

    public AbstractRestClient(ExecutorService executorService) {
        this._executorService = executorService != null ? executorService : ControlFlowUtility.createCachedExecutorService((boolean)true);
        this.initMedaTypeFactories();
    }

    public AbstractRestClient() {
        this(ControlFlowUtility.createCachedExecutorService((boolean)true));
    }

    protected void initMedaTypeFactories() {
        this.addMediaTypeFactory((MediaTypeFactory)new JsonMediaTypeFactory());
        this.addMediaTypeFactory((MediaTypeFactory)new XmlMediaTypeFactory());
        this.addMediaTypeFactory((MediaTypeFactory)new FormMediaTypeFactory());
        this.addMediaTypeFactory((MediaTypeFactory)new TextMediaTypeFactory());
        this.addMediaTypeFactory((MediaTypeFactory)new HtmlMediaTypeFactory());
    }

    public BasicAuthCredentials getBasicAuthCredentials() {
        return this._basicAuthCredentials;
    }

    public void setBasicAuthCredentials(BasicAuthCredentials basicAuthCredentials) {
        this._basicAuthCredentials = basicAuthCredentials;
    }

    public void setOauthToken(OauthToken oauthToken) {
        this._oauthToken = oauthToken;
    }

    public OauthToken getOauthToken() {
        return this._oauthToken;
    }

    public void setRequestCorrelation(boolean bl) {
        this._hasRequestCorrelation = bl;
    }

    public boolean hasRequestCorrelation() {
        return this._hasRequestCorrelation;
    }

    public void setSessionCorrelation(boolean bl) {
        this._hasSessionCorrelation = bl;
    }

    public boolean hasSessionCorrelation() {
        return this._hasSessionCorrelation;
    }

    @Override
    public RestResponse doRequest(HttpMethod httpMethod, Url url, RequestHeaderFields requestHeaderFields, Object object, int n) throws HttpResponseException {
        RestRequestHandler restRequestHandler = this._requestHandler;
        if (restRequestHandler == null) {
            throw new IllegalStateException("Unable to process your request with HTTP-Method <" + httpMethod + "> for locator <" + url.toLocator() + "> and query fields <" + new VerboseTextBuilder().withElements((Map)url.getQueryFields()).toString() + "> as no <" + RestRequestHandler.class.getSimpleName() + "> has been registered via <doRestRequest(...)>, aborting!");
        }
        requestHeaderFields = this.preProcessHeaderFields(requestHeaderFields);
        return restRequestHandler.doRequest(new HttpClientRequest(httpMethod, url, requestHeaderFields, object, n, (MediaTypeFactoryLookup)this));
    }

    @Override
    public RestResponseHandler onResponse(HttpMethod httpMethod, Url url, RequestHeaderFields requestHeaderFields, Object object, int n, RestResponseConsumer restResponseConsumer) {
        requestHeaderFields = this.preProcessHeaderFields(requestHeaderFields);
        RestResponseHandler restResponseHandler = new RestResponseHandler(httpMethod, url, requestHeaderFields, object, n, restResponseConsumer, (MediaTypeFactoryLookup)this);
        this._executorService.execute(new RestResponseHandler.RestResponseHandlerDaemon(restResponseHandler, this._requestHandler, this));
        return restResponseHandler;
    }

    @Override
    public RestResponseResult onResponse(HttpMethod httpMethod, Url url, RequestHeaderFields requestHeaderFields, Object object, int n) {
        requestHeaderFields = this.preProcessHeaderFields(requestHeaderFields);
        RestResponseResult restResponseResult = new RestResponseResult(httpMethod, url, requestHeaderFields, object, n, (MediaTypeFactoryLookup)this);
        this._executorService.execute(new RestResponseResult.RestResponseResultDaemon(restResponseResult, this._requestHandler, this));
        return restResponseResult;
    }

    @Override
    public RestRequestBuilder buildRequest(HttpMethod httpMethod, Url url, RequestHeaderFields requestHeaderFields, Object object, int n) {
        requestHeaderFields = this.preProcessHeaderFields(requestHeaderFields);
        return new RestRequestBuilder(httpMethod, url, requestHeaderFields, object, n, this);
    }

    public synchronized boolean addMediaTypeFactory(MediaTypeFactory mediaTypeFactory) {
        boolean bl = false;
        for (MediaType mediaType : mediaTypeFactory.getMediaTypes()) {
            if (this._mediaTypeFacotries.containsKey(mediaType)) continue;
            this._mediaTypeFacotries.put(mediaType, mediaTypeFactory);
            bl = true;
        }
        return bl;
    }

    public MediaTypeFactory toMediaTypeFactory(MediaType mediaType) {
        return this._mediaTypeFacotries.get(mediaType);
    }

    public MediaType[] getFactoryMediaTypes() {
        return this._mediaTypeFacotries.keySet().toArray(new MediaType[this._mediaTypeFacotries.size()]);
    }

    public String getUserAgent() {
        return this._userAgent;
    }

    public void setUserAgent(String string) {
        this._userAgent = string;
    }

    protected void onRestRequest(RestRequestHandler restRequestHandler) {
        this._requestHandler = restRequestHandler;
    }

    protected RequestHeaderFields preProcessHeaderFields(RequestHeaderFields requestHeaderFields) {
        if (this._userAgent != null && (requestHeaderFields == null || requestHeaderFields.getUserAgent() == null)) {
            requestHeaderFields = requestHeaderFields != null ? requestHeaderFields : new RequestHeaderFields();
            requestHeaderFields.putUserAgent(this._userAgent);
        }
        if (this._oauthToken != null && (requestHeaderFields == null || requestHeaderFields.getAuthorization() == null)) {
            requestHeaderFields = requestHeaderFields != null ? requestHeaderFields : new RequestHeaderFields();
            requestHeaderFields.putAuthorization(AuthType.BEARER, this._oauthToken.getAccessToken());
        }
        if (this._basicAuthCredentials != null && (requestHeaderFields == null || requestHeaderFields.getBasicAuthCredentials() == null)) {
            requestHeaderFields = requestHeaderFields != null ? requestHeaderFields : new RequestHeaderFields();
            requestHeaderFields.putBasicAuthCredentials(this._basicAuthCredentials);
        }
        return requestHeaderFields;
    }

    protected void doRequestCorrelation(RequestHeaderFields requestHeaderFields) {
        if (this._hasRequestCorrelation) {
            String string = Correlation.REQUEST.pullId();
            requestHeaderFields.putRequestId(string);
        }
    }

    protected void doSessionCorrelation(RequestHeaderFields requestHeaderFields) {
        if (this._hasSessionCorrelation) {
            String string = Correlation.SESSION.pullId();
            requestHeaderFields.putSessionId(string);
        }
    }

    protected void doRequestCorrelation(ResponseHeaderFields responseHeaderFields) {
        String string;
        if (this._hasRequestCorrelation && (string = responseHeaderFields.getRequestId()) != null) {
            Correlation.REQUEST.setId(string);
        }
    }

    protected void doSessionCorrelation(ResponseHeaderFields responseHeaderFields) {
        String string;
        if (this._hasSessionCorrelation && (string = responseHeaderFields.getSessionId()) != null) {
            Correlation.SESSION.setId(string);
        }
    }
}

