/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.rest;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.refcodes.component.InitializeException;
import org.refcodes.component.LifecycleAutomatonImpl;
import org.refcodes.component.LifecycleStatus;
import org.refcodes.component.PauseException;
import org.refcodes.component.ResumeException;
import org.refcodes.component.StartException;
import org.refcodes.component.StopException;
import org.refcodes.data.Scheme;
import org.refcodes.mixin.AliasAccessor;
import org.refcodes.mixin.InstanceIdAccessor;
import org.refcodes.mixin.PortAccessor;
import org.refcodes.net.IpAddress;
import org.refcodes.net.IpAddressAccessor;
import org.refcodes.rest.HttpRegistrySidecar;
import org.refcodes.rest.HttpRegistryUrlAccessor;
import org.refcodes.rest.HttpServerDescriptor;
import org.refcodes.rest.HttpServerDescriptorAccessor;
import org.refcodes.rest.PingPathAccessor;
import org.refcodes.rest.RestRequestConsumer;
import org.refcodes.security.TrustStoreDescriptor;
import org.refcodes.security.TrustStoreDescriptorAccessor;
import org.refcodes.web.HostAccessor;
import org.refcodes.web.SchemeAccessor;
import org.refcodes.web.Url;
import org.refcodes.web.VirtualHostAccessor;

public abstract class AbstractHttpRegistrySidecar<DESC extends HttpServerDescriptor, B extends HttpRegistrySidecar<DESC, B>>
implements HttpRegistrySidecar<DESC, B> {
    protected LifecycleAutomatonImpl.ManualLifecycleAutomatonImpl _lifeCycleAutomaton = new LifecycleAutomatonImpl.ManualLifecycleAutomatonImpl();
    private Url _serviceRegistryUrl;
    private DESC _serverDescriptor;
    private TrustStoreDescriptor _storeDescriptor;
    private String _alias;
    private String _instanceId;
    private String _host;
    private String _virtualHost;
    private int[] _ipAddress;
    private String _pingPath;
    protected RestRequestConsumer _pingRequestObserver = null;

    public boolean isRunning() {
        return this._lifeCycleAutomaton.isRunning();
    }

    public boolean isInitialized() {
        return this._lifeCycleAutomaton.isInitialized();
    }

    public LifecycleStatus getLifecycleStatus() {
        return this._lifeCycleAutomaton.getLifecycleStatus();
    }

    @Override
    public void pause() throws PauseException {
        this._lifeCycleAutomaton.pause();
    }

    @Override
    public void stop() throws StopException {
        this._lifeCycleAutomaton.stop();
    }

    @Override
    public void start() throws StartException {
        this._lifeCycleAutomaton.start();
    }

    @Override
    public void resume() throws ResumeException {
        this._lifeCycleAutomaton.resume();
    }

    @Override
    public void initialize() throws InitializeException {
        this._lifeCycleAutomaton.initialize();
    }

    public boolean isStoppable() {
        return this._lifeCycleAutomaton.isStoppable();
    }

    public boolean isPausable() {
        return this._lifeCycleAutomaton.isPausable();
    }

    public boolean isStartable() {
        return this._lifeCycleAutomaton.isStartable();
    }

    public boolean isResumable() {
        return this._lifeCycleAutomaton.isResumable();
    }

    public boolean isStopped() {
        return this._lifeCycleAutomaton.isStopped();
    }

    public boolean isPaused() {
        return this._lifeCycleAutomaton.isPaused();
    }

    public boolean isInitalizable() {
        return this._lifeCycleAutomaton.isInitalizable();
    }

    @Override
    public void destroy() {
        this._lifeCycleAutomaton.destroy();
    }

    public boolean isDestroyable() {
        return this._lifeCycleAutomaton.isDestroyable();
    }

    public boolean isDestroyed() {
        return this._lifeCycleAutomaton.isDestroyed();
    }

    public void setInstanceId(String string) {
        this._instanceId = string;
    }

    public String getInstanceId() {
        return this._instanceId;
    }

    public void setHost(String string) {
        this._host = string;
    }

    public String getHost() {
        return this._host;
    }

    public String getVirtualHost() {
        return this._virtualHost;
    }

    public void setVirtualHost(String string) {
        this._virtualHost = string;
    }

    public int[] getIpAddress() {
        return this._ipAddress;
    }

    public void setIpAddress(int[] nArray) {
        this._ipAddress = nArray;
    }

    public TrustStoreDescriptor getTrustStoreDescriptor() {
        return this._storeDescriptor;
    }

    public void setTrustStoreDescriptor(TrustStoreDescriptor trustStoreDescriptor) {
        this._storeDescriptor = trustStoreDescriptor;
    }

    @Override
    public DESC getHttpServerDescriptor() {
        return this._serverDescriptor;
    }

    @Override
    public void setHttpServerDescriptor(DESC DESC) {
        this._serverDescriptor = DESC;
    }

    @Override
    public Url getHttpRegistryUrl() {
        return this._serviceRegistryUrl;
    }

    @Override
    public void setHttpRegistryUrl(Url url) {
        this._serviceRegistryUrl = url;
    }

    public String getAlias() {
        return this._alias;
    }

    public void setAlias(String string) {
        this._alias = string;
    }

    @Override
    public String getPingPath() {
        return this._pingPath;
    }

    @Override
    public void setPingPath(String string) {
        this._pingPath = string;
    }

    protected static String toHost(String string, HostAccessor.HostProperty hostProperty) throws UnknownHostException {
        if (string != null) {
            hostProperty.setHost(string);
        } else {
            string = hostProperty.getHost();
            if (string == null) {
                string = InetAddress.getLocalHost().getHostName();
                hostProperty.setHost(string);
            }
        }
        return string;
    }

    protected static String toVirtualHost(String string, VirtualHostAccessor.VirtualHostProperty virtualHostProperty) {
        if (string != null) {
            virtualHostProperty.setVirtualHost(string);
        } else {
            string = virtualHostProperty.getVirtualHost();
        }
        return string;
    }

    protected static int[] toIpAddress(int[] nArray, IpAddressAccessor.IpAddressProperty ipAddressProperty) throws IOException {
        if (nArray != null) {
            ipAddressProperty.setIpAddress(nArray);
        } else {
            nArray = IpAddress.toHostIpAddress();
            ipAddressProperty.setIpAddress(nArray);
        }
        return nArray;
    }

    protected static String toAlias(String string, AliasAccessor.AliasProperty aliasProperty) {
        if (string != null) {
            aliasProperty.setAlias(string);
        } else {
            string = aliasProperty.getAlias();
        }
        return string;
    }

    protected static Scheme toScheme(Scheme scheme, SchemeAccessor.SchemeProperty schemeProperty) {
        if (scheme != null) {
            schemeProperty.setScheme(scheme);
        } else {
            scheme = schemeProperty.getScheme();
        }
        return scheme;
    }

    protected static int toPort(int n, PortAccessor.PortProperty portProperty) {
        if (n != -1) {
            portProperty.setPort(n);
        } else {
            n = portProperty.getPort();
        }
        return n;
    }

    protected static String toInstanceId(String string, String string2, InstanceIdAccessor.InstanceIdProperty instanceIdProperty) {
        if (string != null) {
            instanceIdProperty.setInstanceId(string);
        } else {
            string = instanceIdProperty.getInstanceId();
            if (string == null) {
                string = string2;
                instanceIdProperty.setInstanceId(string);
            }
        }
        return string;
    }

    protected static String toPingPath(String string, String string2, PingPathAccessor.PingPathProperty pingPathProperty) {
        if (string != null) {
            pingPathProperty.setPingPath(string);
        } else {
            string = pingPathProperty.getPingPath();
            if (string == null) {
                string = string2;
                pingPathProperty.setPingPath(string);
            }
        }
        return string;
    }

    protected static TrustStoreDescriptor toTrustStoreDescriptor(TrustStoreDescriptor trustStoreDescriptor, TrustStoreDescriptorAccessor.TrustStoreDescriptorProperty trustStoreDescriptorProperty) {
        if (trustStoreDescriptor != null) {
            trustStoreDescriptorProperty.setTrustStoreDescriptor(trustStoreDescriptor);
        } else {
            trustStoreDescriptor = trustStoreDescriptorProperty.getTrustStoreDescriptor();
        }
        return trustStoreDescriptor;
    }

    protected static Url toHttpRegistryUrl(Url url, HttpRegistryUrlAccessor.HttpRegistryUrlProperty httpRegistryUrlProperty) {
        if (url != null) {
            httpRegistryUrlProperty.setHttpRegistryUrl(url);
        } else {
            url = httpRegistryUrlProperty.getHttpRegistryUrl();
        }
        return url;
    }

    protected static <DESC extends HttpServerDescriptor> DESC toHttpServerDescriptor(DESC DESC, HttpServerDescriptorAccessor.HttpServerDescriptorProperty<DESC> httpServerDescriptorProperty) {
        if (DESC != null) {
            httpServerDescriptorProperty.setHttpServerDescriptor(DESC);
        } else {
            DESC = httpServerDescriptorProperty.getHttpServerDescriptor();
        }
        return DESC;
    }
}

