/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.properties;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.refcodes.exception.IntegrityException;
import org.refcodes.properties.Properties;
import org.refcodes.properties.PropertiesBuilderImpl;
import org.refcodes.properties.PropertiesPrecedence;

public class PropertiesPrecedenceComposite
implements PropertiesPrecedence {
    protected List<Properties> _properties;

    public PropertiesPrecedenceComposite(Properties ... propertiesArray) {
        this._properties = new ArrayList<Properties>(Arrays.asList(propertiesArray));
    }

    public PropertiesPrecedenceComposite(List<Properties> list) {
        this._properties = list;
    }

    @Override
    public boolean containsProperties(Properties properties) {
        return this._properties.contains(properties);
    }

    public Object toDataStructure(String string) {
        PropertiesBuilderImpl propertiesBuilderImpl = new PropertiesBuilderImpl();
        for (int i = this._properties.size() - 1; i >= 0; --i) {
            propertiesBuilderImpl.insert(this._properties.get(i).retrieveFrom(string));
        }
        return propertiesBuilderImpl.toDataStructure();
    }

    public boolean containsKey(Object object) {
        for (int i = 0; i < this._properties.size(); ++i) {
            if (!this._properties.get(i).containsKey(object)) continue;
            return true;
        }
        return false;
    }

    public String get(Object object) {
        for (int i = 0; i < this._properties.size(); ++i) {
            Properties properties = this._properties.get(i);
            if (!properties.containsKey(object)) continue;
            return (String)properties.get(object);
        }
        return null;
    }

    public Set<String> keySet() {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (int i = 0; i < this._properties.size(); ++i) {
            linkedHashSet.addAll(this._properties.get(i).keySet());
        }
        return linkedHashSet;
    }

    public Collection<String> values() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this._properties.size(); ++i) {
            arrayList.addAll(this._properties.get(i).values());
        }
        return arrayList;
    }

    public int size() {
        int n = 0;
        for (int i = 0; i < this._properties.size(); ++i) {
            n += this._properties.get(i).size();
        }
        return n;
    }

    public boolean isEmpty() {
        for (int i = 0; i < this._properties.size(); ++i) {
            if (this._properties.get(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public char getDelimiter() {
        Character c = null;
        for (int i = 0; i < this._properties.size(); ++i) {
            char c2 = this._properties.get(i).getDelimiter();
            if (c != null && !c.equals(Character.valueOf(c2))) {
                throw new IntegrityException("The encapsulated properties define different ambigous delimiter <" + c + "> and <" + c2 + "> defintions.");
            }
            c = Character.valueOf(c2);
        }
        return c.charValue();
    }

    @Override
    public Properties retrieveFrom(String string) {
        PropertiesBuilderImpl propertiesBuilderImpl = new PropertiesBuilderImpl();
        for (int i = this._properties.size() - 1; i >= 0; --i) {
            propertiesBuilderImpl.insert(this._properties.get(i).retrieveFrom(string));
        }
        return propertiesBuilderImpl;
    }

    @Override
    public Properties retrieveTo(String string) {
        PropertiesBuilderImpl propertiesBuilderImpl = new PropertiesBuilderImpl();
        for (int i = this._properties.size() - 1; i >= 0; --i) {
            propertiesBuilderImpl.insert(this._properties.get(i).retrieveTo(string));
        }
        return propertiesBuilderImpl;
    }
}

