/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.properties;

import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;
import org.refcodes.data.Text;
import org.refcodes.properties.PropertiesImpl;
import org.refcodes.struct.CanonicalMap;
import org.refcodes.struct.PathMap;
import org.refcodes.struct.Property;
import org.refcodes.struct.Relation;

public interface Properties
extends CanonicalMap {
    public static final String DEFAULT_COMMENT = "Generated by <" + Text.REFCODES_ORG + "> (http://www.refcodes.org)";

    default public boolean containsValue(Object object) {
        return this.values().contains(object);
    }

    default public char getDelimiter() {
        return DELIMITER;
    }

    default public char getAnnotator() {
        return ANNOTATOR;
    }

    default public Properties getDirAt(int n) {
        return this.getDirAt(this.getRootPath(), n);
    }

    default public Properties getDirAt(String string, int n) {
        return this.retrieveFrom(this.toPath(new String[]{string, "" + n}));
    }

    default public Properties getDirAt(Collection<?> collection, int n) {
        return this.getDirAt(this.toPath(collection), n);
    }

    default public Properties getDirAt(Object object, int n) {
        return this.getDirAt(this.toPath(object), n);
    }

    default public Properties getDirAt(Object[] objectArray, int n) {
        return this.getDirAt(this.toPath(objectArray), n);
    }

    default public Properties getDirAt(String[] stringArray, int n) {
        return this.getDirAt(this.toPath(stringArray), n);
    }

    default public Class<String> getType() {
        return String.class;
    }

    default public Properties query(Collection<?> collection) {
        return this.query(this.toPath(collection));
    }

    default public Properties query(Object ... objectArray) {
        return this.query(this.toPath(objectArray));
    }

    default public Properties query(String string) {
        return new PropertiesImpl(super.query(string));
    }

    default public Properties query(Pattern pattern) {
        return new PropertiesImpl(super.query(pattern));
    }

    default public Properties query(String ... stringArray) {
        return this.query(this.toPath(stringArray));
    }

    default public Properties queryBetween(Collection<?> collection, Collection<?> collection2, Collection<?> collection3) {
        return this.queryBetween(this.toPath(collection), this.toPath(collection2), this.toPath(collection3));
    }

    default public Properties queryBetween(Object object, Object object2, Object object3) {
        return this.queryBetween(this.toPath(object), this.toPath(object2), this.toPath(object3));
    }

    default public Properties queryBetween(Object[] objectArray, Object[] objectArray2, Object[] objectArray3) {
        return this.queryBetween(this.toPath(objectArray), this.toPath(objectArray2), this.toPath(objectArray3));
    }

    default public Properties queryBetween(String string, String string2, String string3) {
        return new PropertiesImpl(super.queryBetween(string, string2, string3));
    }

    default public Properties queryBetween(String[] stringArray, String[] stringArray2, String[] stringArray3) {
        return this.queryBetween(this.toPath(stringArray), this.toPath(stringArray2), this.toPath(stringArray3));
    }

    default public Properties queryFrom(Collection<?> collection, Collection<?> collection2) {
        return this.queryFrom(this.toPath(collection), this.toPath(collection2));
    }

    default public Properties queryFrom(Object object, Object object2) {
        return this.queryFrom(this.toPath(object), this.toPath(object2));
    }

    default public Properties queryFrom(Object[] objectArray, Object[] objectArray2) {
        return this.queryFrom(this.toPath(objectArray), this.toPath(objectArray2));
    }

    default public Properties queryFrom(String string, String string2) {
        return new PropertiesImpl(super.queryFrom(string, string2));
    }

    default public Properties queryFrom(Pattern pattern, String string) {
        return new PropertiesImpl(super.queryFrom(pattern, string));
    }

    default public Properties queryFrom(String[] stringArray, String[] stringArray2) {
        return this.queryFrom(this.toPath(stringArray), this.toPath(stringArray2));
    }

    default public Properties queryTo(Collection<?> collection, String string) {
        return this.queryTo(this.toPath(collection), this.toPath(string));
    }

    default public Properties queryTo(Object object, String string) {
        return this.queryTo(this.toPath(object), this.toPath(string));
    }

    default public Properties queryTo(Object[] objectArray, String string) {
        return this.queryTo(this.toPath(objectArray), this.toPath(string));
    }

    default public Properties queryTo(String string, String string2) {
        return new PropertiesImpl(super.queryTo(string, string2));
    }

    default public Properties queryTo(Pattern pattern, String string) {
        return new PropertiesImpl(super.queryTo(pattern, string));
    }

    default public Properties queryTo(String[] stringArray, String string) {
        return this.queryTo(this.toPath(stringArray), this.toPath(string));
    }

    default public Properties retrieveBetween(Collection<?> collection, Collection<?> collection2) {
        return this.retrieveBetween(this.toPath(collection), this.toPath(collection2));
    }

    default public Properties retrieveBetween(Object object, Object object2) {
        return this.retrieveBetween(this.toPath(object), this.toPath(object2));
    }

    default public Properties retrieveBetween(Object[] objectArray, Object[] objectArray2) {
        return this.retrieveBetween(this.toPath(objectArray), this.toPath(objectArray2));
    }

    default public Properties retrieveBetween(String string, String string2) {
        Properties properties = this.retrieveFrom(string);
        return properties.retrieveTo(string2);
    }

    default public Properties retrieveBetween(String[] stringArray, String[] stringArray2) {
        return this.retrieveBetween(this.toPath(stringArray), this.toPath(stringArray2));
    }

    default public Properties retrieveFrom(Collection<?> collection) {
        return this.retrieveFrom(this.toPath(collection));
    }

    default public Properties retrieveFrom(Object object) {
        return this.retrieveFrom(this.toPath(object));
    }

    default public Properties retrieveFrom(Object ... objectArray) {
        return this.retrieveFrom(this.toPath(objectArray));
    }

    public Properties retrieveFrom(String var1);

    default public Properties retrieveFrom(String ... stringArray) {
        return this.retrieveFrom(this.toPath(stringArray));
    }

    default public Properties getDir(Collection<?> collection) {
        return this.getDir(this.toPath(collection));
    }

    default public Properties getDir(Object object) {
        return this.getDir(this.toPath(object));
    }

    default public Properties getDir(Object ... objectArray) {
        return this.getDir(this.toPath(objectArray));
    }

    default public Properties getDir(String string) {
        return this.retrieveFrom(string);
    }

    default public Properties getDir(String ... stringArray) {
        return this.getDir(this.toPath(stringArray));
    }

    default public Properties[] getDirs(Collection<?> collection) {
        return this.getDirs(this.toPath(collection));
    }

    default public Properties[] getDirs(Object object) {
        return this.getDirs(this.toPath(object));
    }

    default public Properties[] getDirs(Object ... objectArray) {
        return this.getDirs(this.toPath(objectArray));
    }

    default public Properties[] getDirs(String string) {
        Properties[] propertiesArray;
        if (this.isIndexDir(string)) {
            int[] nArray = this.getDirIndexes(string);
            propertiesArray = new Properties[nArray[nArray.length - 1] + 1];
            for (int n : nArray) {
                propertiesArray[nArray[n]] = this.getDirAt(string, nArray[n]);
            }
        } else {
            propertiesArray = new Properties[]{this.getDir(string)};
        }
        return propertiesArray;
    }

    default public Properties[] getDirs(String ... stringArray) {
        return this.getDirs(this.toPath(stringArray));
    }

    default public Properties retrieveTo(Collection<?> collection) {
        return this.retrieveTo(this.toPath(collection));
    }

    default public Properties retrieveTo(Object object) {
        return this.retrieveTo(this.toPath(object));
    }

    default public Properties retrieveTo(Object ... objectArray) {
        return this.retrieveTo(this.toPath(objectArray));
    }

    public Properties retrieveTo(String var1);

    default public Properties retrieveTo(String ... stringArray) {
        return this.retrieveTo(this.toPath(stringArray));
    }

    public static interface PropertiesBuilder
    extends CanonicalMap.CanonicalMapBuilder,
    MutableProperties {
        default public PropertiesBuilder withPut(Collection<?> collection, String string) {
            this.put(collection, string);
            return this;
        }

        default public PropertiesBuilder withPut(Object[] objectArray, String string) throws NumberFormatException {
            this.put(objectArray, string);
            return this;
        }

        default public PropertiesBuilder withPut(Relation<String, String> relation) {
            this.put(relation);
            return this;
        }

        default public PropertiesBuilder withPut(String string, String string2) {
            this.put(string, string2);
            return this;
        }

        default public PropertiesBuilder withPut(Property property) {
            this.put(property);
            return this;
        }

        default public PropertiesBuilder withPut(String[] stringArray, String string) {
            this.put(stringArray, string);
            return this;
        }

        default public PropertiesBuilder withPutBoolean(Collection<?> collection, Boolean bl) {
            this.putBoolean(collection, bl);
            return this;
        }

        default public PropertiesBuilder withPutBoolean(Object object, Boolean bl) {
            this.putBoolean(object, bl);
            return this;
        }

        default public PropertiesBuilder withPutBoolean(Object[] objectArray, Boolean bl) {
            this.putBoolean(objectArray, bl);
            return this;
        }

        default public PropertiesBuilder withPutBoolean(String string, Boolean bl) {
            this.putBoolean(string, bl);
            return this;
        }

        default public PropertiesBuilder withPutBoolean(String[] stringArray, Boolean bl) {
            this.putBoolean(stringArray, bl);
            return this;
        }

        default public PropertiesBuilder withPutByte(Collection<?> collection, Byte by) {
            this.putByte(collection, by);
            return this;
        }

        default public PropertiesBuilder withPutByte(Object object, Byte by) {
            this.putByte(object, by);
            return this;
        }

        default public PropertiesBuilder withPutByte(Object[] objectArray, Byte by) {
            this.putByte(objectArray, by);
            return this;
        }

        default public PropertiesBuilder withPutByte(String string, Byte by) {
            this.putByte(string, by);
            return this;
        }

        default public PropertiesBuilder withPutByte(String[] stringArray, Byte by) {
            this.putByte(stringArray, by);
            return this;
        }

        default public PropertiesBuilder withPutChar(Collection<?> collection, Character c) {
            this.putChar(collection, c);
            return this;
        }

        default public PropertiesBuilder withPutChar(Object object, Character c) {
            this.putChar(object, c);
            return this;
        }

        default public PropertiesBuilder withPutChar(Object[] objectArray, Character c) {
            this.putChar(objectArray, c);
            return this;
        }

        default public PropertiesBuilder withPutChar(String string, Character c) {
            this.putChar(string, c);
            return this;
        }

        default public PropertiesBuilder withPutChar(String[] stringArray, Character c) {
            this.putChar(stringArray, c);
            return this;
        }

        default public <C> PropertiesBuilder withPutClass(Collection<?> collection, Class<C> clazz) {
            this.putClass(collection, clazz);
            return this;
        }

        default public <C> PropertiesBuilder withPutClass(Object object, Class<C> clazz) {
            this.putClass(object, clazz);
            return this;
        }

        default public <C> PropertiesBuilder withPutClass(Object[] objectArray, Class<C> clazz) {
            this.putClass(objectArray, clazz);
            return this;
        }

        default public <C> PropertiesBuilder withPutClass(String string, Class<C> clazz) {
            this.putClass(string, clazz);
            return this;
        }

        default public <C> PropertiesBuilder withPutClass(String[] stringArray, Class<C> clazz) {
            this.putClass(stringArray, clazz);
            return this;
        }

        default public PropertiesBuilder withPutDouble(Collection<?> collection, Double d) {
            this.putDouble(collection, d);
            return this;
        }

        default public PropertiesBuilder withPutDouble(Object object, Double d) {
            this.putDouble(object, d);
            return this;
        }

        default public PropertiesBuilder withPutDouble(Object[] objectArray, Double d) {
            this.putDouble(objectArray, d);
            return this;
        }

        default public PropertiesBuilder withPutDouble(String string, Double d) {
            this.putDouble(string, d);
            return this;
        }

        default public PropertiesBuilder withPutDouble(String[] stringArray, Double d) {
            this.putDouble(stringArray, d);
            return this;
        }

        default public <E extends Enum<E>> PropertiesBuilder withPutEnum(Collection<?> collection, E e) {
            this.putEnum(collection, e);
            return this;
        }

        default public <E extends Enum<E>> PropertiesBuilder withPutEnum(Object object, E e) {
            this.putEnum(object, e);
            return this;
        }

        default public <E extends Enum<E>> PropertiesBuilder withPutEnum(Object[] objectArray, E e) {
            this.putEnum(objectArray, e);
            return this;
        }

        default public <E extends Enum<E>> PropertiesBuilder withPutEnum(String string, E e) {
            this.putEnum(string, e);
            return this;
        }

        default public <E extends Enum<E>> PropertiesBuilder withPutEnum(String[] stringArray, E e) {
            this.putEnum(stringArray, e);
            return this;
        }

        default public PropertiesBuilder withPutFloat(Collection<?> collection, Float f) {
            this.putFloat(collection, f);
            return this;
        }

        default public PropertiesBuilder withPutFloat(Object object, Float f) {
            this.putFloat(object, f);
            return this;
        }

        default public PropertiesBuilder withPutFloat(Object[] objectArray, Float f) {
            this.putFloat(objectArray, f);
            return this;
        }

        default public PropertiesBuilder withPutFloat(String string, Float f) {
            this.putFloat(string, f);
            return this;
        }

        default public PropertiesBuilder withPutFloat(String[] stringArray, Float f) {
            this.putFloat(stringArray, f);
            return this;
        }

        default public PropertiesBuilder withPutInt(Collection<?> collection, Integer n) {
            this.putInt(collection, n);
            return this;
        }

        default public PropertiesBuilder withPutInt(Object object, Integer n) {
            this.putInt(object, n);
            return this;
        }

        default public PropertiesBuilder withPutInt(Object[] objectArray, Integer n) {
            this.putInt(objectArray, n);
            return this;
        }

        default public PropertiesBuilder withPutInt(String string, Integer n) {
            this.putInt(string, n);
            return this;
        }

        default public PropertiesBuilder withPutInt(String[] stringArray, Integer n) {
            this.putInt(stringArray, n);
            return this;
        }

        default public PropertiesBuilder withPutLong(Collection<?> collection, Long l) {
            this.putLong(collection, l);
            return this;
        }

        default public PropertiesBuilder withPutLong(Object object, Long l) {
            this.putLong(object, l);
            return this;
        }

        default public PropertiesBuilder withPutLong(Object[] objectArray, Long l) {
            this.putLong(objectArray, l);
            return this;
        }

        default public PropertiesBuilder withPutLong(String string, Long l) {
            this.putLong(string, l);
            return this;
        }

        default public PropertiesBuilder withPutLong(String[] stringArray, Long l) {
            this.putLong(stringArray, l);
            return this;
        }

        default public PropertiesBuilder withPutShort(Collection<?> collection, Short s) {
            this.putShort(collection, s);
            return this;
        }

        default public PropertiesBuilder withPutShort(Object object, Short s) {
            this.putShort(object, s);
            return this;
        }

        default public PropertiesBuilder withPutShort(Object[] objectArray, Short s) {
            this.putShort(objectArray, s);
            return this;
        }

        default public PropertiesBuilder withPutShort(String string, Short s) {
            this.putShort(string, s);
            return this;
        }

        default public PropertiesBuilder withPutShort(String[] stringArray, Short s) {
            this.putShort(stringArray, s);
            return this;
        }

        default public PropertiesBuilder withPutString(Collection<?> collection, String string) {
            this.putString(collection, string);
            return this;
        }

        default public PropertiesBuilder withPutString(Object object, String string) {
            this.putString(object, string);
            return this;
        }

        default public PropertiesBuilder withPutString(Object[] objectArray, String string) {
            this.putString(objectArray, string);
            return this;
        }

        default public PropertiesBuilder withPutString(String string, String string2) {
            this.putString(string, string2);
            return this;
        }

        default public PropertiesBuilder withPutString(String[] stringArray, String string) {
            this.putString(stringArray, string);
            return this;
        }

        default public PropertiesBuilder withInsert(Object object) {
            this.insert(object);
            return this;
        }

        default public PropertiesBuilder withInsert(PathMap<String> pathMap) {
            this.insert(pathMap);
            return this;
        }

        default public PropertiesBuilder withInsertBetween(Collection<?> collection, Object object, Collection<?> collection2) {
            this.insertBetween(collection, object, collection2);
            return this;
        }

        default public PropertiesBuilder withInsertBetween(Collection<?> collection, PathMap<String> pathMap, Collection<?> collection2) {
            this.insertBetween(collection, pathMap, collection2);
            return this;
        }

        default public PropertiesBuilder withInsertBetween(Object object, Object object2, Object object3) {
            this.insertBetween(object, object2, object3);
            return this;
        }

        default public PropertiesBuilder withInsertBetween(Object object, PathMap<String> pathMap, Object object2) {
            this.insertBetween(object, pathMap, object2);
            return this;
        }

        default public PropertiesBuilder withInsertBetween(Object[] objectArray, Object object, Object[] objectArray2) {
            this.insertBetween(objectArray, object, objectArray2);
            return this;
        }

        default public PropertiesBuilder withInsertBetween(Object[] objectArray, PathMap<String> pathMap, Object[] objectArray2) {
            this.insertBetween(objectArray, pathMap, objectArray2);
            return this;
        }

        default public PropertiesBuilder withInsertBetween(String string, Object object, String string2) {
            this.insertBetween(string, object, string2);
            return this;
        }

        default public PropertiesBuilder withInsertBetween(String string, PathMap<String> pathMap, String string2) {
            this.insertBetween(string, pathMap, string2);
            return this;
        }

        default public PropertiesBuilder withInsertBetween(String[] stringArray, Object object, String[] stringArray2) {
            this.insertBetween(stringArray, object, stringArray2);
            return this;
        }

        default public PropertiesBuilder withInsertBetween(String[] stringArray, PathMap<String> pathMap, String[] stringArray2) {
            this.insertBetween(stringArray, pathMap, stringArray2);
            return this;
        }

        default public PropertiesBuilder withInsertFrom(Object object, Collection<?> collection) {
            this.insertFrom(object, collection);
            return this;
        }

        default public PropertiesBuilder withInsertFrom(Object object, Object object2) {
            this.insertFrom(object, object2);
            return this;
        }

        default public PropertiesBuilder withInsertFrom(Object object, Object ... objectArray) {
            this.withInsertFrom(object, objectArray);
            return this;
        }

        default public PropertiesBuilder withInsertFrom(Object object, String string) {
            this.insertFrom(object, string);
            return this;
        }

        default public PropertiesBuilder withInsertFrom(Object object, String ... stringArray) {
            this.insertFrom(object, stringArray);
            return this;
        }

        default public PropertiesBuilder withInsertFrom(PathMap<String> pathMap, Collection<?> collection) {
            this.insertFrom(pathMap, collection);
            return this;
        }

        default public PropertiesBuilder withInsertFrom(PathMap<String> pathMap, Object object) {
            this.insertFrom(pathMap, object);
            return this;
        }

        default public PropertiesBuilder withInsertFrom(PathMap<String> pathMap, Object ... objectArray) {
            this.withInsertFrom((PathMap)pathMap, objectArray);
            return this;
        }

        default public PropertiesBuilder withInsertFrom(PathMap<String> pathMap, String string) {
            this.insertFrom(pathMap, string);
            return this;
        }

        default public PropertiesBuilder withInsertFrom(PathMap<String> pathMap, String ... stringArray) {
            this.insertFrom(pathMap, stringArray);
            return this;
        }

        default public PropertiesBuilder withInsertTo(Collection<?> collection, Object object) {
            this.insertTo(collection, object);
            return this;
        }

        default public PropertiesBuilder withInsertTo(Collection<?> collection, PathMap<String> pathMap) {
            this.insertTo(collection, pathMap);
            return this;
        }

        default public PropertiesBuilder withInsertTo(Object object, Object object2) {
            this.insertTo(object, object2);
            return this;
        }

        default public PropertiesBuilder withInsertTo(Object object, PathMap<String> pathMap) {
            this.insertTo(object, pathMap);
            return this;
        }

        default public PropertiesBuilder withInsertTo(Object[] objectArray, Object object) {
            this.insertTo(objectArray, object);
            return this;
        }

        default public PropertiesBuilder withInsertTo(Object[] objectArray, PathMap<String> pathMap) {
            this.insertTo(objectArray, pathMap);
            return this;
        }

        default public PropertiesBuilder withInsertTo(String string, Object object) {
            this.insertTo(string, object);
            return this;
        }

        default public PropertiesBuilder withInsertTo(String string, PathMap<String> pathMap) {
            this.insertTo(string, pathMap);
            return this;
        }

        default public PropertiesBuilder withInsertTo(String[] stringArray, Object object) {
            this.insertTo(stringArray, object);
            return this;
        }

        default public PropertiesBuilder withInsertTo(String[] stringArray, PathMap<String> pathMap) {
            this.insertTo(stringArray, pathMap);
            return this;
        }

        default public PropertiesBuilder withMerge(Object object) {
            this.merge(object);
            return this;
        }

        default public PropertiesBuilder withMerge(PathMap<String> pathMap) {
            this.merge(pathMap);
            return this;
        }

        default public PropertiesBuilder withMergeBetween(Collection<?> collection, Object object, Collection<?> collection2) {
            this.mergeBetween(collection, object, collection2);
            return this;
        }

        default public PropertiesBuilder withMergeBetween(Collection<?> collection, PathMap<String> pathMap, Collection<?> collection2) {
            this.mergeBetween(collection, pathMap, collection2);
            return this;
        }

        default public PropertiesBuilder withMergeBetween(Object object, Object object2, Object object3) {
            this.mergeBetween(object, object2, object3);
            return this;
        }

        default public PropertiesBuilder withMergeBetween(Object object, PathMap<String> pathMap, Object object2) {
            this.mergeBetween(object, pathMap, object2);
            return this;
        }

        default public PropertiesBuilder withMergeBetween(Object[] objectArray, Object object, Object[] objectArray2) {
            this.mergeBetween(objectArray, object, objectArray2);
            return this;
        }

        default public PropertiesBuilder withMergeBetween(Object[] objectArray, PathMap<String> pathMap, Object[] objectArray2) {
            this.mergeBetween(objectArray, objectArray2, objectArray2);
            return this;
        }

        default public PropertiesBuilder withMergeBetween(String string, Object object, String string2) {
            this.mergeBetween(string, object, string2);
            return this;
        }

        default public PropertiesBuilder withMergeBetween(String string, PathMap<String> pathMap, String string2) {
            this.mergeBetween(string, pathMap, string2);
            return this;
        }

        default public PropertiesBuilder withMergeBetween(String[] stringArray, Object object, String[] stringArray2) {
            this.mergeBetween(stringArray, object, stringArray2);
            return this;
        }

        default public PropertiesBuilder withMergeBetween(String[] stringArray, PathMap<String> pathMap, String[] stringArray2) {
            this.mergeBetween(stringArray, pathMap, stringArray2);
            return this;
        }

        default public PropertiesBuilder withMergeFrom(Object object, Collection<?> collection) {
            this.mergeFrom(object, collection);
            return this;
        }

        default public PropertiesBuilder withMergeFrom(Object object, Object object2) {
            this.mergeFrom(object, object2);
            return this;
        }

        default public PropertiesBuilder withMergeFrom(Object object, Object ... objectArray) {
            this.mergeFrom(object, objectArray);
            return this;
        }

        default public PropertiesBuilder withMergeFrom(Object object, String string) {
            this.mergeFrom(object, string);
            return this;
        }

        default public PropertiesBuilder withMergeFrom(Object object, String ... stringArray) {
            this.mergeFrom(object, stringArray);
            return this;
        }

        default public PropertiesBuilder withMergeFrom(PathMap<String> pathMap, Collection<?> collection) {
            this.mergeFrom(pathMap, collection);
            return this;
        }

        default public PropertiesBuilder withMergeFrom(PathMap<String> pathMap, Object object) {
            this.mergeFrom(pathMap, object);
            return this;
        }

        default public PropertiesBuilder withMergeFrom(PathMap<String> pathMap, Object ... objectArray) {
            this.mergeFrom(pathMap, objectArray);
            return this;
        }

        default public PropertiesBuilder withMergeFrom(PathMap<String> pathMap, String string) {
            this.mergeFrom(pathMap, string);
            return this;
        }

        default public PropertiesBuilder withMergeFrom(PathMap<String> pathMap, String ... stringArray) {
            this.mergeFrom(pathMap, stringArray);
            return this;
        }

        default public PropertiesBuilder withMergeTo(Collection<?> collection, Object object) {
            this.mergeTo(collection, object);
            return this;
        }

        default public PropertiesBuilder withMergeTo(Collection<?> collection, PathMap<String> pathMap) {
            this.mergeTo(collection, pathMap);
            return this;
        }

        default public PropertiesBuilder withMergeTo(Object object, Object object2) {
            this.mergeTo(object, object2);
            return this;
        }

        default public PropertiesBuilder withMergeTo(Object object, PathMap<String> pathMap) {
            this.mergeTo(object, pathMap);
            return this;
        }

        default public PropertiesBuilder withMergeTo(Object[] objectArray, Object object) {
            this.mergeTo(objectArray, object);
            return this;
        }

        default public PropertiesBuilder withMergeTo(Object[] objectArray, PathMap<String> pathMap) {
            this.mergeTo(objectArray, pathMap);
            return this;
        }

        default public PropertiesBuilder withMergeTo(String string, Object object) {
            this.mergeTo(string, object);
            return this;
        }

        default public PropertiesBuilder withMergeTo(String string, PathMap<String> pathMap) {
            this.mergeTo(string, pathMap);
            return this;
        }

        default public PropertiesBuilder withMergeTo(String[] stringArray, Object object) {
            this.mergeTo(stringArray, object);
            return this;
        }

        default public PropertiesBuilder withMergeTo(String[] stringArray, PathMap<String> pathMap) {
            this.mergeTo(stringArray, pathMap);
            return this;
        }

        default public PropertiesBuilder withPutDirAt(Collection<?> collection, int n, Object object) throws IllegalArgumentException {
            this.putDirAt(collection, n, object);
            return this;
        }

        default public PropertiesBuilder withPutDirAt(Collection<?> collection, int n, PathMap<String> pathMap) throws IllegalArgumentException {
            this.putDirAt(collection, n, pathMap);
            return this;
        }

        default public PropertiesBuilder withPutDirAt(int n, Object object) throws IllegalArgumentException {
            this.putDirAt(n, object);
            return this;
        }

        default public PropertiesBuilder withPutDirAt(int n, PathMap<String> pathMap) throws IllegalArgumentException {
            this.putDirAt(n, pathMap);
            return this;
        }

        default public PropertiesBuilder withPutDirAt(Object object, int n, Object object2) throws IllegalArgumentException {
            this.putDirAt(object, n, object2);
            return this;
        }

        default public PropertiesBuilder withPutDirAt(Object object, int n, PathMap<String> pathMap) throws IllegalArgumentException {
            this.putDirAt(object, n, pathMap);
            return this;
        }

        default public PropertiesBuilder withPutDirAt(Object[] objectArray, int n, Object object) throws IllegalArgumentException {
            this.putDirAt(objectArray, n, object);
            return this;
        }

        default public PropertiesBuilder withPutDirAt(Object[] objectArray, int n, PathMap<String> pathMap) throws IllegalArgumentException {
            this.putDirAt(objectArray, n, pathMap);
            return this;
        }

        default public PropertiesBuilder withPutDirAt(String string, int n, Object object) throws IllegalArgumentException {
            this.putDirAt(string, n, object);
            return this;
        }

        default public PropertiesBuilder withPutDirAt(String string, int n, PathMap<String> pathMap) throws IllegalArgumentException {
            this.putDirAt(string, n, pathMap);
            return this;
        }

        default public PropertiesBuilder withPutDirAt(String[] stringArray, int n, Object object) throws IllegalArgumentException {
            this.putDirAt(stringArray, n, object);
            return this;
        }

        default public PropertiesBuilder withPutDirAt(String[] stringArray, int n, PathMap<String> pathMap) throws IllegalArgumentException {
            this.putDirAt(stringArray, n, pathMap);
            return this;
        }

        default public PropertiesBuilder withRemoveFrom(Collection<?> collection) {
            this.removeFrom(collection);
            return this;
        }

        default public PropertiesBuilder withRemoveFrom(Object object) {
            this.removeFrom(object);
            return this;
        }

        default public PropertiesBuilder withRemoveFrom(Object ... objectArray) {
            this.removeFrom(objectArray);
            return this;
        }

        default public PropertiesBuilder withRemoveFrom(String string) {
            this.removeFrom(string);
            return this;
        }

        default public PropertiesBuilder withRemoveFrom(String ... stringArray) {
            this.removeFrom(stringArray);
            return this;
        }

        default public PropertiesBuilder withRemovePaths(String ... stringArray) {
            this.removeFrom(stringArray);
            return this;
        }
    }

    public static interface MutableProperties
    extends Properties,
    CanonicalMap.MutableCanonicalMap {
        @Override
        default public boolean containsValue(Object object) {
            return this.values().contains(object);
        }

        default public String delete(Property property) {
            if (property != null) {
                return (String)this.remove(property.getKey());
            }
            return null;
        }

        default public void insert(Properties properties) {
            this.insert(properties);
        }

        default public void insertBetween(String string, Properties properties, String string2) {
            this.insertBetween(string, properties, string2);
        }

        default public void insertFrom(Properties properties, String string) {
            this.insertFrom(properties, string);
        }

        default public void insertTo(String string, Properties properties) {
            this.insertTo(string, properties);
        }

        default public String put(Relation<String, String> relation) {
            return (String)this.put((String)relation.getKey(), (String)relation.getValue());
        }

        default public void putAll(java.util.Properties properties) {
            for (Object object : properties.keySet()) {
                this.put((String)object, (String)properties.get(object));
            }
        }

        default public void putAll(Map<? extends String, ? extends String> map) {
            for (String string : map.keySet()) {
                this.put(string, map.get(string));
            }
        }

        default public void putAll(Properties properties) {
            for (Object e : properties.keySet()) {
                this.put((String)e, (String)properties.get((String)e));
            }
        }

        default public Properties putDirAt(Collection<?> collection, int n, Object object) throws IllegalArgumentException {
            return this.putDirAt(this.toPath(collection), n, object);
        }

        default public Properties putDirAt(Collection<?> collection, int n, PathMap<String> pathMap) throws IllegalArgumentException {
            return this.putDirAt(this.toPath(collection), n, (PathMap)pathMap);
        }

        default public Properties putDirAt(int n, Object object) throws IllegalArgumentException {
            return this.putDirAt(this.getRootPath(), n, object);
        }

        default public Properties putDirAt(int n, PathMap<String> pathMap) throws IllegalArgumentException {
            return this.putDirAt(this.getRootPath(), n, (PathMap)pathMap);
        }

        default public Properties putDirAt(Object object, int n, Object object2) throws IllegalArgumentException {
            return this.putDirAt(this.toPath(object), n, object2);
        }

        default public Properties putDirAt(Object object, int n, PathMap<String> pathMap) throws IllegalArgumentException {
            return this.putDirAt(this.toPath(object), n, (PathMap)pathMap);
        }

        default public Properties putDirAt(Object[] objectArray, int n, Object object) throws IllegalArgumentException {
            return this.putDirAt(this.toPath(objectArray), n, object);
        }

        default public Properties putDirAt(Object[] objectArray, int n, PathMap<String> pathMap) throws IllegalArgumentException {
            return this.putDirAt(this.toPath(objectArray), n, (PathMap)pathMap);
        }

        default public Properties putDirAt(String string, int n, Object object) throws IllegalArgumentException {
            Properties properties = this.removeDirAt(string, n);
            this.insertTo(this.toPath(new Object[]{string, n}), object);
            return properties;
        }

        default public Properties putDirAt(String string, int n, PathMap<String> pathMap) throws IllegalArgumentException {
            Properties properties = this.removeDirAt(string, n);
            this.insertTo(this.toPath(new Object[]{string, n}), pathMap);
            return properties;
        }

        default public Properties putDirAt(String[] stringArray, int n, Object object) throws IllegalArgumentException {
            return this.putDirAt(this.toPath(stringArray), n, object);
        }

        default public Properties putDirAt(String[] stringArray, int n, PathMap<String> pathMap) throws IllegalArgumentException {
            return this.putDirAt(this.toPath(stringArray), n, (PathMap)pathMap);
        }

        default public Properties removePaths(Collection<?> collection) {
            return new PropertiesImpl(super.removePaths(collection));
        }

        default public Properties removePaths(String ... stringArray) {
            return new PropertiesImpl(super.removePaths(stringArray));
        }

        default public Properties removeAll(String ... stringArray) {
            return new PropertiesImpl(super.removeAll(stringArray));
        }

        default public Properties removeAll(Object ... objectArray) {
            return new PropertiesImpl(super.removeAll(objectArray));
        }

        default public Properties removeAll(Collection<?> collection) {
            return new PropertiesImpl(super.removeAll(collection));
        }

        default public Properties removeAll(String string) {
            return new PropertiesImpl(super.removeAll(string));
        }

        default public Properties removeAll(Pattern pattern) {
            return new PropertiesImpl(super.removeAll(pattern));
        }

        default public Properties removeAll(Object object) {
            return new PropertiesImpl(super.removeAll(object));
        }

        default public Properties removeDirAt(int n) {
            return new PropertiesImpl(super.removeDirAt(n));
        }

        default public Properties removeDirAt(Object object, int n) {
            return new PropertiesImpl(super.removeDirAt(object, n));
        }

        default public Properties removeDirAt(Object[] objectArray, int n) {
            return new PropertiesImpl(super.removeDirAt(objectArray, n));
        }

        default public Properties removeDirAt(String string, int n) {
            return new PropertiesImpl(super.removeDirAt(string, n));
        }

        default public Properties removeDirAt(String[] stringArray, int n) {
            return new PropertiesImpl(super.removeDirAt(stringArray, n));
        }

        default public Properties removeFrom(Object ... objectArray) {
            return new PropertiesImpl(super.removeFrom(objectArray));
        }

        default public Properties removeFrom(Object object) {
            return new PropertiesImpl(super.removeFrom(object));
        }

        default public Properties removeFrom(String string) {
            return new PropertiesImpl(super.removeFrom(string));
        }

        default public Properties removeFrom(String ... stringArray) {
            return new PropertiesImpl(super.removeFrom(stringArray));
        }
    }
}

