/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.numerical;

import java.util.ArrayList;
import org.refcodes.numerical.CrcAlgorithmConfig;
import org.refcodes.numerical.CrcWidthAccessor;

public enum CrcSize implements CrcWidthAccessor
{
    CRC_8(1),
    CRC_16(2),
    CRC_32(4),
    CRC_64(8);

    private int _crcByteWidth;
    private CrcAlgorithmConfig[] _crcAlgorithms;

    private CrcSize(int n2) {
        ArrayList<CrcAlgorithmConfig> arrayList = new ArrayList<CrcAlgorithmConfig>();
        for (CrcAlgorithmConfig crcAlgorithmConfig : CrcAlgorithmConfig.values()) {
            if (crcAlgorithmConfig.getCrcWidth() != n2) continue;
            arrayList.add(crcAlgorithmConfig);
        }
        this._crcAlgorithms = arrayList.toArray(new CrcAlgorithmConfig[arrayList.size()]);
        this._crcByteWidth = n2;
    }

    @Override
    public int getCrcWidth() {
        return this._crcByteWidth;
    }

    public CrcAlgorithmConfig[] getCrcAlgorithms() {
        return this._crcAlgorithms;
    }

    public static CrcSize toCrcCategory(int n) {
        for (CrcSize crcSize : CrcSize.values()) {
            if (crcSize.getCrcWidth() != n) continue;
            return crcSize;
        }
        return null;
    }
}

