/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.graphical;

import java.awt.Color;
import org.refcodes.graphical.GraphicalUtility;
import org.refcodes.graphical.Pixmap;
import org.refcodes.graphical.RgbPixel;
import org.refcodes.graphical.RgbPixelImpl;

public interface RgbPixmap
extends Pixmap<RgbPixel> {
    default public int getRgbAt(int n, int n2) {
        RgbPixel rgbPixel = (RgbPixel)this.getPixelAt(n, n2);
        return GraphicalUtility.toRgb(rgbPixel.getAlpha(), rgbPixel.getRed(), rgbPixel.getGreen(), rgbPixel.getBlue());
    }

    default public Color getColorAt(int n, int n2) {
        RgbPixel rgbPixel = (RgbPixel)this.getPixelAt(n, n2);
        return rgbPixel != null ? rgbPixel.toColor() : null;
    }

    public static interface RgbPixmapBuilder
    extends Pixmap.PixmapBuilder<RgbPixel, RgbPixmapBuilder>,
    RgbPixmapProperty {
        default public RgbPixmapBuilder withRgbAt(int n, int n2, int n3) throws IndexOutOfBoundsException {
            this.setRgbAt(n, n2, n3);
            return this;
        }

        default public RgbPixmapBuilder withColorlAt(Color color, int n, int n2) throws IndexOutOfBoundsException {
            this.setColorAt(color, n, n2);
            return this;
        }
    }

    public static interface RgbPixmapProperty
    extends RgbPixmap,
    RgbPixmapMutator,
    Pixmap.PixmapProperty<RgbPixel> {
        @Override
        default public int letRgbAt(int n, int n2, int n3) {
            this.setRgbAt(n, n2, n3);
            return n;
        }

        default public Color letColorAt(Color color, int n, int n2) {
            this.setColorAt(color, n, n2);
            return color;
        }
    }

    public static interface RgbPixmapMutator
    extends Pixmap.PixmapMutator<RgbPixel> {
        default public void setRgbAt(int n, int n2, int n3) throws IndexOutOfBoundsException {
            this.setPixelAt(new RgbPixelImpl(n), n2, n3);
        }

        default public void setColorAt(Color color, int n, int n2) throws IndexOutOfBoundsException {
            this.setRgbAt(color.getRGB(), n, n2);
        }
    }
}

