/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.graphical;

import org.refcodes.graphical.PosXAccessor;
import org.refcodes.graphical.PosYAccessor;
import org.refcodes.graphical.PositionImpl;

public interface Position
extends PosXAccessor,
PosYAccessor {
    default public Position toAddTo(Position position) {
        return new PositionImpl(position.getPositionX() + this.getPositionX(), position.getPositionY() + this.getPositionY());
    }

    default public Position toSubFrom(Position position) {
        return new PositionImpl(this.getPositionX() - position.getPositionX(), this.getPositionY() - position.getPositionY());
    }

    public static boolean equals(Position position, Position position2) {
        return position.getPositionX() == position2.getPositionX() && position.getPositionY() == position2.getPositionY();
    }

    public static interface PositionProperty
    extends Position,
    PositionMutator,
    PosXAccessor.PosXProperty,
    PosYAccessor.PosYProperty {
        default public void addTo(Position position) {
            this.setPosition(position.getPositionX() + this.getPositionX(), position.getPositionY() + this.getPositionY());
        }

        default public void subFrom(Position position) {
            this.setPosition(this.getPositionX() - position.getPositionX(), this.getPositionY() - position.getPositionY());
        }

        default public Position letPosition(Position position) {
            this.setPosition(position);
            return position;
        }

        default public Position letPosition(final int n, final int n2) {
            this.setPosition(n, n2);
            return new Position(){

                @Override
                public int getPositionX() {
                    return n;
                }

                @Override
                public int getPositionY() {
                    return n2;
                }
            };
        }
    }

    public static interface PositionBuilder<B extends PositionBuilder<B>>
    extends PosXAccessor.PosXBuilder<B>,
    PosYAccessor.PosYBuilder<B>,
    PositionMutator {
        public B withPosition(int var1, int var2);

        public B withPosition(Position var1);
    }

    public static interface PositionMutator
    extends PosXAccessor.PosXMutator,
    PosYAccessor.PosYMutator {
        public void setPosition(int var1, int var2);

        public void setPosition(Position var1);
    }
}

