/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.graphical;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;

public final class GraphicalUtility {
    private GraphicalUtility() {
    }

    public static int toGray(int n) {
        return (GraphicalUtility.toRed(n) + GraphicalUtility.toGreen(n) + GraphicalUtility.toBlue(n)) / 3;
    }

    public static int toRgb(int n, int n2, int n3, int n4) {
        return (n << 24) + (n2 << 16) + (n3 << 8) + n4;
    }

    public static int toAlpha(int n) {
        return n >> 24 & 0xFF;
    }

    public static int toRed(int n) {
        return n >> 16 & 0xFF;
    }

    public static int toGreen(int n) {
        return n >> 8 & 0xFF;
    }

    public static int toBlue(int n) {
        return n & 0xFF;
    }

    public static Font getAwtFont(String string, int n, String string2, int n2) {
        Font font;
        int n3 = 5;
        Font font2 = null;
        int n4 = 0;
        do {
            if ((n4 = GraphicalUtility.toPixelWidth(string, font = new Font(string2, n2, n3))) < n) {
                font2 = font;
            }
            ++n3;
        } while (n4 < n);
        if (n4 == n) {
            return font;
        }
        if (font2 == null) {
            throw new IllegalArgumentException("Unable to determine the font size for font \"" + string2 + "\" with style \"" + n2 + "\" for text \"" + string + "\" to fit into a width of y <" + n + "> as the smallest font already exceeds this width with width <" + n4 + ">.");
        }
        return font2;
    }

    private static int toPixelWidth(String string, Font font) {
        int n;
        int n2;
        int n3;
        int n4 = 11;
        BufferedImage bufferedImage = new BufferedImage(1, 1, n4);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n5 = fontMetrics.stringWidth(string);
        int n6 = fontMetrics.getHeight();
        bufferedImage = new BufferedImage(n5, n6, n4);
        graphics = bufferedImage.getGraphics();
        graphics.setFont(font);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.drawString(string, 0, n6);
        int n7 = 0;
        int n8 = n5;
        block0: for (n3 = 0; n3 < n5; ++n3) {
            for (n2 = 0; n2 < n6; ++n2) {
                n = GraphicalUtility.toGray(bufferedImage.getRGB(n3, n2));
                if (n != 0) break block0;
            }
            n7 = n3 + 1;
        }
        block2: for (n3 = n5 - 1; n3 >= 0; --n3) {
            for (n2 = 0; n2 < n6; ++n2) {
                n = GraphicalUtility.toGray(bufferedImage.getRGB(n3, n2));
                if (n != 0) break block2;
            }
            n8 = n3 - 1;
        }
        n3 = n8 - n7 - 1;
        return n3;
    }
}

