/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.generator;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.util.Base64;
import org.refcodes.data.PaddingChar;
import org.refcodes.data.Text;
import org.refcodes.generator.IdGenerator;
import org.refcodes.numerical.NumericalUtility;

public class UniqueIdGenerator
implements IdGenerator {
    private static final int UUID_LENGTH = 36;
    private int _idLength;
    private IdEncoding _idEncoding;
    private static final byte[] IP_ADDRESS = new byte[2];
    private static long COUNTER = 0L;
    private static long SEED;

    public static void initSeed() {
        SEED = new SecureRandom().nextLong();
        try {
            byte[] ipAddress = InetAddress.getLocalHost().getAddress();
            UniqueIdGenerator.IP_ADDRESS[0] = ipAddress[ipAddress.length - 2];
            UniqueIdGenerator.IP_ADDRESS[1] = ipAddress[ipAddress.length - 1];
        }
        catch (UnknownHostException e) {
            new SecureRandom().nextBytes(IP_ADDRESS);
        }
    }

    public UniqueIdGenerator() {
        this(36, IdEncoding.BASE64_URL);
    }

    public UniqueIdGenerator(int aIdLength) {
        this(aIdLength, IdEncoding.BASE64_URL);
    }

    public UniqueIdGenerator(IdEncoding aIdEncoding) {
        this(36, aIdEncoding);
    }

    public UniqueIdGenerator(int aIdLength, IdEncoding aIdEncoding) {
        this._idLength = aIdLength;
        this._idEncoding = aIdEncoding;
    }

    @Override
    public boolean hasNext() {
        return true;
    }

    @Override
    public String next() {
        int theRemainingLength;
        String thePrefix = null;
        thePrefix = this._idEncoding.encoder.encodeToString(IP_ADDRESS);
        if (this._idLength <= (thePrefix = thePrefix.replaceAll("" + PaddingChar.BASE64.getChar(), "")).length()) {
            throw new IllegalStateException("The desired length of <" + this._idLength + "> is too short as the prefix \"" + thePrefix + "\" has already a length of <" + thePrefix.length());
        }
        Long theTime = System.currentTimeMillis();
        String theTimeString = null;
        theTimeString = this._idEncoding.encoder.encodeToString(NumericalUtility.toBytes((long)theTime));
        theTimeString = theTimeString.replaceAll("" + PaddingChar.BASE64.getChar(), "");
        String theSeedString = null;
        while (theSeedString == null || theSeedString.isEmpty()) {
            theSeedString = this._idEncoding.encoder.encodeToString(NumericalUtility.toBytes((long)SEED++));
            if ((theSeedString = theSeedString.replaceAll("" + PaddingChar.BASE64.getChar(), "")) != null && !theSeedString.isEmpty()) continue;
            UniqueIdGenerator.initSeed();
        }
        if (this._idLength <= 4) {
            thePrefix = "";
        }
        int theSeedLength = 4;
        if (this._idLength <= 6) {
            theSeedLength -= 7 - this._idLength;
        }
        if (theSeedString.length() > theSeedLength) {
            theSeedString = theSeedString.substring(theSeedString.length() - theSeedLength);
        }
        if ((theRemainingLength = this._idLength - (theSeedString.length() + thePrefix.length())) < 0) {
            throw new IllegalStateException("Cannot create an TID of length <" + this._idLength + "> as we are short of <" + Math.abs(theRemainingLength) + "> digits; enlarge your length accordinbgly.");
        }
        if (theTimeString.length() >= theRemainingLength) {
            int beginIndex = theTimeString.length() - theRemainingLength;
            return thePrefix + theSeedString + theTimeString.substring(beginIndex);
        }
        String theCounterHead = thePrefix + theSeedString + theTimeString;
        String theCounterTail = this._idEncoding.encoder.encodeToString(NumericalUtility.toBytes((long)COUNTER++));
        if ((theCounterTail = theCounterTail.replaceAll("" + PaddingChar.BASE64.getChar(), "")).length() != (theRemainingLength -= theTimeString.length())) {
            if (theCounterTail.length() > theRemainingLength) {
                theCounterTail = theCounterTail.substring(0, theRemainingLength);
            } else {
                StringBuilder theBuffer = new StringBuilder();
                theBuffer.append(theCounterTail);
                for (int i = 0; i < theRemainingLength - theCounterTail.length(); ++i) {
                    theBuffer.append('0');
                }
                theCounterTail = theBuffer.toString();
            }
        }
        return theCounterHead + theCounterTail;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException(Text.UNSUPPORTED_OPERATION.getText());
    }

    static {
        UniqueIdGenerator.initSeed();
    }

    public static enum IdEncoding {
        BASE64(Base64.getEncoder()),
        BASE64_URL(Base64.getUrlEncoder());

        final Base64.Encoder encoder;

        private IdEncoding(Base64.Encoder aEncoder) {
            this.encoder = aEncoder;
        }
    }
}

